pro TILTLAUE,ref,parameters
;+
; NAME:
;	TILTLAUE
;
; PURPOSE:
;
;	Correct a reflection list produced by GENLAUE for twist, tilt and 
;	bulge
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	TILTLAUE, ref,parameters
;
; INPUTS:
;	ref : a reflection list produced with the 'reflist.pro' routine
;	      from LAUEGEN
;	parameters : the parameters from the Laue experiment (produced by
;		reflist.pro)
;
; OUTPUTS:
;	The reflection list ref is modified for the fields x and y
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Follows the GENLAUE procedure
;
; MODIFICATION HISTORY:
;	D.Bourgeois, January 1994.
;-


PI = 3.1416
bulge = 0.01*parameters.bulge*pi/180.0
twist =  0.01*parameters.twist*pi/180.0
tilt =  0.01*parameters.tilt*pi/180.0

;pix_size = 0.001*parameters.raster

sizeref = (SIZE(ref))(1)
;initial position [pixels]
;K array
K = FLTARR(sizeref)
;K = 1 + tilt*ref(*).x/pix_size + twist*ref(*).y/pix_size + $
;		bulge*SQRT((ref(*).x/pix_size)^2 + (ref(*).y/pix_size)^2)

K = 1 + (tilt*ref(*).x + twist*ref(*).y + $
		bulge*SQRT((ref(*).x)^2 + (ref(*).y)^2))/parameters.cdd

;corrected positions
ref(*).x = K(*)*ref(*).x
ref(*).y = K(*)*ref(*).y



END