
;utility function to search a font
FUNCTION XFINDFONT, FontNames
; See if a font can be found. FontNames = an array of font names.  On exit
; the function value is either the first found font, or the null string.

FOR i=0, N_ELEMENTS(FontNames)-1 DO BEGIN ;Search for a font
    DEVICE, FONT=FontNames(i), GET_FONTNUM=fontnum, GET_FONTNAME=s
    IF FONTNUM GT 0 THEN RETURN, s(0)
ENDFOR
RETURN, ''                      ;Couldn't find the font.
END


PRO PROW_EVENT,event


CATCH,error
;error=0
IF error NE 0 THEN BEGIN
 CATCH,/CANCEL
 IF NOT N_ELEMENTS(state) THEN WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY 
 draw_image=state.draw_image
 WIDGET_CONTROL,state.info,SET_VALUE='Error ! You can continue working ...'
 ;resensitize PROW widgets 
 print,'Error from MAIN PROGRAM !'
 ok = WIDGET_MESSAGE(['Screw up ! Sorry, something wrong happened (Main menu).','Follows the error message : ',!Err_String],/ERROR)

 WIDGET_CONTROL,state.info,SET_VALUE='Info ...'
 WIDGET_CONTROL,state.prow_base,SENSITIVE=1
 WIDGET_CONTROL,state.draw_image,SENSITIVE=1
 WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY 

 IF N_ELEMENTS(image_state) THEN $
  WIDGET_CONTROL, WIDGET_INFO(draw_image,/CHILD), SET_UVALUE=image_state
  event.id=0

ENDIF

parent=event.handler
child=WIDGET_INFO(parent,/CHILD)

;get the state
WIDGET_CONTROL,child,GET_UVALUE=state ,/NO_COPY
;get the state from PROW_DRAW
WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY

CASE event.id OF
	state.but_done: $
	     WIDGET_CONTROL,event.top,/DESTROY
   	
	state.but_help: $
	     BEGIN
  	      helpfile=STRCOMPRESS(GETENV('PROW_HELP')+'/'+'README',/REMOVE_ALL)
 	      XDISPLAYFILE,helpfile,GROUP=event.top
	     END

	state.pull_load: $
	     BEGIN
		DRAW_PULL_LOAD,state,image_state,event
	     END

	state.but_next: $
		BEGIN
		 DRAW_NEXT_IMAGE,state,image_state
		END	

	state.but_prev: $
		BEGIN
		 DRAW_NEXT_IMAGE,state,image_state,/PREV
		END	

	state.pull_color: $
	     BEGIN
		DRAW_PULL_COLOR,state,image_state,event
	     END

	state.pull_diff: $
	     BEGIN
		DRAW_PULL_DIFF,state,image_state,event
	     END


	state.but_det: $
		BEGIN
		field={gain:state.det_par.gain,offset:state.det_par.offset,$
			dark_current:state.det_par.dark_current,satvalue:state.det_par.satvalue}
		field_title=['Gain [at 1.54 A] : ','Offset [ADU] : ','Dark current [ADU] : ','Saturation value [ADU] : ']
		XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,ACTION=action
		IF action EQ 'DO' THEN BEGIN
		 state.det_par.gain=field.gain
		 state.det_par.offset=field.offset
		 state.det_par.dark_current=field.dark_current
		 state.det_par.satvalue=field.satvalue
		ENDIF
		END	

	state.but_print: BEGIN
		 IF image_state.draw_win NE -1 THEN DRAW_PRINT,state,image_state
			 END

	state.pull_integ: $
	     BEGIN
		DRAW_PULL_INTEG,state,image_state,event
	     END

	state.field_dir: $
	     BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=working_dir
		state.working_dir=working_dir(0)
	     END

	ELSE : WIDGET_CONTROL,state.info,SET_VALUE='Info : '
	   
ENDCASE


IF (event.id NE state.but_done) THEN BEGIN
 ;swallow the image_state
 WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY
 ;swallow the state
 WIDGET_CONTROL,child,SET_UVALUE=state ,/NO_COPY
ENDIF

END

PRO PROW,file=file,xs=xs,ys=ys,scrx=scrx,scry=scry,format=format,frelon=frelon,no_catch=no_catch
;
;+
; NAME:
;	PROW
;
; PURPOSE:
;	Widget application diffracttion images.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	PROW,[file=file],[xs=xs],[ys=ys],[scrx=scrx],[scry=scry],[format=format],[frelon=frelon],[no_catch=no_catch]
;
; INPUTS:
;	file :[optional][keyword] the filename of an image
;	xs : [optional] the xsize of the image to read in. Default = 1152
;	ys : [optional] the ysize of the image to read in. Default = 1242
;	scrx : [optional] the xscroll size of the main image window. Default = 500
;	scry : [optional] the yscroll size of the main image window. Default = 500
;	format : [optional] the format of the image. Default = mar18
;	frelon : set this keyword if the frelon camera is used.
;	no_catch : [optional] set this keyword for letting PROW crash in case of problem
;			ie : PROW will stop and displays explicitely the origin of the problem.
;			NOT IMPLEMENTED YET.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-


prow_version = 'PROW VSN:1.3.3 '

;GET info about the system and set environement variables :

;FOR ENCAPSULATED VERSION
encapsulated=1

IF encapsulated THEN BEGIN
 SETENV,'PROW_SCR='+getenv('XOP_HOME')+'/extensions/PROW/SCR/'
 SETENV,'PROW_HELP='+getenv('XOP_HOME')+'/extensions/PROW/HELP/'
 CASE !version.os OF
  'hp-ux' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/HPUX/'
	    END
  'IRIX' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/SGI/'
	   END
  'sunos' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/SUN/'
	   END
  'linux' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/LINUX/'
	   END
  'OSF' : BEGIN
		SETENV,'PROW_C='+getenv('XOP_HOME')+'/extensions/PROW/DEC/'
	   END
   ELSE : MESSAGE,'Unsupported OPERATING SYSTEM !'
 ENDCASE
ENDIF

;FOR NORMAL VERSION
;CASE !version.os OF
; 'hp-ux' : SETENV,'PROW_C='+getenv('PROW_HOME')+'/cprog/SRC/HPUX'
; 'IRIX' : SETENV,'PROW_C='+getenv('PROW_HOME')+'/cprog/SRC/SGI'
; 'sunos' : SETENV,'PROW_C='+getenv('PROW_HOME')+'/cprog/SRC/SUN'
;  ELSE : MESSAGE,'Unsupported OPERATING SYSTEM !'
;ENDCASE

;define a font + character size
save_wind = !D.Window
WINDOW, /FREE, XSIZE=4, YSIZE=4, /PIXMAP, RETAIN=2 ; just a trick
pix_win = !D.WINDOW
;Font = XFINDFONT(['-adobe-helvetica-medium-r-normal--14-*-*-*','9x15'])
Font = XFINDFONT(['-adobe-helvetica-medium-r-normal--12-*-*-*','7x13'])
DEVICE,SET_CHARACTER_SIZE=[6,9]
;DEVICE,SET_CHARACTER_SIZE=[2,5]

WDELETE, pix_win
WSET, save_wind
IF (font ne '') THEN WIDGET_CONTROL, DEFAULT_FONT= Font

IF NOT KEYWORD_SET(format) THEN file_format='mar18' ELSE file_format=format

IF KEYWORD_SET(no_catch) THEN no_catch=1 ELSE no_catch=0

CASE file_format OF 
 'binary2' : BEGIN
	     IF KEYWORD_SET(frelon) THEN xsize=1024 ELSE xsize=1152 ;xsize=1440
	     IF KEYWORD_SET(frelon) THEN ysize=1024 ELSE ysize=1242 ;ysize=1520
	     bin_fac=2
	    END

 'binary4' : BEGIN
	     IF KEYWORD_SET(frelon) THEN xsize=1024 ELSE xsize=1152 ;xsize=1440
	     IF KEYWORD_SET(frelon) THEN ysize=1024 ELSE ysize=1242 ;ysize=1520
	     bin_fac=2
	    END

 'esrf' :   BEGIN
	     IF KEYWORD_SET(frelon) THEN xsize=1024 ELSE xsize=1152
	     IF KEYWORD_SET(frelon) THEN ysize=1024 ELSE ysize=1242
	     bin_fac=2
	    END

 'esrf_long' :   BEGIN
	     IF KEYWORD_SET(frelon) THEN xsize=1024 ELSE xsize=1152
	     IF KEYWORD_SET(frelon) THEN ysize=1024 ELSE ysize=1242
	     bin_fac=2
	    END

 'edf' :   BEGIN
	     xsize=4000
	     ysize=2000
	     bin_fac=4
	    END

 'mar18' :  BEGIN
	     xsize=1200
	     ysize=1200
	     bin_fac=2
	    END

 'mar30' :  BEGIN
	     xsize=2000
	     ysize=2000
	     bin_fac=4
	    END

 'marccd' : BEGIN
	     xsize=2048
	     ysize=2048
	     bin_fac=4
	    END

; 'marccdswap' : BEGIN
;	     xsize=2048
;	     ysize=2048
;	     bin_fac=4
;	    END

 'adscQ4' :   BEGIN
	     xsize=2304
	     ysize=2304
	     bin_fac=4
	    END

 'adscQ315' :   BEGIN
	     xsize=3072
	     ysize=3072
	     bin_fac=4
	    END

 'mar345' : BEGIN
	     xsize=2300
	     ysize=2300
	     bin_fac=4
	    END

 'raxis' : BEGIN
	     xsize=3000
	     ysize=3000
	     bin_fac=4
	    END

 else :      MESSAGE,'Unknown format !'

ENDCASE

;maybe the size + scroll sizes are defined by keywords.
IF NOT KEYWORD_SET(xs) THEN xsize=xsize ELSE xsize=xs
IF NOT KEYWORD_SET(ys) THEN ysize=ysize ELSE ysize=ys

bin_scale=1.6

IF NOT KEYWORD_SET(scrx) THEN x_scroll=FIX(xsize/(bin_scale*bin_fac)) ELSE x_scroll=scrx
IF NOT KEYWORD_SET(scry) THEN y_scroll=FIX(ysize/(bin_scale*bin_fac)) ELSE y_scroll=scry
 
;A main base is defined
prow_base=WIDGET_BASE(/COLUMN,TITLE='')

;A sub-base1 is defined
prow_subbase1=WIDGET_BASE(prow_base,/ROW)


;A pull down menu is defined to load images and change formats
junk={CW_PDMENU_S,flags:0,name:''}
load_items = [	{CW_PDMENU_S,1,'LOAD'}, $
		{CW_PDMENU_S,0,'LOAD FILE'}, $
		{CW_PDMENU_S,1,'FILE FORMAT'}, $
		{CW_PDMENU_S,0,'MAR (18 cm)'}, $
		{CW_PDMENU_S,0,'MAR (30 cm)'}, $
		{CW_PDMENU_S,0,'MAR345'}, $
		{CW_PDMENU_S,0,'MARCCD'}, $
		{CW_PDMENU_S,0,'ADSC   (Q4)'}, $
		{CW_PDMENU_S,0,'ADSC   (Q315 binned)'}, $
		{CW_PDMENU_S,0,'PRINCETON/XRII ESRF_FORMAT (2-BYTES)'}, $
		{CW_PDMENU_S,0,'PRINCETON/XRII ESRF_FORMAT (4-BYTES)'}, $
		{CW_PDMENU_S,0,'PRINCETON/XRII BINARY_FORMAT (2-BYTES)'}, $
		{CW_PDMENU_S,0,'PRINCETON/XRII BINARY_FORMAT (4-BYTES)'}, $
		{CW_PDMENU_S,0,'FRELON/XRII ESRF_FORMAT (2-BYTES)'}, $
		{CW_PDMENU_S,0,'FRELON/XRII BINARY_FORMAT (2-BYTES)'}, $
		{CW_PDMENU_S,0,'FRELON/XRII BINARY_FORMAT (4-BYTES)'}, $
		{CW_PDMENU_S,0,'EDF (LARGE IMAGE PLATE)'}, $
		{CW_PDMENU_S,0,'RAXIS'}, $
		{CW_PDMENU_S,2,'USER DEFINED BINARY FORMAT'}, $
		{CW_PDMENU_S,0,'CHANGE ZOOM WINDOW SIZE'}, $
		{CW_PDMENU_S,2,'CHANGE STUDY WINDOW SIZE'} $
     	      ]

pull_load = CW_PDMENU(prow_subbase1,load_items,/RETURN_INDEX)

;A button is defined to load next image
but_next=WIDGET_BUTTON(prow_subbase1,value='NEXT')

;A button is defined to load previous image
but_prev=WIDGET_BUTTON(prow_subbase1,value='PREVIOUS')

;A pull down menu is defined to adjust colors
junk={CW_PDMENU_S,flags:0,name:''}
color_items = [	{CW_PDMENU_S,1,'COLORS'}, $
		{CW_PDMENU_S,0,'B/W (Saturated in red)'}, $
		{CW_PDMENU_S,2,'Other colors'} $
     	      ]
pull_color = CW_PDMENU(prow_subbase1,color_items,/RETURN_INDEX)

;A pull down menu is defined to adjust diffraction parameters
junk={CW_PDMENU_S,flags:0,name:''}
diff_items = [	{CW_PDMENU_S,1,'DIFFRACTION'}, $
		{CW_PDMENU_S,0,'Enter/View diffraction parameters'}, $
		{CW_PDMENU_S,0,'Define beam center with mouse'}, $
		{CW_PDMENU_S,0,'Define beam center from circle'}, $
		{CW_PDMENU_S,0,'Resolution circles On/Off'}, $
		{CW_PDMENU_S,0,'Estimate cell parameters'}, $
		{CW_PDMENU_S,0,'Superimpose several images'}, $
		{CW_PDMENU_S,2,'Combine two images'} $
        ]
pull_diff = CW_PDMENU(prow_subbase1,diff_items,/RETURN_INDEX)

;A button is defined to define detector parameters
but_det=WIDGET_BUTTON(prow_subbase1,value='DETECTOR PARAMETERS')

;A button is defined to print images
but_print=WIDGET_BUTTON(prow_subbase1,value='PRINT')

;A pull down menu is defined to launch integration
junk={CW_PDMENU_S,flags:0,name:''}
integ_items = [	{CW_PDMENU_S,1,'INTEGRATION'}, $
		{CW_PDMENU_S,1,'Integration mode'}, $
		{CW_PDMENU_S,0,'Laue (Hard Limits)'}, $
		{CW_PDMENU_S,0,'Laue (Soft Limits)'}, $
		{CW_PDMENU_S,2,'Monochromatic'}, $
		{CW_PDMENU_S,1,'Integration parameters'}, $
		{CW_PDMENU_S,0,'Enter/View parameters'}, $
		{CW_PDMENU_S,0,'Save parameters'}, $
		{CW_PDMENU_S,2,'Load parameters'}, $
		{CW_PDMENU_S,1,'Convertion parameters'}, $
		{CW_PDMENU_S,0,'Enter/View parameters'}, $
		{CW_PDMENU_S,0,'Save parameters'}, $
		{CW_PDMENU_S,2,'Load parameters'}, $
		{CW_PDMENU_S,0,'Estimate boxsize and overlap distance'}, $
		{CW_PDMENU_S,0,'Restrain fitting area'}, $
		{CW_PDMENU_S,1,'Define masks'}, $
		{CW_PDMENU_S,0,'Define on main'}, $
		{CW_PDMENU_S,0,'Define on zoom'}, $
		{CW_PDMENU_S,2,'Apply a maks'}, $
		{CW_PDMENU_S,0,'Integrate'}, $
		{CW_PDMENU_S,2,'Convert'} $
        ]
pull_integ = CW_PDMENU(prow_subbase1,integ_items,/RETURN_INDEX)

;A button is defined for getting help
but_help=WIDGET_BUTTON(prow_subbase1,value='HELP')

;A button is defined to terminate the program
but_done=WIDGET_BUTTON(prow_subbase1,value='EXIT')

;A sub-base2 is defined
prow_subbase2=WIDGET_BASE(prow_base,/ROW)

;A field is defined containing the directory where the images are located
field_dir=CW_FIELD(prow_subbase2,/STRING,VALUE=GETENV('DATA'),TITLE='Data directory',/RETURN_EVENTS)

;A label is defined containing the filename of the current image
field_file=WIDGET_LABEL(prow_subbase2,/ALIGN_LEFT,SCR_YSIZE=35,SCR_XSIZE=350,VALUE='Current image : ')

;A label is defined containing some information
label_info = WIDGET_LABEL(prow_base, VALUE = 'Info : ',/ALIGN_LEFT,YSIZE=20,XSIZE=600)

;A draw CW is defined where the image is displayed and analysed.
draw_image = PROW_DRAW(prow_base,xsize=xsize/bin_fac,ysize=ysize/bin_fac,bin_fac=bin_fac,x_scroll_size=x_scroll,y_scroll_size=y_scroll)

;Visualize the application
WIDGET_CONTROL,prow_base,/REALIZE      

;Define the state
state=	{	but_done:but_done,$
		but_help:but_help,$
		pull_load:pull_load,$
		but_next:but_next,$
		but_prev:but_prev,$
		but_print:but_print,$
		pull_color:pull_color,$
		pull_diff:pull_diff,$
		pull_integ:pull_integ,$
		but_det:but_det,$
		prow_title:'',$
		prow_version:prow_version,$
		image_type:file_format,$
		no_catch:no_catch,$
		diff_par:{distance:100.,cenx:xsize/2.,ceny:xsize/2.,raster:150.,lambda:1.54},$
		diff_integ:{	$
			integ_mode	:'mono',$
			logdir		: GETENV('DATA'), $
			logfile		: 'test.log', $
			denzo_format	: 'york', $
			xdir		: GETENV('DATA'), $
			xfile		: 'test_###.x', $
			loc_refine	: 0, $
			prowdir		: GETENV('DATA'), $
			prowfile	: 'test_###.prow', $	
			reffile		: 'test_###.ref', $	
			datadir		:  GETENV('DATA'), $
			datafile	: 'test_###.image', $
			first		: 1 , $
			last		: 1 , $
			skip		: 0 , $
			data_skipped	: '', $

			exclude 	: 1 , $
		        normalization_curve 	: STRTRIM(GETENV('DATA')+'norm_curve.idl') , $
	  		complete_data_file 	: STRTRIM(GETENV('DATA')+'complete_mono_data.idl') , $
	  		b_factor 	: 15.0 , $
	  		exclude_threshold 	: 5.0 , $

			detector	: 'small_mar', $
			res_lim		: '30 2',  $
			xsize		: 2000 , $
			ysize		: 2000 , $
			raster		: 150.  , $
			set_bsmask	: 0, $
			bs_maskfile	: STRTRIM(GETENV('DATA')+'bs_mask.idl'), $
			set_mask	: 0, $
			maskfile	: STRTRIM(GETENV('DATA')+'mask.idl'), $
			boxsize		: {x:17,y:17}, $
			set_region	: 0, $
			n_sectors	: 18, $
			regionfile	: STRTRIM(GETENV('DATA')+'region.idl'), $
			bc_extend	: 1 , $
			use_old_ref	: 0 , $
			second_interp	: 0 , $
			ovlp_dist	: 1.0  , $
			ovlp_min_dist	: 0.25 , $
			ovlp_ref_dist	: 1.2  , $
			satvalue	: 65534L , $
			det_offset	: 0 , $
			det_gain	: 1.2 , $
			bg_percentage	: 25 , $
			bg_max_slope	: 5000. , $
			max_ref_spots	: 300 , $
			min_ref_spots	: 25 , $
			min_isigi	: 3.0 , $
			use_partials	: 1 , $
			max_osc_distance: 5 , $	
			rad_distance	: 50 , $
			ang_width	: 30 , $
			sym_search	: 0 , $
			show_image	: 1 , $
			show_ref	: 0 , $
			show_strong	: 0 , $
			show_weak	: 0 , $
			show_ovlp	: 0 , $
			show_m		: 0 , $
			miller		: '1 1 1'  $
			   },	$
		diff_denzox:{	$
			integ_mode	:'mono',$
			logdir		: GETENV('DATA'), $
			logfile		: 'denzox.log', $
			xdir		: GETENV('DATA'), $
			xfile		: 'test_###.x', $
			outxdir		: GETENV('DATA'), $
			outxfile	: 'test_prow_###.x', $
			denzo_format	: 'york', $
			prowdir		: GETENV('DATA'), $
			prowfile	: 'test_###.prow', $	
			first		: 1 , $
			last		: 1 , $
			skip		: 0 , $
			data_skipped	: [1] , $
			combine		: 1, $
			rm_ovlp		: 0, $
			rm_mult		: 0, $
			rm_excluded	: 0, $
			rm_largerms	: 0, $
			rm_outliers	: 0, $
			keep_lowres	: 3., $
			scaledown	: 0., $
			set_zero	: 0, $
			set_neg_thres	: -5000, $
			save_limited	: 0, $
			savegeasc	: 0, $
			rmin		: 0., $
			rmax		: 10000. $
			   },	$
		integ:{file:GETENV('DATA')},$
		denzox:{file:GETENV('DATA')},$
		det_par:{gain:2.,offset:0,dark_current:0,satvalue:65535L},$
		info:label_info,$
		prow_base:prow_base,$
		field_dir:field_dir,$
		field_file:field_file,$
		res_circles:0,$  ;0 is off
		draw_image:draw_image,$
		print:{file:STRCOMPRESS(GETENV('HOME')+'/tmp/tmp.ps',/REMOVE_ALL)},$
		file:{current:'',generic:'###',first:0,last:0},$
		working_dir:GETENV('DATA') $
	}

;An image file can be entered directly
IF KEYWORD_SET(file) THEN BEGIN
	dummy=FINDFILE(file,COUNT=ct_file)
	IF ct_file EQ 0 THEN  WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...' ELSE $
	  BEGIN
		WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY
		state.file.current=file
		DRAW_LOAD,state,image_state,/ADJUST_FORMAT
		WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY
	  ENDELSE
ENDIF

state.prow_title=state.prow_version+STRCOMPRESS('('+state.diff_denzox.integ_mode+') ')+STRUPCASE(state.image_type)
WIDGET_CONTROL,state.prow_base,TLB_SET_TITLE=state.prow_title


;Put the state in the user value of the first child
WIDGET_CONTROL, WIDGET_INFO(prow_base, /CHILD), SET_UVALUE=state, /NO_COPY

;And start Xmanager.
XMANAGER,'prow',prow_base

END


