PRO DRAW_STATISTICS_EVENT,event

WIDGET_CONTROL,event.id,GET_UVALUE=uval

IF uval THEN WIDGET_CONTROL,event.top,/DESTROY

END




PRO DRAW_STATISTICS, image_state,GROUP=group, FULL=full
;+
; NAME:
;	DRAW_STATISTICS
;
;
; PURPOSE:
;	Get some statistics from an image, displayed in a WIDGET_TEXT.
;
; CATEGORY:
;	Image processing.
;
; CALLING SEQUENCE:
;	Result = DRAW_STATISTICS(image_state,GROUP=group,[/Full])
;
; INPUTS:
;	Image_state:	The PROW image state
;
; KEYWORD PARAMETERS:
;	Group : the id of the caller.
;	Full : [optional] If set, use the full image instead of the zoom image.
;
; OUTPUTS:
;	None
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;
; MODIFICATION HISTORY:
;       May 1997 : Dominique Bourgeois
;-

IF NOT KEYWORD_SET(full) THEN $
 image = *image_state.zoom_image $
ELSE $
 image = *image_state.orig_image

max_red = MAX(image,MIN=min_red)
sig_red = STDEV(image,mean_red)
tot_red = TOTAL(image)
PRINT,'Number of pixels : ',(SIZE(image))(4)
PRINT,'Maximum count : ', max_red
PRINT,'Minimum count : ', min_red
PRINT,'Mean count : ', mean_red
PRINT,'Standard deviation count : ', sig_red




;plot an histogram
current_win=!D.WINDOW
WSET,image_state.study_win
hist = HISTOGRAM(image,BINSIZE=1>((max_red-min_red)/512.))
histx = min_red+INDGEN((SIZE(hist))(1))*(1>((max_red-min_red)/512.))
PLOT_OO,histx,hist>1,XTITLE='Pixel values',YTITLE='Number of pixels',TITLE='Density Histogram',$
 XRANGE=[min_red,max_red],XSTYLE=1
WSET,current_win

stats = STRARR(5)
stats(0) = 'Number of pixels : ' + STRING((SIZE(image))(4))
stats(1) = 'Maximum count : ' + STRING(max_red)
stats(2) = 'Minimum count : ' + STRING(min_red)
stats(3) = 'Mean count : ' + STRING(mean_red)
stats(4) = 'Standard deviation count : ' + STRING(sig_red)

;create the text widget.
stat_base = WIDGET_BASE(col=1,TITLE='Statistics')
stat_text = WIDGET_TEXT(stat_base,value=stats,YSIZE=5)
stat_done = WIDGET_BUTTON(stat_base,value='DONE',UVALUE=1)

WIDGET_CONTROL,stat_base,/REALIZE        ;visualize the widget

XMANAGER,"DRAW_STATISTICS",stat_base,GROUP_LEADER = GROUP,/MODAL

END




