FUNCTION DRAW_SELECT_HKL,pred,hkl_sel,n_found
;+
; NAME:
;	DRAW_SELECT_HKL.PRO
;
; PURPOSE:
;	Selects out certain hkl reflexions
;
; CATEGORY:
;	Crystallography processing.
;
; CALLING SEQUENCE:
;	pred_ok = DRAW_SELECT_HKL(pred,hkl_sel,n_found)
;
; INPUTS:
;	pred : input structure containing all potential reflexions. Should contain field .m
;	hkl_sel : a STRING containing which hkl to select 
;		(Exemple : '6,2k,2l+1')
; OUTPUTS:
;	n_found : number of found reflexions
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;
; MODIFICATION HISTORY:
;	Dominique Bourgeois, May 97.
;-


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


;hkl=''
h='' & k='' & l=''
hp=0 & kp=0 & lp=0
hf=0 & kf=0 & lf=0

;PRINT,'Input format : [h,k,l] or [nh[+1],nk[+1],nl[+1]]
;PRINT,'               or [0,0,0] to finish) : '
;PRINT,'Example :      4,2k+1,4l] '
;READ,'Input h,k,l : ',hkl
hkl=STRCOMPRESS(hkl_sel,/REMOVE_ALL)
h=STRMID(hkl,0,STRPOS(hkl,','))
k=STRMID(hkl,STRPOS(hkl,',')+1,RSTRPOS(hkl,',')-STRPOS(hkl,',')-1)
l=STRMID(hkl,RSTRPOS(hkl,',')+1,STRLEN(hkl)-RSTRPOS(hkl,',')-1)

;h=STRCOMPRESS('0'+h) & k=STRCOMPRESS('0'+k) & l=STRCOMPRESS('0'+l)

IF h EQ '0' AND k EQ '0' AND l EQ '0' THEN BEGIN
RETURN,0
ENDIF

IF STRPOS(h,'h') NE -1 THEN BEGIN
hn = FIX(STRMID(h,0,STRPOS(h,'h')))>1
IF STRMID(h,STRLEN(h)-2,1) EQ '+' OR STRMID(h,STRLEN(h)-2,1) EQ '-' THEN hp=1
wh = WHERE((FIX(ABS(pred.m(0)))/hn)*hn+hp EQ FIX(ABS(pred.m(0))) ,cth)
IF cth NE 0 THEN preds=pred(wh) ELSE BEGIN
PRINT,'No such reflexion !'
GOTO,give_up_select
ENDELSE
ENDIF ELSE BEGIN
hf=h
wh = WHERE(pred.m(0) EQ hf ,cth)
IF cth NE 0 THEN preds=pred(wh) ELSE BEGIN
PRINT,'No such reflexion !'
GOTO,give_up_select
ENDELSE
ENDELSE

IF STRPOS(k,'k') NE -1 THEN BEGIN
kn = FIX(STRMID(k,0,STRPOS(k,'k')))>1
IF STRMID(k,STRLEN(k)-2,1) EQ '+' OR STRMID(k,STRLEN(k)-2,1) EQ '-' THEN kp=1
wk = WHERE((FIX(ABS(preds.m(1)))/kn)*kn+kp EQ FIX(ABS(preds.m(1))) ,ctk)
IF ctk NE 0 THEN preds=preds(wk) ELSE BEGIN
PRINT,'No such reflexion !'
GOTO,give_up_select
ENDELSE
ENDIF ELSE BEGIN
kf=k
wk = WHERE(preds.m(1) EQ kf ,ctk)
IF ctk NE 0 THEN preds=preds(wk) ELSE BEGIN
PRINT,'No such reflexion !'
GOTO,give_up_select
ENDELSE
ENDELSE

IF STRPOS(l,'l') NE -1 THEN BEGIN
ln = FIX(STRMID(l,0,STRPOS(l,'l')))>1
IF STRMID(l,STRLEN(l)-2,1) EQ '+' OR STRMID(l,STRLEN(l)-2,1) EQ '-' THEN lp=1
wl = WHERE((FIX(ABS(preds.m(2)))/ln)*ln+lp EQ FIX(ABS(preds.m(2))) ,ctl)
IF ctl NE 0 THEN preds=preds(wl) ELSE BEGIN
PRINT,'No such reflexion !'
GOTO,give_up_select
ENDELSE
ENDIF ELSE BEGIN
lf=l
wl = WHERE(preds.m(2) EQ lf ,ctl)
IF ctl NE 0 THEN preds=preds(wl) ELSE BEGIN
PRINT,'No such reflexion !'
GOTO,give_up_select
ENDELSE
ENDELSE

n_found=ctl
RETURN,preds
give_up_select :
n_found=0
RETURN,0


END


