pro DRAW_PULL_LOAD,state,image_state,event
;+
; NAME:
;	DRAW_PULL_LOAD
;
; PURPOSE:
;	Manages load pull down menu.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_PULL_LOAD,state,image_state,event
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW
;	event: the event related to the choice in the pull down menu
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1998.
;-

COMMON SHARE_PROW,pred,sel_pred,par


CASE event.value OF 
 1 : BEGIN ; Load a file
	DRAW_LOAD,state,image_state,/PICK,/ADJUST_FORMAT
	GOTO,end_of_routine
     END

 3 : BEGIN ; Change the format MAR 18 cm
	state.image_type='mar18'
	image_state.x_im_sz=1200
	image_state.y_im_sz=1200
	image_state.bin_fac=2
     END

 4 : BEGIN ; Change the format MAR 30 cm
	state.image_type='mar30'
	image_state.x_im_sz=2000
	image_state.y_im_sz=2000
	image_state.bin_fac=4
     END


 5 : BEGIN ; Change the format MAR345
	state.image_type='mar345'
	image_state.x_im_sz=2300
	image_state.y_im_sz=2300
	image_state.bin_fac=4
     END


 6 : BEGIN ; Change the format MARCCD (RAW FORMAT (NON-SWAPED))
	state.image_type='marccd'
	image_state.x_im_sz=2048
	image_state.y_im_sz=2048
	image_state.bin_fac=4
     END

 7 : BEGIN ; Change the format ADSC (Q4)
	state.image_type='adscQ4'
	image_state.x_im_sz=2304
	image_state.y_im_sz=2304
	image_state.bin_fac=4
     END

 8 : BEGIN ; Change the format ADSC (Q315)
	state.image_type='adscQ315'
	image_state.x_im_sz=3072
	image_state.y_im_sz=3072
	image_state.bin_fac=4
     END

 9 : BEGIN ; Change the format ESRF
	state.image_type='esrf'
	image_state.x_im_sz=1152
	image_state.y_im_sz=1242
	image_state.bin_fac=2
     END

 10 : BEGIN ; Change the format ESRF_LONG
	state.image_type='esrf_long'
	image_state.x_im_sz=1152
	image_state.y_im_sz=1242
	image_state.bin_fac=2
     END

 11 : BEGIN ; Change the format BINARY (XRII FORMAT)
	state.image_type='binary2'
	image_state.x_im_sz=1152
	image_state.y_im_sz=1242
	image_state.bin_fac=2
     END


 12 : BEGIN ; Change the format BINARY 4-BYTES (XRII FORMAT)
	state.image_type='binary4'
	image_state.x_im_sz=1152
	image_state.y_im_sz=1242
	image_state.bin_fac=2
     END


 13 : BEGIN ; Change the format ESRF (FRELON FORMAT)
;	state.prow_title=state.prow_version+'FRELON/XRII ESRF FORMAT (2-BYTES)'
	state.image_type='esrf'
	image_state.x_im_sz=1024
	image_state.y_im_sz=1024
	image_state.bin_fac=2
     END



 14 : BEGIN ; Change the format BINARY (FRELON FORMAT)
;	state.prow_title=state.prow_version+'FRELON/XRII BINARY FORMAT (2-BYTES)'
	state.image_type='binary2'
	image_state.x_im_sz=1024
	image_state.y_im_sz=1024
	image_state.bin_fac=2
      END


 15 : BEGIN ; Change the format BINARY 4-BYTES (FRELON FORMAT)
;	state.prow_title=state.prow_version+'FRELON/XRII BINARY FORMAT (4-BYTES)'
	state.image_type='binary4'
	image_state.x_im_sz=1024
	image_state.y_im_sz=1024
	image_state.offset=1024
	image_state.bin_fac=2
     END

 16 : BEGIN ; Change the format EDF (LARGE IMAGE PLATE)
;	state.prow_title=state.prow_version+'EDF (LARGE IMAGE PLATE FORMAT)'
	state.image_type='edf'
	image_state.x_im_sz=4000
	image_state.y_im_sz=2000
	image_state.bin_fac=4
     END


 17 : BEGIN ; Change the format RAXIS 
	state.image_type='raxis'
	image_state.x_im_sz=3000
	image_state.y_im_sz=3000
	image_state.bin_fac=4
     END


 18 : BEGIN ; Change the format BINARY (USER DEFINED)
;	state.prow_title=state.prow_version+'USER DEFINED BINARY FORMAT'
	field={x_im_size : image_state.x_im_sz, y_im_size : image_state.y_im_sz, im_byte : image_state.n_bytes, im_offset : image_state.offset, im_swap : image_state.swap, im_rebin : image_state.bin_fac }
	field_title=['X size of image [raster] : ','Y size of image [raster] : ','Number of bytes per pixel [2 or 4] : ', 'Offset to skip [bytes] : ', 'Swap the bytes [1:Yes/0:No] : ', 'Rebinning factor for display : ' ]
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,GROUP=event.top,HELP="XDISPLAYFILE1,STRCOMPRESS(GETENV('PROW_SCR')+'nohelp.txt',/REMOVE_ALL),GROUP=event.top,Title='PROW HELP'",ACTION=action
	IF action EQ 'DO' THEN BEGIN
  	 image_state.x_im_sz = field.x_im_size
  	 image_state.y_im_sz = field.y_im_size
  	 image_state.offset = field.im_offset
  	 image_state.swap = field.im_swap

	 WHILE (FIX(image_state.x_im_sz)/FIX(field.im_rebin) NE FIX(image_state.x_im_sz)/FLOAT(field.im_rebin)) OR (FIX(image_state.y_im_sz)/FIX(field.im_rebin) NE FIX(image_state.y_im_sz)/FLOAT(field.im_rebin)) $
		DO BEGIN
  			field.im_rebin=field.im_rebin-1
	 ENDWHILE 
  	 image_state.bin_fac = field.im_rebin
  	 image_state.n_bytes = 2*(FIX(field.im_byte)/2)
	 state.image_type='user'
 	END
     END


 19 : BEGIN ; Change the ZOOM WINDOW SIZE
	field={x_zoom_size : image_state.x_zm_sz, y_zoom_size : image_state.y_zm_sz}
	field_title=['X size of zoom window [raster] : ','Y size of zoom window [raster] : ' ]
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,GROUP=event.top,HELP=STRCOMPRESS(GETENV('PROW_SCR')+'nohelp.txt',/REMOVE_ALL),ACTION=action
	IF action EQ 'DO' THEN BEGIN
  	 image_state.x_zm_sz = field.x_zoom_size
  	 image_state.y_zm_sz = field.y_zoom_size
	 WIDGET_CONTROL,image_state.zoom	,$
		DRAW_XSIZE=field.x_zoom_size, $
		DRAW_YSIZE=field.y_zoom_size

	 PTR_FREE,image_state.zoom_image
	 image_state.zoom_image=PTR_NEW(LONARR(image_state.x_zm_sz,image_state.y_zm_sz,/NOZERO))
	 WSET,image_state.zoom_back_win1
	 WDELETE
	 WSET,image_state.zoom_back_win2
	 WDELETE
	 WSET,image_state.zoom_win
	 WINDOW, /PIXMAP, /FREE, xs = !d.x_size, ys=!d.y_size  ;Save window
	 image_state.zoom_back_win1 = !D.WINDOW
	 WINDOW, /PIXMAP, /FREE, xs = !d.x_size, ys=!d.y_size  ;Save window
	 image_state.zoom_back_win2 = !D.WINDOW
	END
	GOTO,end_of_routine
     END

 20 : BEGIN ; Change the STUDY WINDOW SIZE
	field={x_study_size : image_state.x_st_sz, y_study_size : image_state.y_st_sz}
	field_title=['X size of study window [raster] : ','Y size of study window [raster] : ' ]
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,GROUP=event.top,HELP=STRCOMPRESS(GETENV('PROW_SCR')+'nohelp.txt',/REMOVE_ALL),ACTION=action
	IF action EQ 'DO' THEN BEGIN
  	 image_state.x_st_sz = field.x_study_size
  	 image_state.y_st_sz = field.y_study_size
	 WIDGET_CONTROL,image_state.study,$
		DRAW_XSIZE=field.x_study_size, $
		DRAW_YSIZE=field.y_study_size
	END
	GOTO,end_of_routine
     END


 ELSE : WIDGET_CONTROL,state.info,SET_VALUE='Info : Error !'
ENDCASE

state.prow_title=state.prow_version+STRCOMPRESS('('+state.diff_denzox.integ_mode+') ')+STRUPCASE(state.image_type)
DRAW_CHANGE_FORMAT,state,image_state


end_of_routine:
END







