pro DRAW_PULL_DIFF,state,image_state,event
;+
; NAME:
;	DRAW_PULL_DIFF
;
; PURPOSE:
;	Manages diffraction pull down menu.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_PULL_DIFF,state,image_state,event
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW
;	event: the event related to the choice in the pull down menu
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

COMMON SHARE_PROW,pred,sel_pred,par


CASE event.value OF 
 1 : BEGIN ; Change the parameters
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Define the experiment parameters ...'
	field={distance:state.diff_par.distance,cenx:state.diff_par.cenx,ceny:state.diff_par.ceny,raster:state.diff_par.raster,lambda:state.diff_par.lambda}
	field_title=['Crystal to detector distance [mm] : ','X center [raster] : ','Y center [raster] : ','Raster [um] : ','Wavelength [A] : ']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,ACTION=action
	IF state.res_circles THEN BEGIN
	 DRAW_RES_CIRCLES,state,image_state ;erase
	 state.res_circles=1
	ENDIF
	IF action EQ 'DO' THEN BEGIN
 	 state.diff_par.distance=field.distance
	 state.diff_par.cenx=field.cenx
	 state.diff_par.ceny=field.ceny
	 state.diff_par.raster=field.raster
	 state.diff_par.lambda=field.lambda
	ENDIF
	IF state.res_circles THEN BEGIN
	 DRAW_RES_CIRCLES,state,image_state ;redraw
	 state.res_circles=1
	ENDIF
	WIDGET_CONTROL,state.info,SET_VALUE='Info : '
     END

 2 : IF image_state.draw_win NE -1 THEN BEGIN ;Define beam center manually
	WIDGET_CONTROL,state.info,SET_VALUE='Info : Define beam center position on zoom window (Left mouse) ... (Right mouse to cancel) '
	IF state.res_circles THEN BEGIN
	 DRAW_RES_CIRCLES,state,image_state ;erase
	 state.res_circles=1
	ENDIF
	WSET,image_state.zoom_win
	WHILE(1) DO BEGIN
	 ev = WIDGET_EVENT([image_state.zoom])
	 x=image_state.x0+ FIX(ev.x/image_state.scale)
	 y=image_state.y0+ FIX(ev.y/image_state.scale)
	 z=(*image_state.orig_image)(x,y)
	 WIDGET_CONTROL, image_state.xyz_show, SET_VALUE=STRING(x,y,z,FORMAT='("X:",i5," Y:",i5," Z:",i7)')
	 IF ev.press EQ 1 THEN BEGIN
	  state.diff_par.cenx=x
	  state.diff_par.ceny=y
	  GOTO,give_up_mouse_center
	 ENDIF
	 IF ev.press EQ 4 THEN GOTO,give_up_mouse_center
	ENDWHILE
	give_up_mouse_center:
	;restore resolution circles if necessary
	IF state.res_circles THEN BEGIN
	DRAW_RES_CIRCLES,state,image_state ;redraw
	state.res_circles=1
	ENDIF

	WIDGET_CONTROL,state.info,SET_VALUE='Info :'
     END
	
 3 :BEGIN ;Fit center from circle
	IF image_state.draw_win NE -1 THEN DRAW_FIT_CENTER,state,image_state
    END

 4 :BEGIN ;Resolution circles
	IF image_state.draw_win NE -1 THEN DRAW_RES_CIRCLES,state,image_state
    END

 5 :BEGIN ;Estimate cell parameters
	IF image_state.draw_win NE -1 THEN DRAW_CELL_PARAMETER,state,image_state
    END

 6 :IF image_state.draw_win NE -1 THEN BEGIN ;Superimpose several images
 	WIDGET_CONTROL,state.info,SET_VALUE='Info : Choose images to superimpose ...'
	gfile=STRCOMPRESS(STRMID(state.file.generic,RSTRPOS(state.file.generic,'/')+1,STRLEN(state.file.generic)))
	dir=STRMID(state.file.generic,0,RSTRPOS(state.file.generic,'/')+1)
	field={gfile:gfile,first:state.file.first,last:state.file.last}
	field_title=['Generic filename : ','First image number : ','Last image number : ']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,ACTION=action,FIELDLEN=50
	IF action EQ 'DO' THEN BEGIN
	 ;update the state
	 state.file.first=field.first
	 state.file.last=field.last
	 state.file.generic=STRCOMPRESS(dir+field.gfile,/REMOVE_ALL) 
	 ;load all images
         n_images=field.last-field.first+1
	 IF n_images LE 0 THEN BEGIN
	  WIDGET_CONTROL,state.info,SET_VALUE='Info : Error !'
	  WAIT,0.5
	  GOTO,cut_superimpose
	 ENDIF
	 ;get the image names and load them
	 ;how many #
	 np1=STRPOS(field.gfile,'#')
	 np2=RSTRPOS(field.gfile,'#')
	 np=np2-np1+1
	 genstr=''
	 FOR i=0,np-1 DO genstr=genstr+'#'
	 genstr=STRCOMPRESS(genstr,/REMOVE_ALL)
	 FOR i=0,n_images-1 DO BEGIN
	  ;get the name of the image
	  n=field.first+i
	  IF n LT 10 AND np EQ 3 THEN ns=STRCOMPRESS('00'+STRING(n),/REMOVE_ALL)
	  IF n GE 10 AND n LT 100 AND np EQ 3 THEN ns=STRCOMPRESS('0'+STRING(n),/REMOVE_ALL)
	  IF n GE 10 AND n LT 100 AND np EQ 2 THEN ns=STRCOMPRESS(STRING(n),/REMOVE_ALL)
	  IF (n GE 100 AND np EQ 3) OR np EQ 1 THEN ns=STRCOMPRESS(STRING(n),/REMOVE_ALL)
	  file=STR_REPLACE(state.file.generic,genstr,ns)
	  ;check that the file exists
	  tmp=FINDFILE(file,COUNT=count)
	  IF count EQ 0 THEN WIDGET_CONTROL,state.info,SET_VALUE='File does not exist : '+file
	  state.file.current=file
          IF (SIZE(*image_state.orig_image))(1) EQ (SIZE(*image_state.orig_image))(2) THEN no_rotate=1 ELSE no_rotate=0
	  IF i EQ 0 THEN DRAW_LOAD,state,image_state,/JUST_READ,NO_ROTATE=no_rotate ELSE DRAW_LOAD,state,image_state,/JUST_READ,/MAX,NO_ROTATE=no_rotate 
	 ENDFOR
	 ;now rotate if necessary
         IF (SIZE(*image_state.orig_image))(1) EQ (SIZE(*image_state.orig_image))(2) THEN BEGIN
 	  WIDGET_CONTROL,state.info,SET_VALUE='Rotating image ...'
	  *image_state.orig_image=ROTATE(TEMPORARY(*image_state.orig_image),4)
	 ENDIF
	 draw_image=state.draw_image
	 WIDGET_CONTROL,state.info,SET_VALUE='Displaying image ...'
	 child=WIDGET_INFO(state.prow_base, /CHILD)
	 ;give back the state to PROW_DRAW
	 WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY
	 WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY
	 WIDGET_CONTROL,draw_image,SET_VALUE=0
	 WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY
	 ;get back the state from PROW_DRAW
	 WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY
	 WIDGET_CONTROL,state.info,SET_VALUE='Info :'
	ENDIF
	cut_superimpose:
    END


 7 :IF image_state.draw_win NE -1 THEN BEGIN ; Combine 2 images

 	WIDGET_CONTROL,state.info,SET_VALUE='Info : Choose images to combine ...'
	gfile=STRCOMPRESS(STRMID(state.file.generic,RSTRPOS(state.file.generic,'/')+1,STRLEN(state.file.generic)))
	dir=STRMID(state.file.generic,0,RSTRPOS(state.file.generic,'/')+1)
	field={gfile1:gfile,coeff1:1, gfile2:gfile, coeff2:-1}
	field_title=['First image : ', 'With coefficient : ', 'Second image : ', 'With coefficient : ']
	XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,ACTION=action,FIELDLEN=50
	IF action EQ 'DO' THEN BEGIN
	 ;update the state
	 	;state.file.first=field.first
	 	;state.file.last=field.last
	 state.file.generic=STRCOMPRESS(dir+field.gfile1,/REMOVE_ALL) 
	 ;load all images
	 file1=STRCOMPRESS(dir+field.gfile1,/REMOVE_ALL)
	 file2=STRCOMPRESS(dir+field.gfile2,/REMOVE_ALL)

	  ;check that the files exists
	  tmp=FINDFILE(file1,COUNT=count)
	  IF count EQ 0 THEN BEGIN
		WIDGET_CONTROL,state.info,SET_VALUE='First file does not exist : '+file1
		GOTO,cut_combine
	  ENDIF

	  tmp=FINDFILE(file2,COUNT=count)
	  IF count EQ 0 THEN BEGIN
		WIDGET_CONTROL,state.info,SET_VALUE='Second file does not exist : '+file2
		GOTO,cut_combine
	  ENDIF

	  state.file.current=file1
	  DRAW_LOAD,state,image_state,/JUST_READ

 	  tmp_image = (*image_state.orig_image)

	  state.file.current=file2
	  DRAW_LOAD,state,image_state,/JUST_READ

	 IF (SIZE(tmp_image))(1) EQ (SIZE(*image_state.orig_image))(1) $
	  AND (SIZE(tmp_image))(2) EQ (SIZE(*image_state.orig_image))(2) $
	  THEN $
 	   (*image_state.orig_image) = field.coeff1*tmp_image+field.coeff2*(*image_state.orig_image) ELSE BEGIN
 	  WIDGET_CONTROL,state.info,SET_VALUE='Sizes of the two images are uncompatible ...'
	  GOTO,cut_combine
	 ENDELSE

	 draw_image=state.draw_image
	 WIDGET_CONTROL,state.info,SET_VALUE='Displaying image ...'
	 child=WIDGET_INFO(state.prow_base, /CHILD)
	 ;give back the state to PROW_DRAW
	 WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY
	 WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY
	 WIDGET_CONTROL,draw_image,SET_VALUE=0
	 WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY
	 ;get back the state from PROW_DRAW
	 WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY
	 WIDGET_CONTROL,state.info,SET_VALUE='Info :'
	ENDIF
	cut_combine:
    END



 ELSE : WIDGET_CONTROL,state.info,SET_VALUE='Info : Error !'
ENDCASE



END










