pro DRAW_LOAD,state,image_state,PICK=pick,MAX=max,JUST_READ=just_read,NO_ROTATE=no_rotate,ADJUST_FORMAT=adjust_format
;+
; NAME:	DRAW_LOAD
;
;
; PURPOSE:
;	Load an image.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_LOAD,state,image_state,[/PICK],[/MAX],[/JUST_READ],[/NO_ROTATE],[/ADJUST_FORMAT]
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW.
;	pick: [optional] set this keyword to pick an image with pickfile.
;	max: [optional] set this keyword if the image to be loaded is the
;		maximum of the old image and the new one.
;	just_read: [optional] set this keyword is the image is not displayed
;	no_rotate: [optional] set this keyword is the image is not rotated
;	adjust_format: [optional] set this keyword if the window format must be adjusted.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

COMMON SHARE_PROW,pred,sel_pred,par

IF N_ELEMENTS(state.image_type) EQ 0 THEN type='denzo_mar' ELSE type=state.image_type
IF type EQ 'mar18' OR type  EQ 'mar30' THEN type='denzo_mar'
IF STRMID(type,0,6) EQ 'mar345' THEN type='mar345'
IF STRMID(type,0,5) EQ 'raxis' THEN type='raxis'

IF KEYWORD_SET(pick) THEN BEGIN
 WIDGET_CONTROL,state.info,SET_VALUE='Info : Choose an image file ...'
 file=PICKFILE(/READ,PATH=state.working_dir,GET_PATH=working_dir,FILTER=['*'])
 IF file EQ '' THEN BEGIN
  WIDGET_CONTROL,state.info,SET_VALUE='Info : File not found ...'
  GOTO,cut_load
 ENDIF
 state.working_dir=working_dir(0)
; image_state.pred.path=working_dir(0)
 state.file.current=file
ENDIF

state.file.generic=DRAW_GET_GENFILE(state.file.current)

;rotate ?
IF NOT KEYWORD_SET(no_rotate) THEN no_rotate=0

;read the image
WIDGET_CONTROL,state.info,SET_VALUE='Info : Loading file ...'


CASE type OF

 'denzo_mar' : 	BEGIN 
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_DENZO_MAR(file=state.file.current,NO_ROTATE=no_rotate) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_DENZO_MAR(file=state.file.current,NO_ROTATE=no_rotate)
		END

 'binary2' : 	BEGIN 
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_BIN2(file=state.file.current,rows=image_state.y_im_sz,columns=image_state.x_im_sz,NO_ROTATE=no_rotate) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_BIN2(file=state.file.current,rows=image_state.y_im_sz,columns=image_state.x_im_sz,NO_ROTATE=no_rotate)
		END


 'binary4' :	BEGIN 
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_BIN2(file=state.file.current,rows=image_state.y_im_sz,columns=image_state.x_im_sz,NO_ROTATE=no_rotate,n_bytes=4) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_BIN2(file=state.file.current,rows=image_state.y_im_sz,columns=image_state.x_im_sz,NO_ROTATE=no_rotate,n_bytes=4)
		END


 'esrf' : 	BEGIN ; 
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_ESRF(file=state.file.current,NO_ROTATE=no_rotate) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_ESRF(file=state.file.current,NO_ROTATE=no_rotate)
		END

 'esrf_long' : 	BEGIN ;
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_ESRF(file=state.file.current,NO_ROTATE=no_rotate,/LONGBYTE) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_ESRF(file=state.file.current,NO_ROTATE=no_rotate,/LONGBYTE)
		END

 'edf' : 	BEGIN ; 
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_EDF(file=state.file.current,NO_ROTATE=no_rotate) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_EDF(file=state.file.current,NO_ROTATE=no_rotate)
		END

 'marccd' : 	BEGIN ; 
	IF state.diff_integ.integ_mode EQ 'mono' THEN BEGIN
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_MARCCD(file=state.file.current,NO_ROTATE=no_rotate) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_MARCCD(file=state.file.current,NO_ROTATE=no_rotate)
	ENDIF ELSE BEGIN
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_MARCCD(file=state.file.current,NO_ROTATE=no_rotate,offset=0) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_MARCCD(file=state.file.current,NO_ROTATE=no_rotate,offset=0)
	ENDELSE
		END

; 'marccdswap' :	BEGIN ;
;	IF state.diff_integ.integ_mode EQ 'mono' THEN BEGIN
;	IF NOT KEYWORD_SET(max) THEN $
; 	 *image_state.orig_image=READ_MARCCD(file=state.file.current,NO_ROTATE=no_rotate,/SWAP) $
;	ELSE $
; 	 *image_state.orig_image=*image_state.orig_image>READ_MARCCD(file=state.file.current,NO_ROTATE=no_rotate,/SWAP)
;	ENDIF ELSE BEGIN
;	IF NOT KEYWORD_SET(max) THEN $
; 	 *image_state.orig_image=READ_MARCCD(file=state.file.current,NO_ROTATE=no_rotate,/SWAP,offset=0) $
;	ELSE $
; 	 *image_state.orig_image=*image_state.orig_image>READ_MARCCD(file=state.file.current,NO_ROTATE=no_rotate,/SWAP,offset=0)
;	ENDELSE
;		END

 'adscQ4' :	BEGIN ; 
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_Q4(file=state.file.current,NO_ROTATE=no_rotate) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_Q4(file=state.file.current,NO_ROTATE=no_rotate)
		END

 'adscQ315' :	BEGIN ; 
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_Q315(file=state.file.current,NO_ROTATE=no_rotate) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_Q315(file=state.file.current,NO_ROTATE=no_rotate)
		END

 'mar345' : 	BEGIN ;
	IF KEYWORD_SET(adjust_format) THEN BEGIN
 	 empty_image=READ_MAR345(file=state.file.current,SIZE_OF_IMAGE=size_of_image,/ONLY_READ_SIZE)
         size_string=STRCOMPRESS(STRING(size_of_image(0))+'x'+STRING(size_of_image(1)))
	 state.prow_title=state.prow_version+'MAR345 ('+size_string+')'
	 state.image_type='mar345 ('+size_string+')'
	 image_state.x_im_sz=size_of_image(0)
	 image_state.y_im_sz=size_of_image(1)
         ;evaluate the binning factor automatically !
  	 bin_fac=0
  	 big_size=(image_state.x_im_sz>image_state.y_im_sz)
   	 REPEAT BEGIN
    	  bin_fac=bin_fac+1
   	 ENDREP UNTIL big_size/FLOAT(bin_fac) LE 800
  	 IF  big_size/FLOAT(bin_fac) NE LONG(big_size/FLOAT(bin_fac)) THEN BEGIN
   	  REPEAT BEGIN
    	   bin_fac=bin_fac+1
   	  ENDREP UNTIL (big_size/FLOAT(bin_fac) EQ LONG(big_size/FLOAT(bin_fac)))
  	 ENDIF
  	 PRINT,'Binning factor =',bin_fac
  	 image_state.bin_fac=bin_fac
         DRAW_CHANGE_FORMAT,state,image_state
  	ENDIF
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_MAR345(file=state.file.current,NO_ROTATE=no_rotate) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_MAR345(file=state.file.current,NO_ROTATE=no_rotate)
		END

 'raxis' : 	BEGIN ;
	IF KEYWORD_SET(adjust_format) THEN BEGIN
 	 empty_image=READ_RAXIS(file=state.file.current,SIZE_OF_IMAGE=size_of_image,/ONLY_READ_SIZE)
         size_string=STRCOMPRESS(STRING(size_of_image(0))+'x'+STRING(size_of_image(1)))
	 state.prow_title=state.prow_version+'RAXIS ('+size_string+')'
	 state.image_type='raxis ('+size_string+')'
	 image_state.x_im_sz=size_of_image(0)
	 image_state.y_im_sz=size_of_image(1)
         ;evaluate the binning factor automatically !
  	 bin_fac=0
  	 big_size=(image_state.x_im_sz>image_state.y_im_sz)
   	 REPEAT BEGIN
    	  bin_fac=bin_fac+1
   	 ENDREP UNTIL big_size/FLOAT(bin_fac) LE 800
  	 IF  big_size/FLOAT(bin_fac) NE LONG(big_size/FLOAT(bin_fac)) THEN BEGIN
   	  REPEAT BEGIN
    	   bin_fac=bin_fac+1
   	  ENDREP UNTIL (big_size/FLOAT(bin_fac) EQ LONG(big_size/FLOAT(bin_fac)))
  	 ENDIF
  	 PRINT,'Binning factor =',bin_fac
  	 image_state.bin_fac=bin_fac
         DRAW_CHANGE_FORMAT,state,image_state
  	ENDIF
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_RAXIS(file=state.file.current,NO_ROTATE=no_rotate) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_RAXIS(file=state.file.current,NO_ROTATE=no_rotate)
		END


 'user' : 	BEGIN 
	IF NOT KEYWORD_SET(max) THEN $
 	 *image_state.orig_image=READ_BIN2(file=state.file.current,rows=image_state.y_im_sz,columns=image_state.x_im_sz,NO_ROTATE=no_rotate,swap=image_state.swap,n_bytes=image_state.n_bytes,offset=image_state.offset) $
	ELSE $
 	 *image_state.orig_image=*image_state.orig_image>READ_BIN2(file=state.file.current,rows=image_state.y_im_sz,columns=image_state.x_im_sz,NO_ROTATE=no_rotate)
		END


ENDCASE

WIDGET_CONTROL,state.field_dir,SET_VALUE=state.working_dir
WIDGET_CONTROL,state.field_file,SET_VALUE=STRCOMPRESS('Current image : '+STRMID(state.file.current,RSTRPOS(state.file.current,'/')+1,STRLEN(state.file.current)))

IF NOT KEYWORD_SET(just_read) THEN BEGIN
 WIDGET_CONTROL,state.info,SET_VALUE='Displaying image ... '
 draw_image=state.draw_image
 child=WIDGET_INFO(state.prow_base, /CHILD)
 ;give back the state to PROW_DRAW
 WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY
 WIDGET_CONTROL, child, SET_UVALUE=state, /NO_COPY
 WIDGET_CONTROL,draw_image,SET_VALUE=0
 WIDGET_CONTROL, child, GET_UVALUE=state, /NO_COPY
 ;get back the state from PROW_DRAW
 WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY
ENDIF

WIDGET_CONTROL,state.info,SET_VALUE='Info : '
cut_load :

END













