pro DRAW_INTEG,state,image_state
;+
; NAME:
;	DRAW_INTEG
;
; PURPOSE:
;	Integrates data.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_INTEG,state,image_state,event
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June 1997.
;-

IF state.diff_integ.integ_mode EQ 'mono' THEN mode='mono' ELSE mode='laue'

logdir = state.diff_integ.logdir
logfile = state.diff_integ.logfile

denzo_format = state.diff_integ.denzo_format
IF denzo_format NE 'york' AND $
   denzo_format NE 'noyork' THEN $
 MESSAGE,'Unknown DENZO format !'

xdir = state.diff_integ.xdir
xfile = state.diff_integ.xfile

loc_refine = state.diff_integ.loc_refine
IF loc_refine LT 0 OR loc_refine GT 1 THEN $
 MESSAGE,'Loc_refine parameter must be 0 or 1 !'

prowdir = state.diff_integ.prowdir
prowfile = state.diff_integ.prowfile
reffile = state.diff_integ.reffile

datadir = state.diff_integ.datadir
datafile = state.diff_integ.datafile

first = state.diff_integ.first
last = state.diff_integ.last

skip = state.diff_integ.skip
IF skip THEN BEGIN
 ds= state.diff_integ.data_skipped
 ds2=ds
 n_skipped=1
 IF STRPOS(ds2,',') NE -1 THEN BEGIN
  REPEAT BEGIN
   ds2=STR_REPLACE(ds2,',','?') 
   n_skipped=n_skipped+1
  ENDREP UNTIL STRPOS(ds2,',') EQ -1
 ENDIF
 data_skipped=INTARR(n_skipped)
 READS,ds,data_skipped
ENDIF

IF state.diff_integ.integ_mode EQ 'laue_soft' THEN rdbw=1 ELSE rdbw=0

detector = state.diff_integ.detector
IF detector NE 'marccd' AND $
   detector NE 'marccdswap' AND $
   detector NE 'ccd' AND $
   detector NE 'adscQ4' AND $
   detector NE 'adscQ315' AND $
   detector NE 'ccd4bytes' AND $
   detector NE 'mar18' AND $
   detector NE 'mar30' AND $
   detector NE 'mar345' AND $
   detector NE 'raxis' AND $
   detector NE 'edf' THEN $
 MESSAGE,'Unavailable detector !'

res_lim=state.diff_integ.res_lim
READS,state.diff_integ.res_lim,res1,res2
low_res = FLOAT(res1)>FLOAT(res2)
high_res = FLOAT(res1)<FLOAT(res2)

xsize = state.diff_integ.xsize
ysize = state.diff_integ.ysize
raster = state.diff_integ.raster

set_bsmask = state.diff_integ.set_bsmask
bs_maskfile = state.diff_integ.bs_maskfile

set_mask =  state.diff_integ.set_mask
maskfile =  state.diff_integ.maskfile

boxsize_x = state.diff_integ.boxsize.x
boxsize_y = state.diff_integ.boxsize.y
IF (boxsize_x/2. EQ boxsize_x/2) OR (boxsize_y/2. EQ boxsize_y/2) THEN $
 MESSAGE,'Boxsize dimensions must be ODD, not EVEN !'

set_region = state.diff_integ.set_region
n_sectors = 2*FIX((state.diff_integ.n_sectors>2)/2)
regionfile = state.diff_integ.regionfile
bc_extend=state.diff_integ.bc_extend

use_old_ref=state.diff_integ.use_old_ref
second_interp=state.diff_integ.second_interp

ovlp_dist = state.diff_integ.ovlp_dist
ovlp_min_dist = state.diff_integ.ovlp_min_dist
ovlp_ref_dist = state.diff_integ.ovlp_ref_dist

satvalue = state.diff_integ.satvalue
det_offset = state.diff_integ.det_offset

det_gain = state.diff_integ.det_gain
bg_percentage = state.diff_integ.bg_percentage
bg_max_slope = state.diff_integ.bg_max_slope

max_ref_spots = state.diff_integ.max_ref_spots
min_ref_spots = state.diff_integ.min_ref_spots

min_isigi = state.diff_integ.min_isigi

use_partials = state.diff_integ.use_partials

max_osc_distance = state.diff_integ.max_osc_distance
rad_distance = state.diff_integ.rad_distance
IF rad_distance LE 0 THEN MESSAGE,'Radial distance must be positive !'
ang_width = state.diff_integ.ang_width
IF ang_width LE 0 THEN MESSAGE,'Angular width must be positive !'

sym_search = state.diff_integ.sym_search

show_image = state.diff_integ.show_image
show_ref_peaks = state.diff_integ.show_ref
show_strong_peaks = state.diff_integ.show_strong
show_weak_peaks = state.diff_integ.show_weak
show_ovlp_peaks = state.diff_integ.show_ovlp
show_m = state.diff_integ.show_m

IF show_m THEN BEGIN
 READS,state.diff_integ.miller,miller_h,miller_k,miller_l
 miller_h = FIX(miller_h)
 miller_k = FIX(miller_k)
 miller_l = FIX(miller_l)
ENDIF ELSE BEGIN
 miller_h = 0 & miller_k = 0 & miller_l =0
ENDELSE

;for safety
CLOSE,1

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&& CREATE LOG FILE &&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

start_time = SYSTIME(1)
;close any previous journaling session
IF !JOURNAL NE 0 THEN JOURNAL

dum = FINDFILE(STRCOMPRESS(logdir+logfile,/REMOVE_ALL),count=count)
IF count NE 0 THEN BEGIN
 ok=WIDGET_MESSAGE('Log file exists. Remove it ?',/QUESTION)
 IF ok EQ 'Yes' THEN SPAWN,'/bin/rm -f '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL), /SH ELSE GOTO,escape
ENDIF

JOURNAL,STRCOMPRESS(logdir+logfile,/REMOVE_ALL)
WIDGET_CONTROL,state.info,SET_VALUE='Integration : Opening logfile ...'

;get window numbers
WIDGET_CONTROL, image_state.draw, GET_VALUE=win_temp
image_state.draw_win = win_temp(0)
WIDGET_CONTROL, image_state.study, GET_VALUE=win_temp
image_state.study_win = win_temp(0)

IF show_ref_peaks OR show_strong_peaks OR show_weak_peaks OR show_ovlp_peaks OR show_m THEN BEGIN
 WIN,512,512,/FREE,TITLE='DEBUG WINDOW'
 study_win=!D.WINDOW
ENDIF ELSE study_win=image_state.study_win

;desensitize PROW widgets
WIDGET_CONTROL,state.prow_base,SENSITIVE=0
WIDGET_CONTROL,state.draw_image,SENSITIVE=0

;show data directory
WIDGET_CONTROL,state.field_dir,SET_VALUE=datadir

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&& CHOOSE IMAGES TO PROCESS &&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
np1=STRPOS(datafile,'#') & np2=RSTRPOS(datafile,'#')
REPEAT datafile=STR_REPLACE(datafile,'#','?') UNTIL STRPOS(datafile,'#') EQ -1

image_names = FINDFILE(STRCOMPRESS(datadir+datafile,/REMOVE_ALL),count=count)
IF (count EQ 0) THEN MESSAGE, 'No images found ...'
image_numbers = FIX(STRMID(image_names,STRLEN(datadir)+np1,np2-np1+1))
s = WHERE(image_numbers GE first AND image_numbers LE last)
image_names = image_names(s)
image_numbers = image_numbers(s)

IF skip THEN BEGIN
FOR j=0,(SIZE(data_skipped))(1)-1 DO BEGIN
sk = WHERE(image_numbers NE data_skipped(j),skcount)
IF skcount GT 0 THEN BEGIN
	image_numbers = image_numbers(sk)
	image_names = image_names(sk)
ENDIF
ENDFOR
ENDIF

PRINT,'Number of images to process : ',(SIZE(image_names))(1)

images= (SIZE(image_names))(1)

frame_start=INTARR(images)
frames=INTARR(images)+1

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&& PRINT INFORMATION &&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
@draw_batch_info

;suppress nasty messages for arithmetic errors
junk = CHECK_MATH(trap = 0)

IF show_image THEN BEGIN
	WSET,image_state.draw_win
	LOADCT,0
	red_col=[255,0,0]
	green_col=[0,255,0]
	dark_blue_col=[0,0,255]
	light_blue_col=[0,255,255]
	colours = LONARR(4,3)
	colours(0,*)=light_blue_col
	colours(1,*)=dark_blue_col
	colours(2,*)=green_col
	colours(3,*)=red_col
	TVLCT,colours,!D.N_COLORS-4
ENDIF

;IF show_ref_peaks OR show_strong_peaks OR show_weak_peaks OR show_ovlp_peaks OR show_m THEN $
; LOADCT,12

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&& PREDICT AND INTEGRATE EACH IMAGE &&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


FOR i=0,(images-1) DO BEGIN
    CATCH, error_status
    ;error_status=0
    IF (error_status ne 0) THEN BEGIN
      BATCH_ERROR, image_name
      error_status=0
      GOTO, end_of_image
    ENDIF
      image_name=image_names(i)

 start_image_time = SYSTIME(1)
PRINT, 'Time from beginning of session [s] : ',start_image_time-start_time
PRINT, 'Image name : ',image_name

WIDGET_CONTROL,state.field_file,SET_VALUE=STRCOMPRESS('Current image : '+STRMID(image_name,RSTRPOS(image_name,'/')+1,STRLEN(image_name)))


;&&&&&&&&& GET PREDICTED REFLECTIONS &&&&&&&&&&&&&
	image_number = STRMID(image_name,STRLEN(datadir)+np1,np2-np1+1)
        gen_number = ''
        FOR loc_i=0,STRLEN(image_number)-1 DO gen_number=gen_number+'#'
 	gen_number=STRCOMPRESS(gen_number,/REMOVE_ALL)

	IF mode EQ 'mono' THEN BEGIN ; Mono MODE with DENZO
	 denzo_name = STR_REPLACE(xfile,gen_number,image_number)
	 denzo_name=STRCOMPRESS(xdir+denzo_name,/REMOVE_ALL)
	 dummy=FINDFILE(denzo_name, count=count)

	    IF (count eq 0) THEN MESSAGE, "Couldn't find DENZO .x file."
	    WIDGET_CONTROL,state.info,SET_VALUE='Integration : Loading predictions ...'
	    CASE denzo_format OF
		'york' : noyork=0
		'noyork' : noyork=1
		else : MESSAGE,'Unknown DENZO format ?'
	    ENDCASE
	    refl = READ_DENZOX(denzo_name, par, RASTER=raster, NOYORK=noyork, DETECTOR=detector)
	    par.rastx = xsize & par.rasty = ysize

	ENDIF ELSE BEGIN ; Laue MODE

	 geasc_name = STR_REPLACE(xfile,gen_number,image_number)
	 geasc_name = STR_REPLACE(geasc_name,'.geasc','')
	 geasc_name = STRCOMPRESS(xdir+geasc_name,/REMOVE_ALL)

	 dummy=FINDFILE(geasc_name+'.gen', count=count1)
	 dummy=FINDFILE(geasc_name+'.ldm', count=count2)
	 count=count1+count2
	 IF (count eq 0) THEN MESSAGE, "Couldn't find .gen nor .ldm file."

	 dummy=FINDFILE(geasc_name+'.geasc', count=count)

	 IF (count eq 0) THEN SPAWN, $
		'source '+ GETENV('PROW_SCR')+'/get_geasc.scr ' + geasc_name
	 dummy=FINDFILE(geasc_name+'.geasc', count=count)
	 IF (count eq 0) THEN MESSAGE, "Couldn't find GEASC- or GE1/GE2-files."

	 WIDGET_CONTROL,state.info,SET_VALUE='Integration : Loading predictions ...'

	 refl = READ_GEASC2(geasc_name, par)
	 par.rastx = xsize & par.rasty = ysize

	;&&&&&&& IN LAUE_SOFT MODE EXCLUDE REFLEXIONS PREDICTED TO BE WEAK &&&&&&

	IF rdbw GT 0 THEN BEGIN
	 WIDGET_CONTROL,state.info,SET_VALUE='Integration : Excluding weak reflexions ...'
	 refl=DRAW_SET_RDBW(state.diff_integ,refl,par,weak_refl=weak_refl)
	ENDIF
	;&&&&&&& END OF THE EXCLUDE PROBLEM &&&&&&

	ENDELSE ; laue mode  

	PRINT,'Selecting resolution limits ...'
	w_res=WHERE(refl.res GT high_res AND refl.res LE low_res,ct_res)
	IF ct_res EQ 0 THEN MESSAGE,'Error : check resolution limits !' ELSE $
	refl=refl(w_res)

	par = CREATE_STRUCT(par,'n_sectors',n_sectors,'regions',PTRARR(n_sectors))

	IF set_region THEN BEGIN
		RESTORE,regionfile
		IF (boxsize_x NE boxsize_reg.x) OR (boxsize_y NE boxsize_reg.y) THEN BEGIN
		 PRINT,'Boxsize for spot region : ',boxsize_reg.x,boxsize_reg.y
		 PRINT,'User defined boxsize : ',boxsize_x,boxsize_y
		 MESSAGE,'Spot region incompatible with chosen boxsize !'
		ENDIF
	    	par = CREATE_STRUCT(par,'overall_region',region)
	ENDIF ELSE  par = CREATE_STRUCT(par,'overall_region',0)
 
	WRITEPAR_LAUE2,par,beamsize=0,sample_depth=0,$
	   	dark_current=det_offset,boxsize={box, x:boxsize_x,y:boxsize_y},gain=det_gain,$
	  	bg_gain=det_gain*1.5418/par.wave,noise_percentage=bg_percentage,bg_max_slope=bg_max_slope,satvalue=satvalue,$
	   	ovlp_dist=ovlp_dist,ovlp_min_dist=ovlp_min_dist,bc_extend=bc_extend,mode=mode

;&&&&&&&&& OPEN IMAGE AND DISPLAY IT &&&&&&&&&&&&&
 
    ;check the image file :
    PRINT,'Checking image file.'
    SPAWN,'date', date, /SH & PRINT, date
    SPAWN,'file ' + image_name, /SH
    WIDGET_CONTROL,state.info,SET_VALUE='Integration : Loading image ...'
    tmp_xsize=xsize & tmp_ysize=ysize
    IF mode EQ 'mono' THEN BEGIN
     CASE detector OF 
	'marccdswap':  image=READ_MARCCD(file=image_name,/SWAP) 
	'marccd':  image=READ_MARCCD(file=image_name) 
	'ccd' :	   image=READ_BIN2(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'adscQ4':  image=READ_Q4(file=image_name) 
	'adscQ315':  image=READ_Q315(file=image_name) 
	'ccd4bytes' : image=READ_BIN2(file=image_name,rows=tmp_ysize,columns=tmp_xsize,/DUMP)
	'mar18' : image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'mar30' : image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'mar345' : image=READ_MAR345(file=image_name)
	'raxis' : image=READ_RAXIS(file=image_name)
	'edf' : image=READ_EDF(file=image_name)
	 else :	   image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
     ENDCASE	    
    ENDIF ELSE BEGIN
     CASE detector OF 
        ;change offset to zero for marccd for compatibility with LAUEGEN
	'marccdswap':  image=READ_MARCCD(file=image_name,/SWAP,offset=0) 
	'marccd':  image=READ_MARCCD(file=image_name,offset=0) 
	'ccd' :	   image=READ_BIN2(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'adscQ4':  image=READ_Q4(file=image_name) 
	'adscQ315':  image=READ_Q315(file=image_name) 
	'ccd4bytes' : image=READ_BIN2(file=image_name,rows=tmp_ysize,columns=tmp_xsize,/DUMP)
	'mar18' : image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'mar30' : image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
	'mar345' : image=READ_MAR345(file=image_name)
	'raxis' : image=READ_RAXIS(file=image_name)
	'edf' : image=READ_EDF(file=image_name)
	 else :	   image=READ_DENZO_MAR(file=image_name,rows=tmp_ysize,columns=tmp_xsize)
     ENDCASE
    ENDELSE

    IF (SIZE(image))(0) EQ 2 THEN BEGIN  ; file exists
    IF set_bsmask THEN BEGIN
      ; Set image behind beamstop to zero so that ROILAUE3 removes 
      ; predictions in this region:
      RESTORE, bs_maskfile
      IF xsize NE sx OR ysize NE sy THEN MESSAGE,'Impossible to apply this mask ! (size problem)'
      image(mask) = 0
    ENDIF
    IF set_mask THEN BEGIN
      RESTORE, maskfile
      IF xsize NE sx OR ysize NE sy THEN MESSAGE,'Impossible to apply this mask ! (size problem)'
      image(mask) = 0
    ENDIF

    ;define a rebinning factor
    reb_fac=image_state.bin_fac
      ;display the image
      IF show_image THEN BEGIN
          red=REBIN(image,xsize/reb_fac,ysize/reb_fac)
	  WIDGET_CONTROL,state.info,SET_VALUE='Integration : Displaying image ...'
	  index_sat=WHERE(red GE satvalue, count_sat)
	  red_displayed = (!D.N_COLORS-2)*ALOG(red>1)/ALOG(satvalue)
	  ; Set the marked pixels to such a high value so that after rebinning
	  ; it is still above !D.N_COLORS-1 :
  	  IF (count_sat gt 0) THEN  red_displayed(index_sat)= 10.0^20
	  TV, red_displayed < (!D.N_COLORS-1)
      ENDIF


	read_image_time = SYSTIME(1)
	PRINT, 'Time to read image and prediction [s] : ',read_image_time-start_image_time

      ;take only the spots inside image and where the image is not empty
     CASE detector OF 
	'marccdswap': out_image_value=10  
	 else :	   out_image_value=0  
     ENDCASE	    
      refl2 = ROILAUE3(refl,image,par,0,0,xsize-1,ysize-1,OUT_IMAGE_VALUE=out_image_value)

;&&&&&&&&& ADDITIONAL REFINEMENT IF WANTED &&&&&&&&&&&&&

IF loc_refine EQ 1 THEN BEGIN
      PRINT,'Searching for overlaps ...[for refinement]'
      ; Find overlaps to avoid that refinement brings two spots at the 
;same position
      FIND_QUICKOVLP,refl2,par,3*SQRT(2)*raster*0.001
      WIDGET_CONTROL,state.info,SET_VALUE='Integration : Doing local refinement ...' 

      ;run the local refinement routine 1 time with changing positions
      refl_obs=LOC_REFINE1(refl2,image,par,0,weak,sigma,back,change_pred=loc_refine)
ENDIF ELSE BEGIN
      WIDGET_CONTROL,state.info,SET_VALUE='Integration : Checking reflexions ...'
      refl_obs=LOC_REFINE2(refl2,image,par)
ENDELSE

match_image_time = SYSTIME(1)
PRINT, 'Time for internal refinement [s] : ',match_image_time-read_image_time

      ;overplot predicted positions on image
      IF show_image THEN dummy = PIXLAUE2(refl_obs,reb_fac,image,par,draw=4,color=2)

;&&&&&&&&& SEARCH FOR OVERLAPS &&&&&&&&&&&&&
      WIDGET_CONTROL,state.info,SET_VALUE='Integration : Finding overlaps...'
      IF ovlp_ref_dist NE par.ovlp_dist THEN BEGIN
       ; Find overlaps when selecting reference peaks; severe criteria!
       PRINT,'Searching for overlaps ...[reference_peaks]'
       FIND_QUICKOVLP,refl_obs,par, ovlp_ref_dist
       refl_obs.ovlp2=refl_obs.ovlp
      ENDIF
      ;get the overlapping pattern
      PRINT,'Searching for overlaps ...[all spots]'
      FIND_OVLP2,refl_obs,par,par.ovlp_dist,par.ovlp_min_dist
      IF ovlp_ref_dist EQ par.ovlp_dist THEN BEGIN
       ;no need to calculate twice the overlaps
       refl_obs.ovlp2=refl_obs.ovlp
      ENDIF
      IF show_image THEN BEGIN
	w_ovlp=WHERE(refl_obs.ovlp GT 0,ct_ovlp)
	IF ct_ovlp GT 0 THEN dummy = PIXLAUE2(refl_obs(w_ovlp),reb_fac,image,par,draw=4,color=4)
      ENDIF

ovlp_image_time = SYSTIME(1)
PRINT, 'Time for finding overlaps [s] : ',ovlp_image_time-match_image_time

;&&&&&&&&& FIND THE SECTORS &&&&&&&&&&&&&

SET_SECTORS,refl_obs,par,reb_fac=reb_fac,show=show_image


;&&&&&&&&& INTEGRATION &&&&&&&&&&&&&

    PRINT,'Integrating :',image_name

      miller = [miller_h,miller_k,miller_l]

IF use_old_ref THEN BEGIN
 ;restore the reference spots :      
 WIDGET_CONTROL,state.info,SET_VALUE='Integration : Restoring reference spots ...'

 curr_reffile = STR_REPLACE(reffile,gen_number,image_number)
 file_restore=STRCOMPRESS(prowdir+curr_reffile,/REMOVE_ALL)

 dum=FINDFILE(file_restore,count=count)
 IF count NE 1 THEN MESSAGE,'Could not find the file with old reference spots !'
 RESTORE,file_restore

 PRINT,'Number of restored reference spots : ', (SIZE(ref_spots))(1)
; PRINT,'Number of restored strong spots : ', number_strong_spots

ENDIF ELSE BEGIN

  WIDGET_CONTROL,state.info,SET_VALUE='Integration : Searching reference spots ...'
  new_ref_spots = FIND_REFSPOTS(image,reb_fac,refl_obs,par,$
	max_ref_spots=max_ref_spots, $
	min_ref_spots=min_ref_spots, $
	other_spots=other_spots, $
	number_ref_spots=number_ref_spots, $
	number_other_spots=number_other_spots, $
	min_sob=min_isigi, $
	show_image=show_image, $
	show_ref_peaks=show_ref_peaks, $
	use_partials=use_partials, $
	study_win=study_win, $
	main_win=image_state.draw_win)

 ;get the strong spots
  w_nonovlp_ref = WHERE(new_ref_spots.ovlp EQ 0,ct_w_nonovlp_ref)
  IF number_other_spots GT 0 THEN $
   w_nonovlp_other = WHERE(other_spots.ovlp EQ 0,ct_w_nonovlp_other) $
  ELSE $
   ct_w_nonovlp_other=0
  IF ct_w_nonovlp_ref LT number_ref_spots THEN BEGIN
   PRINT,'Number of reference peaks declared as overlapped : ',number_ref_spots-ct_w_nonovlp_ref
   PRINT,'These spots will be not be box integrated, but profile fitted !'
  END

  IF (ct_w_nonovlp_ref+ct_w_nonovlp_other) GT 0 THEN $
   strong_spots = REPLICATE(new_ref_spots(0),ct_w_nonovlp_ref+ct_w_nonovlp_other) ELSE strong_spots=0

  IF ct_w_nonovlp_ref GT 0 THEN $
   strong_spots(0:ct_w_nonovlp_ref-1)=new_ref_spots(w_nonovlp_ref)
  
  IF ct_w_nonovlp_other GT 0 THEN $
   strong_spots(ct_w_nonovlp_ref:ct_w_nonovlp_ref+ct_w_nonovlp_other-1)=other_spots(w_nonovlp_other)
  
  IF (SIZE(strong_spots))(0) EQ 1 THEN $  
    number_strong_spots=(SIZE(strong_spots))(1) ELSE number_strong_spots=0

  IF (show_image AND number_strong_spots GT 0) THEN dummy = PIXLAUE2(strong_spots,reb_fac,image,par,draw=4,color=1)

 IF i EQ 0 THEN old_ref_spots=0
 
 ;get the reference spots
  ref_spots = MERGE_REFSPOTS(new_ref_spots,old_ref_spots,par,$
				MAX_OSC_DISTANCE=max_osc_distance,$
				MAX_REF_SPOTS=max_ref_spots,$
				SHOW=0)
  old_ref_spots = ref_spots
 

;save the reference and strong spots :
      	curr_reffile = STR_REPLACE(reffile,gen_number,image_number)
	file_save=STRCOMPRESS(prowdir+curr_reffile,/REMOVE_ALL)
     	SAVE,file=file_save,ref_spots,strong_spots,par,number_ref_spots,number_strong_spots
ENDELSE

;integrate the data with profile fitting and overlap deconvolution
      WIDGET_CONTROL,state.info,SET_VALUE='Integration : Integrating ...'
      integ = INTEGRATE_DENZO1(image,reb_fac,refl_obs,par,$
	ref_spots=ref_spots,$
	strong_spots=strong_spots,$
	ref_distance=rad_distance, $
	ref_ang_width=ang_width, $
	show_image=show_image, $
	show_strong_peaks=show_strong_peaks, $
	show_weak_peaks=show_weak_peaks, $
	show_ovlp_peaks=show_ovlp_peaks, $
	show_m=show_m, miller=miller, $
	use_partials=use_partials, $
	sym_rad=sym_search, $
	second_interp=second_interp, $
	study_win=study_win, $
	main_win=image_state.draw_win, $
;	integ_mode='laue')
	integ_mode=mode)

integ_image_time = SYSTIME(1)
PRINT, 'Time for integration [s] : ',integ_image_time-ovlp_image_time

      ;remove saturated spots and spots too close to integrate !
      integ = integ(WHERE(integ.close EQ 0))



  	;&&&&&&& IN LAUE_SOFT MODE MERGE WITH  REFLEXIONS PREDICTED TO BE WEAK &&&&&&

 	IF rdbw GE 1 THEN BEGIN
 	 WIDGET_CONTROL,state.info,SET_VALUE='Integration : Merging with excluded reflexions ...'
 	 integ=MERGE_INTEG(integ,weak_refl) 	 
	ENDIF
	;&&&&&&& END OF THE EXCLUDE PROBLEM &&&&&&

      ;get some statistics

PRINT,''
PRINT,'&&&&&& SOME STATISTICS &&&&&'

IF mode EQ 'laue' THEN  BEGIN ;statistics on singles
      w_mul=WHERE(integ.mul EQ 1,ct_mul)
      PRINT,'Percentage of single reflexions : ', $
	100*ct_mul/FLOAT((SIZE(integ))(1))
ENDIF

IF rdbw GE 1 THEN  BEGIN ;statistics on excluded reflexions
      w_rdbw=WHERE(integ.flag EQ 4,ct_rdbw)
      PRINT,'Percentage of excluded reflexions : ', $
	100*ct_rdbw/FLOAT((SIZE(integ))(1))
ENDIF

     w=WHERE(integ.flag eq 2,ct)
PRINT,STRCOMPRESS('Number of spots with bad integrated intensities : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')
     w=WHERE(integ.flag eq 1,ct)
PRINT,STRCOMPRESS('Number of spots with bad background : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')
     w=WHERE(integ.flag eq 5,ct)
PRINT,STRCOMPRESS('Number of spots with bad deconvolution : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')

        curr_prowfile = STR_REPLACE(prowfile,gen_number,image_number)
        file_save = STRCOMPRESS(prowdir+curr_prowfile,/REMOVE_ALL)
      SAVE,file=file_save,integ,par

      PRINT,''
    ENDIF ELSE BATCH_ERROR, image_name
    end_of_image:


end_image_time = SYSTIME(1)
PRINT, 'Total time for this image [s] : ',end_image_time-start_image_time

ENDFOR ; Image loop

JOURNAL

;remove garbage in the logfile
SPAWN,'/bin/cp ' + STRCOMPRESS(logdir+logfile,/REMOVE_ALL) + ' temp',/SH

SPAWN,'awk '' $2 !~ /ie/ && $3 !~ /ie/ && $3 !~ /scanned/ && $1 !~ /;p/ && $1 !~ /;\+/ && $1 !~ /;o/ && $1 !~ /;\*/ && $1 !~ /;w:/ && $1 !~ /;i/ && $1 !~ /;s/ {print}'' temp'+' > '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL),/SH

PRINT,'Integration session is DONE !'
escape :
;resensitize PROW widgets
WIDGET_CONTROL,state.info,SET_VALUE='Info ...'
WIDGET_CONTROL,state.prow_base,SENSITIVE=1
WIDGET_CONTROL,state.draw_image,SENSITIVE=1


;***********************************
END
;***********************************
;-














