pro DRAW_DEFINE_REGION,state,main_state
;+
; NAME:
;	DRAW_DEFINE_REGION
;
; PURPOSE:
;	Defines restrained fitting area for PROW integration.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_DEFINE_REGION,state,main_state
;
; INPUTS:
;	state: the state as defined in the widget program PROW_DRAW
;	main_state: the state as defined in the widget program LOOK_MAR18.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June 1997.
;-


boxsize={x:state.boxinteg.boxsize.x,y:state.boxinteg.boxsize.y}
bx=FIX(boxsize.x/2)*2*state.scale
by=FIX(boxsize.y/2)*2*state.scale

imageX = state.x_zm_sz
imageY = state.y_zm_sz
t1=LONARR(1,2) & t2=LONARR(1,2) & t3=LONARR(1,2) & t4=LONARR(1,2)

click_id=state.zoom
WIDGET_CONTROL,state.info, SET_VALUE='Choose a spot with left mouse on zoom window, (right mouse to quit) ...' 


WHILE 1 DO BEGIN                ;Internal event loop   
 ;wait for an event from the clicking window
 ev = WIDGET_EVENT([click_id])
 WSET,state.zoom_win
 button = ev.press  ;New button state   
 IF button EQ 4 THEN GOTO,cut_define_region
 IF button THEN BEGIN
  x=state.x0+ FIX(ev.x/state.scale)
  y=state.y0+ FIX(ev.y/state.scale)
  z=(*state.orig_image)(x,y)
  WIDGET_CONTROL, state.xyz_show, SET_VALUE=STRING(x,y,z,FORMAT='("X:",i5," Y:",i5," Z:",i7)')

  loc_x=ev.x & loc_y=ev.y

  box = (*state.zoom_image)(MAX([0,loc_x-bx/2]):MIN([imageX-1,loc_x+bx/2]),MAX([0,loc_y-by/2]):MIN([imageY-1,loc_y+by/2]))
  ;find the maximum
  sbox =(*state.zoom_image)(MAX([0,loc_x-FIX(bx/4)]):MIN([imageX-1,loc_x+FIX(bx/4)]),MAX([0,loc_y-FIX(by/4)]):MIN([imageY-1,loc_y+FIX(by/4)]))
  pos = WHERESUB(WHERE(sbox EQ MAX(sbox)),sbox)
  loc_x = FLOAT(pos(0))+ MAX([0,loc_x-FIX(bx/4)])
  loc_y = IMAGINARY(pos(0))+ MAX([0,loc_y-FIX(by/4)])
  box = (*state.zoom_image)(MAX([0,loc_x-bx/2]):MIN([imageX-1,loc_x+bx/2]),MAX([0,loc_y-by/2]):MIN([imageY-1,loc_y+by/2]))

 x=state.x0+ FIX(loc_x/state.scale)
 y=state.y0+ FIX(loc_y/state.scale)
 z=(*state.orig_image)(x,y)
 WIDGET_CONTROL, state.xyz_show, SET_VALUE=STRING(x,y,z,FORMAT='("X:",i5," Y:",i5," Z:",i7)')

  ;plot a square around the spot
  DEVICE,SET_GRAPHICS=6
  col = 1
  WHILE col lt !d.table_size do col = col + col
  t1(0,*) = [MAX([0,loc_x-FIX(bx/2)]),MAX([0,loc_y-FIX(by/2)])]
  t2(0,*) = [MAX([0,loc_x-FIX(bx/2)]),MIN([imageY-1,loc_y+FIX(by/2)])]
  t3(0,*) = [MIN([imageX-1,loc_x+FIX(bx/2)]),MIN([imageY-1,loc_y+FIX(by/2)])]
  t4(0,*) = [MIN([imageX-1,loc_x+FIX(bx/2)]),MAX([0,loc_y-FIX(by/2)])]

  PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
  DEVICE,SET_GRAPHICS=3
  obox = (*state.orig_image)(MAX([0,x-boxsize.x/2]):MIN([state.x_im_sz-1,x+boxsize.x/2]),MAX([0,y-boxsize.y/2]):MIN([state.y_im_sz-1,y+boxsize.y/2]))

  ;display in study window
  WSET,state.study_win
  reb_fac_x=FIX(!D.X_SIZE/boxsize.x)
  reb_fac_y=FIX(!D.Y_SIZE/boxsize.y)

;  box = CONGRID(obox,boxsize.x*reb_fac_x,boxsize.y*reb_fac_y,/INTERP)
  box = CONGRID(obox,boxsize.x*reb_fac_x,boxsize.y*reb_fac_y)
  TVSCL,ALOG(box>1)

  ;draw a cross at that position
  cen_x = FIX(boxsize.x*reb_fac_x/2.)
  cen_y = FIX(boxsize.y*reb_fac_y/2.)
  DEVICE,SET_GRAPHICS=6
  col = 1
  WHILE col lt !d.table_size do col = col + col
  c1= [cen_x,cen_x]
  c2= [cen_y-reb_fac_y,cen_y+reb_fac_y]
  c3= [cen_x-reb_fac_x,cen_x+reb_fac_x]
  c4= [cen_y,cen_y]
  PLOTS,c1,c2,COL=col,/DEVICE
  PLOTS,c3,c4,COL=col,/DEVICE
  DEVICE,SET_GRAPHICS=3

;  WIDGET_CONTROL,state.info,SET_VALUE='Adjust colors if necessary ...'
;  XLOADCT
  w=WHERE(obox EQ MAX(obox))
  chk = WHERESUB(w(0),obox)
  PRINT,'Maximum at : ',chk
  IF (chk(0) NE FIX(boxsize.x/2.)) OR (chk(1) NE FIX(boxsize.y/2.)) THEN $
   PRINT,'Spot not well centered, best it to try again ...'
  
  WIDGET_CONTROL,state.info, SET_VALUE='Now define the border of the spot region ...' 
  bregion = DRAW_DEFROI(state.study,/RESTORE,ZOOM=[1,1])
  IF (SIZE(bregion))(0) NE 0 THEN BEGIN
   WSET,state.study_win
   tmp=INTARR(!D.X_SIZE,!D.Y_SIZE)
   big_xy = WHERESUB(bregion,tmp)
   reg_x = FIX(FLOAT(big_xy)/FLOAT(reb_fac_x))
   reg_y = FIX(IMAGINARY(big_xy)/FLOAT(reb_fac_y))
   comp_region = reg_x + boxsize.x*reg_y
   obox2=obox
   obox2(*)=0
   obox2(comp_region)=1
   region = WHERE(obox2 EQ 0)
   SURFACE,obox2
   field={file:STRCOMPRESS(state.masking.regionfile,/REMOVE_ALL)}
   field_title=['Enter region file : ']
   XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,FIELDLEN=60,ACTION=action
   IF action EQ 'DO' THEN BEGIN
	state.masking.regionfile=field.file
	boxsize_reg=boxsize
	SAVE,region,boxsize_reg,FILE=field.file
	GOTO,cut_define_region
   ENDIF
  ENDIF 
   WIDGET_CONTROL,state.info, SET_VALUE='Redo with left mouse on zoom window or leave with right mouse ...' 

  ;plot a square around the spot
  WSET,state.zoom_win
  DEVICE,SET_GRAPHICS=6
  PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
  DEVICE,SET_GRAPHICS=3
 ENDIF

ENDWHILE

cut_define_region:
WIDGET_CONTROL,state.info, SET_VALUE='Info :' 

END









