pro DRAW_CHANGE_FORMAT,state,image_state
;+
; NAME:
;	DRAW_CHANGE_FORMAT
;
; PURPOSE:
;	Change PROW image format.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_CHANGE_FORMAT,state,image_state
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1998.
;-

COMMON SHARE_PROW,pred,sel_pred,par

bin_scale=1.6
	image_state.oldx=image_state.x_im_sz/2L
	image_state.oldy=image_state.y_im_sz/2L

	PTR_FREE,image_state.orig_image
	image_state.orig_image=PTR_NEW(LONARR(image_state.x_im_sz,image_state.y_im_sz,/NOZERO))

	WIDGET_CONTROL,image_state.draw,$
		DRAW_XSIZE=image_state.x_im_sz/image_state.bin_fac, $
		DRAW_YSIZE=image_state.y_im_sz/image_state.bin_fac,$
		XSIZE=FIX(image_state.x_im_sz/(bin_scale*image_state.bin_fac)), $
		YSIZE=FIX(image_state.y_im_sz/(bin_scale*image_state.bin_fac))

;we also need to adapt the zoom window in case it has become too small

	image_state.x_zm_sz = image_state.x_zm_sz < image_state.x_im_sz
	image_state.y_zm_sz = image_state.y_zm_sz < image_state.y_im_sz

	PTR_FREE,image_state.zoom_image
	image_state.zoom_image=PTR_NEW(LONARR(image_state.x_zm_sz,image_state.y_zm_sz,/NOZERO))

	WIDGET_CONTROL,image_state.zoom,$
		DRAW_XSIZE=image_state.x_zm_sz, $
		DRAW_YSIZE=image_state.y_zm_sz,$
		XSIZE=FIX(image_state.x_zm_sz), $
		YSIZE=FIX(image_state.y_zm_sz)


	WIDGET_CONTROL,state.prow_base,TLB_SET_TITLE=state.prow_title

END

