pro BATCH_DENZOX,file=file,RM_LOG=RM_LOG
;+
; NAME:
;	BATCH_DENZOX
;
; PURPOSE:
;	Converts .prow files to DENZO .x files or LAUEGEN .geasc files, in batch mode. 
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	BATCH_DENZOX,file=file,[/rm_log]
;
; INPUTS:
;	file : an idl file containing a structure integ_state as defined in the PROW GUI.
;	rm_log : set this keyword to force removing of log file if necessary.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, April 1998.
;-

dummy=FINDFILE(file,count=count)

IF count EQ 0 THEN BEGIN
 PRINT,'Could not find file :'+file
 GOTO,escape
ENDIF

RESTORE,file

IF denzox_state.integ_mode EQ 'mono' THEN mode='mono' ELSE mode='laue'

logdir = denzox_state.logdir
logfile = denzox_state.logfile

xdir = denzox_state.xdir
xfile = denzox_state.xfile

outxdir = denzox_state.outxdir
outxfile = denzox_state.outxfile

denzo_format = denzox_state.denzo_format

prowdir = denzox_state.prowdir
prowfile = denzox_state.prowfile

first = denzox_state.first
last = denzox_state.last

skip = denzox_state.skip
ds= denzox_state.data_skipped
ds2=ds
n_skipped=1
IF STRPOS(ds2,',') NE -1 THEN BEGIN
 REPEAT BEGIN
  ds2=STR_REPLACE(ds2,',','?') 
  n_skipped=n_skipped+1
 ENDREP UNTIL STRPOS(ds2,',') EQ -1
ENDIF
data_skipped=INTARR(n_skipped)
READS,ds,data_skipped

combine = denzox_state.combine

rm_ovlp = denzox_state.rm_ovlp
rm_mult = denzox_state.rm_mult
rm_excluded = denzox_state.rm_excluded
rm_largerms = denzox_state.rm_largerms
rm_outliers = denzox_state.rm_outliers

keep_lowres = denzox_state.keep_lowres
scaledown = denzox_state.scaledown

set_zero=  denzox_state.set_zero
set_neg_thres =  denzox_state.set_neg_thres
save_limited =  denzox_state.save_limited
savegeasc = denzox_state.savegeasc

rmin = denzox_state.rmin
rmax = denzox_state.rmax

;for safety
CLOSE,1

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&& CREATE LOG FILE &&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;close any previous journaling session
IF !JOURNAL NE 0 THEN JOURNAL

dum = FINDFILE(STRCOMPRESS(logdir+logfile,/REMOVE_ALL),count=count)
IF count NE 0 THEN BEGIN
 IF NOT KEYWORD_SET(rm_log) THEN BEGIN
  ok=WIDGET_MESSAGE('Log file exists. Remove it ?',/QUESTION)
  IF ok EQ 'Yes' THEN SPAWN,'/bin/rm -f '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL) ELSE GOTO,escape
 ENDIF ELSE SPAWN,'/bin/rm -f '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL) 
ENDIF

JOURNAL,STRCOMPRESS(logdir+logfile,/REMOVE_ALL)
PRINT,'Conversion : Opening logfile ...'

;get window number
IF !D.WINDOW EQ -1 THEN WIN,400,400,/FREE,TITLE='PROW : Conversion '


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&& PRINT INFORMATION &&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

PRINT,'**************************************************'
PRINT,' '
PRINT,'Name of log file : ',STRCOMPRESS(logdir+logfile,/REMOVE_ALL)


IF mode EQ 'mono' THEN BEGIN
 PRINT,'Name of input DENZO file : ',STRCOMPRESS(xdir+xfile,/REMOVE_ALL)
 PRINT,'Name of output DENZO files : ',STRCOMPRESS(outxdir+outxfile,/REMOVE_ALL)
 PRINT,'Format of input DENZO files : ',denzo_format
ENDIF

IF mode EQ 'laue' THEN BEGIN
 PRINT,'Name of input GEASC file : ',STRCOMPRESS(xdir+xfile,/REMOVE_ALL)
 PRINT,'Name of output GEASC files : ',STRCOMPRESS(outxdir+outxfile,/REMOVE_ALL)
ENDIF

PRINT,'Name of input PROW files : ',STRCOMPRESS(prowdir+prowfile,/REMOVE_ALL)
PRINT,'First PROW file to be converted : ',first
PRINT,'Last PROW file to be converted : ',last
PRINT,' '


IF rm_outliers EQ 1 THEN $
PRINT,'Removing outliers  ...' ELSE $
PRINT,'Not removing outliers ...'

IF rm_largerms EQ 1 THEN $
PRINT,'Removing potential ice spots (spots with too large deviation from average)  ...' ELSE $
PRINT,'Not removing ice spots ...'

IF keep_lowres NE 100 THEN $
PRINT,'Keeping low resolution data even if outliers up to [A] : ',keep_lowres

IF combine EQ 1 THEN $
PRINT,'Combining box and profile fitted intensities ...' ELSE $
PRINT,'Using only profile fitted intensities ...'

IF rm_ovlp EQ 1 THEN $
PRINT,'Removing overlapped spots ...' ELSE $
PRINT,'Keeping overlapped spots ...'

IF mode EQ 'laue' THEN BEGIN
 IF rm_mult EQ 1 THEN $
 PRINT,'Removing multiples ...' ELSE $
 PRINT,'Keeping multiples ...'
ENDIF

IF denzox_state.integ_mode EQ 'laue_soft' THEN BEGIN
 IF rm_excluded EQ 1 THEN $
 PRINT,'Removing spots excluded during integration ...' ELSE $
 PRINT,'Keeping spots excluded during integration ...'
ENDIF

IF save_limited EQ 1 THEN $
PRINT,'Keeping spots between ',rmin,' and ',rmax,' [mm] from beam center' ELSE $
PRINT,'Keeping spots in the entire image ...'

IF set_zero EQ 1 THEN $
PRINT,'All negative intensities will be set to 0 !'

IF set_neg_thres LT 0 THEN $
PRINT,'Remove all reflections with integrated intensities lower than : ',set_neg_thres

IF scaledown GT 0 THEN $
PRINT,'Scaling down to :',scaledown ELSE $
PRINT,'Not scaling down ...'

PRINT,'**************************************************'

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&& CHOOSE FILES TO PROCESS &&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
np1=STRPOS(prowfile,'#') & np2=RSTRPOS(prowfile,'#')
REPEAT prowfile=STR_REPLACE(prowfile,'#','?') UNTIL STRPOS(prowfile,'#') EQ -1

prow_names = FINDFILE(STRCOMPRESS(prowdir+prowfile,/REMOVE_ALL),count=count)
IF (count EQ 0) THEN MESSAGE, 'No PROW file found ...'
prow_numbers = FIX(STRMID(prow_names,STRLEN(prowdir)+np1,np2-np1+1))
s = WHERE(prow_numbers GE first AND prow_numbers LE last)
prow_names = prow_names(s)
prow_numbers = prow_numbers(s)

IF skip THEN BEGIN
FOR j=0,(SIZE(data_skipped))(1)-1 DO BEGIN
sk = WHERE(prow_numbers NE data_skipped(j),skcount)
IF skcount GT 0 THEN BEGIN
	prow_numbers = prow_numbers(sk)
	prow_names = prow_names(sk)
ENDIF
ENDFOR
ENDIF

n_prows = (SIZE(prow_names))(1)

PRINT,'Number of PROW files to process : ',(SIZE(prow_names))(1)
;******************************************************************;


;for safety
CLOSE,1


;1/ Get the maximum value, and scale down to the scaledown value.
max=0.

IF scaledown GT 0 THEN BEGIN
FOR i=0,n_prows-1 DO BEGIN

PRINT,'Conversion : Scaling down intensities ...'
prow_name=prow_names(i)
PRINT,STRCOMPRESS('Current PROW file : '+STRMID(prow_name,RSTRPOS(prow_name,'/')+1,STRLEN(prow_name)))
PRINT,'Opening :',prow_name
RESTORE,prow_name

IF combine EQ 1 THEN BEGIN
 ;if gfit is good then rather keep PF, else rather keep BOX 
 integ.intp(0) = integ.intp(0)*integ.gfit+integ.intp(2)*(1-integ.gfit)
ENDIF

IF rm_ovlp EQ 1 THEN  integ=integ(WHERE(integ.ovlp EQ 0))
IF mode EQ 'laue' AND rm_mult EQ 1 THEN  integ=integ(WHERE(integ.mul EQ 1))
IF denzox_state.integ_mode EQ 'laue_soft' AND rm_excluded EQ 1 THEN  integ=integ(WHERE(integ.flag NE 4))

IF save_limited EQ 1 THEN integ = integ(WHERE((SQRT((integ.x)^2+(integ.y)^2) GE rmin) AND (SQRT((integ.x)^2+(integ.y)^2) LE rmax)))
IF rm_outliers EQ 1 THEN integ=integ(WHERE(((integ.flag eq 0) OR (integ.flag EQ 4) OR (integ.res GE keep_lowres)) AND (integ.flag NE 1)))

IF rm_largerms EQ 1 THEN BEGIN
;we use the field .ipoint as a flag
;any problem with that flag ?
badrms_arr = INTARR(N_ELEMENTS(integ))

;IF MAX(integ.ipoint) NE 0 THEN MESSAGE,'Problem with field .ipoint to reject ice spots ...'
max_deviation = 25
sbins = 10.
sbinsize = (1/(2*MIN(integ.res)))^2/sbins
  FOR ind=0,sbins-1 DO BEGIN
    w = WHERE(((1/(2*integ.res)^2) gt ind*sbinsize) and $
	((1/(2*integ.res)^2) le (ind+1)*sbinsize), count)

    IF (count ge 15) THEN BEGIN
     ord=REVERSE(SORT(integ(w).intp(0)))
;     first20=ord(0:FIX(((SIZE(ord))(1)-1)*0.2)>1)
     ;we will now calculate statistics on the 20% highest intensities, leaving out the first 5%
     first20=ord(1>(0.05*(FIX(((SIZE(ord))(1)-1)*0.2)>1)):FIX(((SIZE(ord))(1)-1)*0.2)>1)
     intfirst=(integ(w))(first20)
     ii_rms = STDEV(intfirst.intp(0),ii_mean)
     w2 = WHERE((integ(w).intp(0)-ii_mean) GT max_deviation*ii_rms,ct)
;     IF ct GT 0 THEN integ(w(w2)).ipoint = 1 
     IF ct GT 0 THEN badrms_arr(w(w2)) = 1 
    ENDIF
  ENDFOR
;Plot it ?
;w = WHERE(integ.ipoint EQ 0)
;w2 = WHERE(integ.ipoint EQ 1,ct)
w = WHERE(badrms_arr EQ 0)
w2 = WHERE(badrms_arr EQ 1,ct)
integ = integ(w)
ENDIF


max = max>MAX(integ.intp(0))

ENDFOR
PRINT,'Maximum integrated intensity :',max

ENDIF


;2/ Write x files
 
FOR i=0,n_prows-1 DO BEGIN

prow_name = prow_names(i)
prow_number = STRMID(prow_name,STRLEN(prowdir)+np1,np2-np1+1)
gen_number = ''
FOR loc_i=0,STRLEN(prow_number)-1 DO gen_number=gen_number+'#'
gen_number=STRCOMPRESS(gen_number,/REMOVE_ALL)
x_name = STR_REPLACE(xfile,gen_number,prow_number)
x_name=STRCOMPRESS(xdir+x_name,/REMOVE_ALL)
dummy=FINDFILE(x_name, count=count)
IF (count eq 0) THEN MESSAGE, "Couldn't find original DENZO .x file."

outx_name = STR_REPLACE(outxfile,gen_number,prow_number)
outx_name=STRCOMPRESS(outxdir+outx_name,/REMOVE_ALL)

PRINT,'Conversion : Opening PROW file ...'
PRINT,'Opening :',prow_name
PRINT,STRCOMPRESS('Current PROW file : '+STRMID(prow_name,RSTRPOS(prow_name,'/')+1,STRLEN(prow_name)))
RESTORE,prow_name

;number of initial reflections
num_refl = (SIZE(integ))(1)

PRINT,'Conversion : Selecting reflexions ...'

IF combine EQ 1 THEN BEGIN

 ;if gfit is good then rather keep PF, else rather keep BOX 
 integ.intp(0) = integ.intp(0)*integ.gfit+integ.intp(2)*(1-integ.gfit)
 PLOT,integ.intp(0),integ.intp(2),psym=3,XTITLE='Profile fitted',YTITLE='Scaled box'
 
 wg=WHERE(integ.gfit NE 1,cwg)
 PRINT,'Number of spots with modified PF intensities [combine] : ', cwg

ENDIF

IF rm_ovlp EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
 integ=integ(WHERE(integ.ovlp EQ 0))
PRINT,'Number of rejected spots [overlaped] : ', s1-(SIZE(integ))(1)
ENDIF

IF mode EQ 'laue' AND rm_mult EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
 integ=integ(WHERE(integ.mul EQ 1))
PRINT,'Number of rejected spots [multiples] : ', s1-(SIZE(integ))(1)
ENDIF

IF denzox_state.integ_mode EQ 'laue_soft' AND rm_excluded EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
 integ=integ(WHERE(integ.flag NE 4))
PRINT,'Number of rejected spots [excluded during integration] : ', s1-(SIZE(integ))(1)
ENDIF

IF save_limited EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
integ = integ(WHERE((SQRT((integ.x)^2+(integ.y)^2) GE rmin) AND (SQRT((integ.x)^2+(integ.y)^2) LE rmax)))
PRINT,'Number of rejected spots [outside region] : ', s1-(SIZE(integ))(1)
ENDIF

IF rm_outliers EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
integ=integ(WHERE(((integ.flag eq 0) OR (integ.flag EQ 4) OR (integ.res GE keep_lowres)) AND (integ.flag NE 1)))
PRINT,'Number of rejected spots [outliers] : ', s1-(SIZE(integ))(1)
ENDIF

IF set_neg_thres LT 0 THEN BEGIN
 s1=(SIZE(integ))(1)
 w_pos_thres = WHERE(integ.intp(0) GE set_neg_thres,ct_pos_thres)
IF ct_pos_thres GT 0 THEN integ=integ(w_pos_thres)
PRINT,'Number of rejected spots [intensity below negative threshold] : ', s1-(SIZE(integ))(1)
ENDIF

IF rm_largerms EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
;we use the field .ipoint as a flag
;any problem with that flag ?
;IF MAX(integ.ipoint) NE 0 THEN MESSAGE,'Problem with field .ipoint to reject ice spots ...'
 badrms_arr = INTARR(s1)

;We first select in each resolution bin the 20% higher intensity spots.
;Then we remove the spots which deviate by more than "max_deviation" times
;the rms value
  
max_deviation = 25
sbins = 10. ; the number of resolution bins

sbinsize = (1/(2*MIN(integ.res)))^2/sbins
  FOR ind=0,sbins-1 DO BEGIN
    w = WHERE(((1/(2*integ.res)^2) gt ind*sbinsize) and $
	((1/(2*integ.res)^2) le (ind+1)*sbinsize), count)

    IF (count ge 15) THEN BEGIN
     ord=REVERSE(SORT(integ(w).intp(0)))
;     first20=ord(0:FIX(((SIZE(ord))(1)-1)*0.2)>1)
     ;we will now calculate statistics on the 20% highest intensities, leaving out the first 5%
     first20=ord(1>(0.05*(FIX(((SIZE(ord))(1)-1)*0.2)>1)):FIX(((SIZE(ord))(1)-1)*0.2)>1)
     intfirst=(integ(w))(first20)
     ii_rms = STDEV(intfirst.intp(0),ii_mean)
     w2 = WHERE((integ(w).intp(0)-ii_mean) GT max_deviation*ii_rms,ct)
     IF ct GT 0 THEN BEGIN
;	integ(w(w2)).ipoint = 1 
        badrms_arr(w(w2)) = 1 
     ENDIF
    ENDIF
  ENDFOR
;Plot it ?
;w2 = WHERE(integ.ipoint EQ 1,ct)
w2 = WHERE(badrms_arr EQ 1,ct)

PLOT_OI,integ.res,integ.intp(0),PSYM=3,XTITLE='Resolution [A]', YTITLE='Integrated intensity',XRANGE=[MIN(integ.res),MAX(integ.res)],XSTYLE=1,xticks=FIX(MAX(integ.res)-MIN(integ.res))/2,YRANGE=[MIN(integ.intp(0)),1.2*MAX(integ.intp(0))],YSTYLE=1
IF ct GT 1 THEN OPLOT,integ(w2).res,integ(w2).intp(0),PSYM=2
IF ct EQ 1 THEN XYOUTS,integ(w2).res,integ(w2).intp(0),'*',/DATA
PRINT,'Number of rejected spots [large deviation (ice spots ?)] : ', ct
IF ct GE 1 THEN BEGIN
 PRINT,'	These rejected reflections are : '
 FOR loc_i=0,ct-1 DO PRINT,'	---> : ',integ(w2(loc_i)).m
ENDIF
;integ = integ(WHERE(integ.ipoint EQ 0))
integ = integ(WHERE(badrms_arr EQ 0))
ENDIF

;scale down to max=scaledown if necessary !
IF scaledown GT 0 THEN BEGIN
integ.intp(0) = integ.intp(0)*(scaledown/FLOAT(max))
integ.isigp(0) = integ.isigp(0)*(scaledown/FLOAT(max))
ENDIF

;add sdadd if necessary
;PRINT,'Multiplying by SDADD CAREFULL !!!!!!!!!!!!!!!'
sdadd = 0.025
integ.isigp(0)=SQRT(integ.isigp(0)^2+(sdadd*integ.intp(0))^2)


wz = WHERE(integ.intp(0) LE 0,nz)
PRINT,'Number of negative intensity spots : ',nz
IF set_zero EQ 1 THEN BEGIN
	IF nz GT 0 THEN integ(wz).intp(0) = 1
ENDIF
;the standard deviation should never be zero (scaling effect !)
integ.isigp(0) = integ.isigp(0) > 1

;number of kept reflections
num_kept_refl = (SIZE(integ))(1)
PRINT,'Number of kept reflexions :',num_kept_refl,' ie : ',num_kept_refl/FLOAT(num_refl)*100,' %'

IF mode EQ 'laue' THEN BEGIN
 PRINT,'Conversion : Writing output GEASC file ...'
 outx_name = STR_REPLACE(outx_name,'.geasc','')
 x_name = STR_REPLACE(x_name,'.geasc','')
 WRITE_GEASC,outx_name,integ
 PRINT,'Done !'

 ;get the geasc file with good header 
 ;merge_geasc.scr uses bash shell
 SPAWN,'source ' + GETENV('PROW_SCR') + 'merge_geasc.scr ' + x_name + ' ' + outx_name

 ;get the .ge files
 ;get_ge.scr uses bash shell
 SPAWN,'source ' + GETENV('PROW_SCR') + 'get_ge.scr ' + outx_name

 ;Remove the .geasc file if necessary
 IF savegeasc EQ 0 THEN BEGIN
 SPAWN, '/bin/rm -f ' + STRCOMPRESS(outx_name+'.geasc',/REMOVE_ALL) 
 PRINT,'Removing ',STRCOMPRESS(outx_name+'.geasc',/REMOVE_ALL),' ...'
 ENDIF
ENDIF

IF mode EQ 'mono' THEN BEGIN
 PRINT,'Conversion : Writing output DENZO file ...'
 IF denzo_format EQ 'noyork' THEN WRITE_DENZOX,outx_name,x_name,integ,/NOYORK $
 ELSE WRITE_DENZOX,outx_name,x_name,integ
ENDIF

ENDFOR

JOURNAL
escape : 

;***********************************
END
;***********************************
;-






