FUNCTION READ_R_LIST,name,format=format
;+
; NAME:
;	READ_R_LIST
;
; PURPOSE:
;	Read in a real-space R-factor list from CNS.
;
; CATEGORY:
;	Input/Output
;
; CALLING SEQUENCE:
;   Result = READ_R_LIST(name,[format=format])
;
; INPUTS:
;	NAME: String containing the name of the R-list file.
;	format : [optionnal] for a special format just in case. 
;	default format is : '(7X,I4,A6,A3,2X,I4,4X,3F8.3,F6.2,F6.2)'
;
; OUTPUTS:
;	READ_R_LIST returns a structure with the atom info
;	.res1	-->	residue number 1
;	.res2	-->	residue number 2
;	.name	-->	residue name
;	.c	-->	correlation
;	.r	-->	r-factor
;
; SIDE EFFECTS:
;	A file is read.
;
; COMMENTS:
;	The number of residues is limited by MAX_AT.
;
; MODIFICATION HISTORY:
;       Written by D. Bourgeois January 2000.
;-

;on_error,2                      ;Return to caller if an error occurs

max_res=50000
i=0L
cr = STRING("15b)

openr, file, name, /get_lun

IF N_ELEMENTS(format) EQ 0 THEN format = '(2X,I4,3X,-I4,1X,A6,2F7.3)'

residue = {res1:0L, res2:0L, name:'', c:0.0, r:0.0}
mol = replicate(residue, max_res) 

res1=0L & res2=0L & name='' & c=0.0 & r=0.0 
dummy=''
i=0

READF, file, dummy
WHILE (NOT EOF(file)) DO BEGIN
  IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' residues read',A)",i,cr
  READF, file, dummy
  READS,dummy,FORMAT=format,res1,res2,name,c,r
  mol(i).res1 =  res1
  mol(i).res2 =  res2
  mol(i).name =  name
  mol(i).c = c
  mol(i).r = 100*r
  i = i + 1
ENDWHILE

free_lun, file

mol = mol(0:i-1)

PRINT,'Total number of residues (including waters) : ',(SIZE(mol))(1)

mol.name = STRCOMPRESS(mol.name,/REMOVE_ALL)
return, mol
END 



