PRO MODIF_PDB, pdbin, pdbmod, pdbout, resid_number
;+
; NAME:
;	MODIF_PDB
;
; PURPOSE:
;
; 	Modifies a PDB file (pdbin) for certain residues (resid_number). 
;	The xyz values of these residues are in pdbmod, and the modifies pdb 
;	is output in pdbout
;
; CATEGORY:
;	File managing
;
; CALLING SEQUENCE:
;	MODIF_PDB, pdbin, pdbmod, pdbout, resid_number
;
; INPUTS:
;	pdbin : the input pdb file
;	pdbmod : the pdbfile containing the modified residues
;	resid_number : an array of the residue numbers to be modified.
;
; OUTPUTS:
;	pdbout : the output pdb (=pdbin + pdbmod(the modified residues))
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;
; MODIFICATION HISTORY:
;	D.Bourgeois, December 2002.
;-

;pdbin is the file to be modified
IF N_ELEMENTS(pdbin) EQ 0 THEN $
 pdbin = 'final_guess_3ns.pdb'

;pdbmod is the PDB file containing modifications
IF N_ELEMENTS(pdbmod) EQ 0 THEN $
pdbmod = 'final_light_with_CO.pdb'

;residue number of the residue to be changed
IF N_ELEMENTS(resid_number) EQ 0 THEN $
resid_number = [29, 43, 93, 200]

;pdbout is the PDB file to be written out
IF N_ELEMENTS(pdbout) EQ 0 THEN $
pdbout = 'out.pdb' 

;End od input

pdb1 = READ_PDB(pdbin,/CNS,header=header1)
pdb2 = READ_PDB(pdbmod,/CNS,header=tmp_header)

n_atoms1 = (SIZE(pdb1))(1)

n_resid = (SIZE(resid_number))(1)
FOR i=0, n_resid-1 DO BEGIN

 pdb = pdb2(WHERE(pdb2.rn EQ resid_number(i),ct_at2))

 PRINT, ct_at2, ' atoms found for residue: ', resid_number(i)
 r = pdb(0).r
 rn = pdb(0).rn

 w_atom = WHERE((pdb1.rn EQ rn AND pdb1.r EQ r) ,ct_atom)
 IF ct_atom GT 0 THEN BEGIN
  PRINT,'Replacing coordinates for residue: ',resid_number(i)
  ;replace x,y,z for each atom
  FOR j=0,ct_atom-1 DO BEGIN
   atom = pdb1(w_atom(j))
   w_type = WHERE(pdb.t EQ atom.t,ct_type)
   IF ct_type EQ 1 THEN BEGIN
    atom.x = pdb(w_type(0)).x
    atom.y = pdb(w_type(0)).y
    atom.z = pdb(w_type(0)).z
   ENDIF ELSE MESSAGE,'More than one possibility found for atom: '+ STRING(atom.n)
   pdb1(w_atom(j))=atom
  ENDFOR
 ENDIF
ENDFOR

WRITE_PDB,pdb1,pdbout,/CNS,header=header1
END

