function GET_UNIQUE, ref, sg_no=sg_no,centric=centric,epsilon=epsilon,anomal=anomal
;+
; NAME: GET_UNIQUE
;		
; TO ENTER NEW SPACE GROUPE :
;	FOLLOW EXEMPLE OF SG 180.
;	1/ On NICE in  /disk32/bourgeoi/ccp4 run :
;		A/ f2mtz_create.com
;		B/ cad_create.com > ! cad.out
;		C/ Look at cad.out.
;
; PURPOSE:
;	Change indices hkl to the symmetry unique indices
;	as in CCP4. (Friedel pairs are treated as the same 
;	reflection unless the keyword ANOMAL is set.)
;	Only some space groups are available at the moment.
;	OPTION ANOMAL NOT SET AT THE MOMENT
;	The ROUTINE EQUIV_HKL.PRO could be used instead but apparently it is 
;	buggy for some space groups ...
;
; CATEGORY:
;	
;
; CALLING SEQUENCE:
;	unique = GET_UNIQUE(ref,[sg_no=sg_no], [anomal=anomal])
;
; INPUTS:
;	REF: The structure containing the reflections.
;	Must contain a tag "m" which is an array(3) of
;	the indices (hkl).  
;	sg_no : the spacegroup number.
;	ANOMAL: Keyword. If set and non-zero then bijvoet-pairs
;	are not treated as the same reflection.
;
; OUTPUTS:
;	The same structure where the indices have been changed
;	to be in one assymetric unit.	
;	Centric : the centric zones
;	Epsilon : the epsilon zones
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	All the symmetry were generated using the CCP4 program CAD.
;	For Centric reflexion : 
;		If refections of a class are centro symmetric, then the corresponding
;		element should be set to 1. 
;		zones are      hkl,    hk0,    h0l,    0kl,    h00,    0k0,    00l
;	For Epsilon zones : (See Stewart & Karle Acta A 32, 1976, p1005)
;		zones are      hkl,    hk0,    h0l,    0kl,    h00,    0k0,    00l
; MODIFICATION HISTORY:
;	Written by Dominique BOURGEOIS, October 1998
;-

on_error,2                              ;Return to caller if an error occurs

unique= ref

IF KEYWORD_SET(anomal) THEN MESSAGE,'Anomal KEYWORD option not working !'
IF N_ELEMENTS(sg_no) EQ 0 THEN MESSAGE,'You need to specify a space group number !'

nref = (size(ref))(1)
h=ref.m(0) & k=ref.m(1) & l=ref.m(2)

CASE sg_no OF 
	1 : BEGIN
	 nsym=2
	 ;zones are      hkl,    hk0,    h0l,    0kl,    h00,    0k0,    00l
	 centric = [      0.0,    0.0,    0.0,    0.0,    0.0,    0.0,    0.0]
	 epsilon = [      1.0,    1.0,    1.0,    1.0,    1.0,    1.0,    1.0]
	 sym=INTARR(nref,nsym,3)
	 all_h=INTARR(nref,nsym,/NOZERO) & all_k=INTARR(nref,nsym,/NOZERO) & all_l=INTARR(nref,nsym,/NOZERO)

	all_h(*,0)=h & all_k(*,0)=k & all_l(*,0)=l
	all_h(*,1)=-h & all_k(*,1)=-k & all_l(*,1)=-l

	w=WHERE(all_k GE 0,ct)
	IF ct GT 0 THEN BEGIN
	 w2=WHERESUB(w,all_h)
	 unique(FLOAT(w2)).m(0) = all_h(w)
	 unique(FLOAT(w2)).m(1) = all_k(w)
	 unique(FLOAT(w2)).m(2) = all_l(w)
	ENDIF
	RETURN, unique
	END

	4 : BEGIN
  	 nsym=4
	 ;zones are      hkl,    hk0,    h0l,    0kl,    h00,    0k0,    00l
	 centric = [      0.0,    0.0,    1.0,    0.0,    0.0,    0.0,    0.0]
	 epsilon = [      1.0,    1.0,    2.0,    1.0,    2.0,    2.0,    2.0]
	 sym=INTARR(nref,nsym,3)
	 all_h=INTARR(nref,nsym,/NOZERO) & all_k=INTARR(nref,nsym,/NOZERO) & all_l=INTARR(nref,nsym,/NOZERO)

	all_h(*,0)=h & all_k(*,0)=k & all_l(*,0)=l
	all_h(*,1)=-h & all_k(*,1)=-k & all_l(*,1)=-l
	all_h(*,2)=-h & all_k(*,2)=k & all_l(*,2)=-l
	all_h(*,3)=h & all_k(*,3)=-k & all_l(*,3)=l

	w=WHERE(all_k GE 0 and all_l GT 0,ct)
	IF ct GT 0 THEN BEGIN
	 w2=WHERESUB(w,all_h)

	 unique(FLOAT(w2)).m(0) = all_h(w)
	 unique(FLOAT(w2)).m(1) = all_k(w)
	 unique(FLOAT(w2)).m(2) = all_l(w)
	ENDIF

	w=WHERE(all_l EQ 0,ct)
	IF ct GT 0 THEN BEGIN
	 w2=WHERESUB(w,all_h)

	 unique(FLOAT(w2)).m(0) = all_h(w)
	 unique(FLOAT(w2)).m(1) = all_k(w)
	 unique(FLOAT(w2)).m(2) = all_l(w)
	ENDIF

	RETURN, unique
	END

	173 : BEGIN
  	 nsym=12
	 ;zones are      hkl,    hk0,    h0l,    0kl,    h00,    0k0,    00l
	 centric = [      0.0,    1.0,    0.0,    0.0,    0.0,    0.0,    0.0]
	 epsilon = [      1.0,    2.0,    1.0,    1.0,    2.0,    2.0,    6.0]
	 sym=INTARR(nref,nsym,3)
	 all_h=INTARR(nref,nsym,/NOZERO) & all_k=INTARR(nref,nsym,/NOZERO) & all_l=INTARR(nref,nsym,/NOZERO)

	 all_h(*,0)=h & all_k(*,0)=k & all_l(*,0)=l ;<--- CHANGE HERE
	 all_h(*,1)=-h & all_k(*,1)=-k & all_l(*,1)=-l ;<--- CHANGE HERE
	 all_h(*,2)=-h-k & all_k(*,2)=h & all_l(*,2)=l ;<--- CHANGE HERE
	 all_h(*,3)=h+k & all_k(*,3)=-h & all_l(*,3)=-l ;<--- CHANGE HERE
	 all_h(*,4)=k & all_k(*,4)=-h-k & all_l(*,4)=l ;<--- CHANGE HERE
	 all_h(*,5)=-k & all_k(*,5)=h+k & all_l(*,5)=-l ;<--- CHANGE HERE
	 all_h(*,6)=-h & all_k(*,6)=-k & all_l(*,6)=l ;<--- CHANGE HERE
	 all_h(*,7)=h & all_k(*,7)=k & all_l(*,7)=-l ;<--- CHANGE HERE
	 all_h(*,8)=h+k & all_k(*,8)=-h & all_l(*,8)=l ;<--- CHANGE HERE
	 all_h(*,9)=-h-k & all_k(*,9)=h & all_l(*,9)=-l ;<--- CHANGE HERE
	 all_h(*,10)=-k & all_k(*,10)=h+k & all_l(*,10)=l ;<--- CHANGE HERE
	 all_h(*,11)=k & all_k(*,11)=-h-k & all_l(*,11)=-l ;<--- CHANGE HERE

	 w=WHERE(all_h GT 0 and all_k GT 0 and all_l GE 0,ct) ; <--- CHANGE HERE

	 IF ct GT 0 THEN BEGIN
	  w2=WHERESUB(w,all_h)

	  unique(FLOAT(w2)).m(0) = all_h(w)
	  unique(FLOAT(w2)).m(1) = all_k(w)
	  unique(FLOAT(w2)).m(2) = all_l(w)
	 ENDIF

	 w=WHERE(all_h EQ 0 and all_k GE 0 and all_l GE 0,ct) ; <--- CHANGE HERE
	 IF ct GT 0 THEN BEGIN
	  w2=WHERESUB(w,all_h)

	  unique(FLOAT(w2)).m(0) = all_h(w)
	  unique(FLOAT(w2)).m(1) = all_k(w)
	  unique(FLOAT(w2)).m(2) = all_l(w)
	 ENDIF

	 RETURN, unique
	END


	180 : BEGIN
  	 nsym=24 ;<--- CHANGE HERE
	 ;zones are      hkl,    hk0,    h0l,    0kl,    h00,    0k0,    00l
	 centric = [      0.0,    1.0,    1.0,    1.0,    1.0,    1.0,    1.0]
	 epsilon = [      1.0,    1.0,    1.0,    1.0,    2.0,    2.0,    6.0]
	 sym=INTARR(nref,nsym,3)
	 all_h=INTARR(nref,nsym,/NOZERO) & all_k=INTARR(nref,nsym,/NOZERO) & all_l=INTARR(nref,nsym,/NOZERO)

	 all_h(*,0)=h & all_k(*,0)=k & all_l(*,0)=l ;<--- CHANGE HERE
	 all_h(*,1)=-h & all_k(*,1)=-k & all_l(*,1)=-l ;<--- CHANGE HERE
	 all_h(*,2)=-h-k & all_k(*,2)=h & all_l(*,2)=l ;<--- CHANGE HERE
	 all_h(*,3)=h+k & all_k(*,3)=-h & all_l(*,3)=-l ;<--- CHANGE HERE
	 all_h(*,4)=k & all_k(*,4)=-h-k & all_l(*,4)=l ;<--- CHANGE HERE
	 all_h(*,5)=-k & all_k(*,5)=h+k & all_l(*,5)=-l ;<--- CHANGE HERE
	 all_h(*,6)=-h & all_k(*,6)=-k & all_l(*,6)=l ;<--- CHANGE HERE
	 all_h(*,7)=h & all_k(*,7)=k & all_l(*,7)=-l ;<--- CHANGE HERE
	 all_h(*,8)=h+k & all_k(*,8)=-h & all_l(*,8)=l ;<--- CHANGE HERE
	 all_h(*,9)=-h-k & all_k(*,9)=h & all_l(*,9)=-l ;<--- CHANGE HERE
	 all_h(*,10)=-k & all_k(*,10)=h+k & all_l(*,10)=l ;<--- CHANGE HERE
	 all_h(*,11)=k & all_k(*,11)=-h-k & all_l(*,11)=-l ;<--- CHANGE HERE
	 all_h(*,12)=k & all_k(*,12)=h & all_l(*,12)=-l ;<--- CHANGE HERE
	 all_h(*,13)=-k & all_k(*,13)=-h & all_l(*,13)=l ;<--- CHANGE HERE
	 all_h(*,14)=h & all_k(*,14)=-h-k & all_l(*,14)=-l ;<--- CHANGE HERE
	 all_h(*,15)=-h & all_k(*,15)=h+k & all_l(*,15)=l ;<--- CHANGE HERE
	 all_h(*,16)=-h-k & all_k(*,16)=k & all_l(*,16)=-l ;<--- CHANGE HERE
	 all_h(*,17)=h+k & all_k(*,17)=-k & all_l(*,17)=l ;<--- CHANGE HERE
	 all_h(*,18)=-k & all_k(*,18)=-h & all_l(*,18)=-l ;<--- CHANGE HERE
	 all_h(*,19)=k & all_k(*,19)=h & all_l(*,19)=l ;<--- CHANGE HERE
	 all_h(*,20)=-h & all_k(*,20)=h+k & all_l(*,20)=-l ;<--- CHANGE HERE
	 all_h(*,21)=h & all_k(*,21)=-h-k & all_l(*,21)=l ;<--- CHANGE HERE
	 all_h(*,22)=h+k & all_k(*,22)=-k & all_l(*,22)=-l ;<--- CHANGE HERE
	 all_h(*,23)=-h-k & all_k(*,23)=k & all_l(*,23)=l ;<--- CHANGE HERE

	 w=WHERE(all_h GE 0 and all_k GE 0 and all_l GE 0 and (all_h-all_k) GE 0 ,ct) ; <--- CHANGE HERE

	 w=w(0:nref-1)
	 IF ct GT 0 THEN BEGIN
	  w2=WHERESUB(w,all_h)
	  unique(FLOAT(w2)).m(0) = all_h(w)
	  unique(FLOAT(w2)).m(1) = all_k(w)
	  unique(FLOAT(w2)).m(2) = all_l(w)
	 ENDIF

	 RETURN, unique
	END

	ELSE:BEGIN
	 ;zones are      hkl,    hk0,    h0l,    0kl,    h00,    0k0,    00l
	 centric = [      0.0,    0.0,    0.0,    0.0,    0.0,    0.0,    0.0]
	 epsilon = [      1.0,    1.0,    1.0,    1.0,    1.0,    1.0,    1.0]
	 PRINT,'Space group not implemented !'
	 RETURN,ref
	END
ENDCASE


END