FUNCTION READ_RAXIS, file=file,erase=erase,display=display,NO_ROTATE=no_rotate,SIZE_OF_IMAGE=size_of_image,ONLY_READ_SIZE=only_read_size
;+
; NAME:
;	READ_RAXIS
;
; PURPOSE:
;	Read RAXIS images.

; CATEGORY:
;	Input/output.
;
; CALLING SEQUENCE:
;   Result = READ_RAXIS([file=file],[/erase],[display=n],[NO_ROTATE=no_rotate])
;
; INPUTS:
;	File {optionnal]: A string containing the name of file to read.
;	If the file ends with ".Z" the program assumes
;	the file has been compressed with the unix "compress"
;	command and will uncompress the file before reading.
;	Erase [optional]: set this keyword to erase previous windows.
;	No_rotate [optional]: set this keyword to avoid rotating image
; 	Display [optional] : set display = n to display the Log of the image
;				rebinned by a factor of n
;
; OUTPUTS:
;	READ_RAXIS returns a long array containing the image data.
;
;
; SIDE EFFECTS:
;	A file is read.
;
;
; MODIFICATION HISTORY:
;       Written by Dominique BOURGEOIS, May 2000
;-

on_error,2                      ;Return to caller if an error occurs

IF N_ELEMENTS(file) EQ 0 THEN BEGIN
 path = GETENV('DATA')
 file=PICKFILE(/READ,PATH=path,FILTER=['*'])
ENDIF

; Check if the file is compressed and act accordingly
; The temporary file is deleted after it has been read
;
IF (STRMID(file,(STRLEN(file)-2)(0),2) EQ '.Z') THEN BEGIN
 PRINT, 'Comressed File! - Uncompressing...'
 SPAWN,  'uncompress ' + file + ' >! /tmp/spefile.tmp'
 file = '/tmp/spefile.tmp'
ENDIF

IF N_ELEMENTS(lun) LE 0 THEN lun = -1	;Clean up
IF lun GT 0 THEN FREE_LUN, lun
OPENR,lun,file, ERROR = i, /GET_LUN, /BLOCK
IF i LT 0 THEN BEGIN 			; Something wrong, 
 IF lun GT 0 THEN FREE_LUN,lun
 lun = -1
 MESSAGE, 'Unable to open file: ' + file
 GOTO, nothing
ENDIF

swap=0
;Read the header:
rax_device=BYTARR(10,/NOZERO)
READU,lun,rax_device
rax_version=BYTARR(10,/NOZERO)
READU,lun,rax_version
rax_crystal=BYTARR(20,/NOZERO)
READU,lun,rax_crystal
rax_cryo=BYTARR(12,/NOZERO)
READU,lun,rax_cryo
rax_cell=FLTARR(6,/NOZERO)
READU,lun,rax_cell
rax_space=BYTARR(12,/NOZERO)
READU,lun,rax_space
rax_mosaic=FLTARR(1,/NOZERO)
READU,lun,rax_mosaic
rax_memo=BYTARR(80,/NOZERO)
READU,lun,rax_memo
rax_reserve1=BYTARR(84,/NOZERO)
READU,lun,rax_reserve1
rax_date=BYTARR(12,/NOZERO)
READU,lun,rax_date
rax_operator=BYTARR(20,/NOZERO)
READU,lun,rax_operator
rax_target=BYTARR(4,/NOZERO)
READU,lun,rax_target
rax_wavelength=FLTARR(1,/NOZERO)
READU,lun,rax_wavelength
rax_monochro=BYTARR(20,/NOZERO)
READU,lun,rax_monochro
rax_fmono_2=FLTARR(1,/NOZERO)
READU,lun,rax_fmono2
rax_collimator=BYTARR(20,/NOZERO)
READU,lun,rax_collimator
rax_filter=BYTARR(4,/NOZERO)
READU,lun,rax_filter
rax_camera=FLTARR(1,/NOZERO)
READU,lun,rax_camera
rax_fkv=FLTARR(1,/NOZERO)
READU,lun,rax_fkv
rax_fma=FLTARR(1,/NOZERO)
READU,lun,rax_fma
rax_focus=BYTARR(12,/NOZERO)
READU,lun,rax_focus
rax_xraymemo=BYTARR(80,/NOZERO)
READU,lun,rax_xraymemo
rax_ncylinder=LONARR(1,/NOZERO)
READU,lun,rax_ncylinder
rax_weissenberg=FLTARR(1,/NOZERO)
READU,lun,rax_weissenberg
rax_reserve2=BYTARR(56,/NOZERO)
READU,lun,rax_reserve2
rax_spindle=BYTARR(4,/NOZERO)
READU,lun,rax_spindle
rax_xrayaxis=BYTARR(4,/NOZERO)
READU,lun,rax_xrayaxis
rax_phi=FLTARR(3,/NOZERO)
READU,lun,rax_phi
rax_noscillations=LONARR(1,/NOZERO)
READU,lun,rax_noscillations
rax_exposure_time=FLTARR(1,/NOZERO)
READU,lun,rax_exposure_time
rax_xray=FLTARR(2,/NOZERO)
READU,lun,rax_xray
rax_circle=FLTARR(3,/NOZERO)
READU,lun,rax_circle
rax_mu=FLTARR(1,/NOZERO)
READU,lun,rax_mu
rax_scantemplate=BYTARR(204,/NOZERO)
READU,lun,rax_scantemplate
rax_pixnum=LONARR(2,/NOZERO)
READU,lun,rax_pixnum
rows=rax_pixnum(0) & columns=rax_pixnum(1)
IF ABS(rows) GT 10000. OR ABS(columns) GT 10000. THEN swap=1 
IF swap THEN BEGIN
 IF KEYWORD_SET(only_read_size) THEN PRINT,'*** Image will be byte swaped ! ***'
 BYTEORDER,rows,/LSWAP
 BYTEORDER,columns,/LSWAP
ENDIF
size_of_image=[rows,columns]
rax_pixsize=FLTARR(2,/NOZERO)
READU,lun,rax_pixsize
rax_record=LONARR(2,/NOZERO)
READU,lun,rax_record
IF swap THEN BYTEORDER,rax_record,/LSWAP
tmp_rows=rax_record(0)/2 & tmp_columns=rax_record(1)
;PRINT,tmp_rows,tmp_columns
rax_read_start=LONARR(1,/NOZERO)
READU,lun,rax_read_start
rax_ipnum=LONARR(1,/NOZERO)
READU,lun,rax_ipnum
rax_fratio=FLTARR(1,/NOZERO)
READU,lun,rax_fratio
rax_fading=FLTARR(2,/NOZERO)
READU,lun,rax_fading
rax_cpu=BYTARR(10,/NOZERO)
READU,lun,rax_cpu
rax_cip=BYTARR(10,/NOZERO)
READU,lun,rax_cip
rax_drxz=LONARR(3,/NOZERO)
READU,lun,rax_drxz
rax_reserve4=BYTARR(180,/NOZERO)
READU,lun,rax_reserve4
rax_reserve5=BYTARR(1024,/NOZERO)
READU,lun,rax_reserve5

IF NOT KEYWORD_SET(only_read_size) THEN BEGIN
 PRINT,'Number of rows, columns are: ', rows, columns
 image = LONARR(tmp_rows,tmp_columns, /NOZERO)
 image_size = LONG(tmp_rows)*LONG(tmp_columns)
 offset=2*tmp_rows

 FREE_LUN, lun
 PRINT, 'Converting to Long Integer.'

swap=0
 IF swap THEN $
 dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'ii_swap', image, image_size, file, long(offset)) $
 ELSE $
 dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'no_swap', image, image_size, file, long(offset)) 

 image=image(0:rows-1,0:columns-1)
 PRINT,'Updating large pixels values ...'
 w_big=WHERE(image GE 2.0^15,ct_big)
 PRINT,'Number of pixels with large values: ',ct_big
 IF ct_big GE 1 THEN image(w_big)=(image(w_big)-2.0^15)*2.0^5

 IF NOT KEYWORD_SET(no_rotate) THEN BEGIN
  PRINT,'Rotating image ...'
  image=ROTATE(TEMPORARY(image),4)
 ENDIF

 ;shall we erase previous windows ?
 IF KEYWORD_SET(erase) THEN REPEAT WDELETE UNTIL !D.WINDOW EQ -1

 ;following trick gives the right window number on the title
 IF KEYWORD_SET(display) THEN BEGIN
  WINDOW,!d.window+1,title=file+'  window:'+STRING(!D.WINDOW+1),xsize=rows/display,ysize=columns/display
  PRINT,'Displaying on window : ',!D.WINDOW
  IF display NE 1 THEN TVSCL,ALOG(REBIN(image,rows/display,columns/display)>1) ELSE TVSCL,alog(image>1)
 ENDIF

 PRINT, 'Done'
 RETURN, image
ENDIF

nothing:
RETURN,0

end






















