FUNCTION READ_DENZO_MAR, file=file,rows=rows,columns=columns,offset=offset,erase=erase,display=display,NO_ROTATE=no_rotate,mar345=mar345
;+
; NAME:
;	READ_DENZO_MAR
;
; PURPOSE:
;	Used to read images of format DENZO MAR.

; CATEGORY:
;	Input/output.
;
; CALLING SEQUENCE:
;   Result = READ_DENZO_MAR([file=file],[rows=rows],[colums=columns],
;	[offset=offset],[/erase],[display=n],[NO_ROTATE=no_rotate),
;	[mar345=345]
;
; INPUTS:
;	File {optionnal]: A string containing the name of file to read.
;	If the file ends with ".Z" the program assumes
;	the file has been compressed with the unix "compress"
;	command and will uncompress the file before reading.
;	Rows [optional]:the number of rows in the image : default=1200
;	Columns [optional]: the number of columns : default = 1200
;	Offset [optional]: the offset at which the data start : default = 2400
;	Erase [optional]: set this keyword to erase previous windows.
; 	Display [optional] : set display = n to display the Log of the image
;				rebinned by a factor of n
;	No_rotate [optional]: set this keyword to avoid rotating image
;	mar345    [optional]: set this keyword if the MAR345 is used
;
; OUTPUTS:
;	READ_DENZO_MAR returns a long array containing the image data.
;
;
; SIDE EFFECTS:
;	A file is read.
;
;
; MODIFICATION HISTORY:
;       Written by Dominique BOURGEOIS, July 1996
;-

on_error,2                      ;Return to caller if an error occurs

IF N_ELEMENTS(file) EQ 0 THEN BEGIN
 file=PICKFILE(/READ,PATH=GETENV('DATA'),FILTER=['*'])
ENDIF

; Check if the file is compressed and act accordingly
; The temporary file is deleted after it has been read
;
if (strmid(file,(strlen(file)-2)(0),2) eq '.Z') then begin
	print, 'Comressed File! - Uncompressing...'
	spawn,  'zcat ' + file + ' >! /tmp/spefile.tmp'
	file = '/tmp/spefile.tmp'
endif

if n_elements(lun) le 0 then lun = -1	;Clean up
if lun gt 0 then free_lun, lun
openr,lun,file, error = i, /GET_LUN, /BLOCK
if i lt 0 then begin 			; Something wrong, 
	if lun gt 0 then free_lun,lun
	lun = -1
	print, 'Unable to open file: ' + file
	goto, nothing
endif
$ rm -f /tmp/gelfile.tmp
;
; Get image sizes
;

;first read the file header (2050 short int) as an int array
header = INTARR(1200,/NOZERO)
READU,lun,header
IF !version.os EQ 'linux' THEN BYTEORDER,header

;get the number of rows and columns
IF N_ELEMENTS(rows) EQ 0 THEN rows = header(1)
IF N_ELEMENTS(columns) EQ 0 THEN columns = header(3)

IF (rows EQ 1200) AND (columns EQ 1200) THEN PRINT,'Small MAR format : 1200x1200'
IF (rows EQ 2000) AND (columns EQ 2000) THEN PRINT,'Big MAR format : 2000x2000'
IF (rows EQ 2300) AND (columns EQ 2300) THEN PRINT,'MAR 345 format : 2300x2300'
IF (rows EQ 1600) AND (columns EQ 1600) THEN PRINT,'MAR 345 format : 1600x1600'
;IF ((rows NE 2000) AND (rows NE 1200) AND (rows NE 2300) AND (rows NE 1600)) OR ((columns NE 2000) AND (columns NE 1200) AND (columns NE 2300) AND (columns NE 1600)) THEN PRINT,'Unknown format : ',rows,columns

IF NOT KEYWORD_SET(mar345) THEN BEGIN
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 1200) AND (columns EQ 1200)) THEN offset = 2400
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 2000) AND (columns EQ 2000)) THEN offset = 4000
ENDIF
IF (KEYWORD_SET(mar345)) THEN BEGIN
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 2300) AND (columns EQ 2300)) THEN offset = 4600
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 2000) AND (columns EQ 2000)) THEN offset = 4000
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 1600) AND (columns EQ 1600)) THEN offset = 3200
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 1200) AND (columns EQ 1200)) THEN offset = 2400
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 3450) AND (columns EQ 3450)) THEN offset = 6900
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 3000) AND (columns EQ 3000)) THEN offset = 6000
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 2400) AND (columns EQ 2400)) THEN offset = 4800
 IF (N_ELEMENTS(offset) EQ 0) AND ((rows EQ 1800) AND (columns EQ 1800)) THEN offset = 3600
ENDIF

;seek for saturated pixels (>=65535)
n_sat= header(9)
PRINT, 'Number of saturated pixels : ',header(9)

IF n_sat GE 1 THEN BEGIN
POINT_LUN,lun,LONG(rows)*LONG(columns)*2+LONG(offset)   
sat_info = LONARR(n_sat*2,/NOZERO)
READU,lun,sat_info
IF !version.os EQ 'linux' THEN BYTEORDER,sat_info,/LSWAP

pos_info = LONARR(n_sat)
int_info = LONARR(n_sat)
FOR i=0,n_sat-1 DO BEGIN
	pos_info(i)=sat_info(2*i)
	int_info(i)=sat_info(2*i+1)
ENDFOR
ENDIF

free_lun, lun

print, 'Converting to Long Integer.'

image = lonarr(rows, columns, /nozero)

image_size = long(rows)*long(columns)

dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'no_swap', image, image_size, file, long(offset))

IF n_sat GE 1 THEN BEGIN
PRINT,'Updating large pixel values ...'
image(pos_info-1)=int_info
ENDIF

IF NOT KEYWORD_SET(no_rotate) THEN BEGIN
 PRINT,'Rotating image ...'
 IF KEYWORD_SET(mar345) THEN $
 	image=ROTATE(TEMPORARY(image),5) $
 ELSE $
 	image=ROTATE(TEMPORARY(image),4)
ENDIF

;shall we erase previous windows ?
IF KEYWORD_SET(erase) THEN REPEAT WDELETE UNTIL !D.WINDOW EQ -1

;following trick gives the right window number on the title
IF KEYWORD_SET(display) THEN BEGIN
window,!d.window+1,title=file+'  window:'+STRING(!D.WINDOW+1),xsize=rows/display,ysize=columns/display
print,!d.window
IF display NE 1 THEN TVSCL,ALOG(REBIN(image,rows/display,columns/display)>1) ELSE TVSCL,alog(image>1)
ENDIF

print, 'Done'
return, image

nothing:
return,0

end






















