function GET_FITLEVEL,prof,peak_max,n_back,back,dark_current,$
				bg_gain=bg_gain,gain=gain,show=show
;+
; NAME:
;	GET_FITLEVEL
;
; PURPOSE:
;
;	For profile fitting, returns the optimal cutoff for peak integration.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	cutoff = GET_FITLEVEL(prof,peak_max,nback,back,dark_current,$
;					bg_gain=bg_gain,gain=gain,/show)
;
; INPUTS:
;	prof : the reference profile for the spot to integrate
;	peak_max : the (non background subtracted) peak value of the spot to integrate
;	nback : the number of pixels used to calculate the background
;	back : the constant level background value (including any offset or dark_current).
;	dark_current : value of offset or dark current in the detector 
;	bg_gain : this is the detector gain for the background
;	gain : this is the detector gain for spot
;	show : set this keyword to show information
;
; OUTPUTS:
;	cutoff : the optimum fit_level [% MAX(prof)]	
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	The variance is calculated for a serie of cutoff values
;	(from 0% to 20%), the cutoff corresponding to the 
;	smallest variance is retained, with a minimum of 0.1%
;
; MODIFICATION HISTORY:
;	D.Bourgeois, April 1997.
;	Julien Bourgeoi, August 97
;-


IF (NOT KEYWORD_SET(bg_gain)) OR (NOT KEYWORD_SET(gain)) THEN BEGIN
 bg_gain=float(1) & gain=float(1)
ENDIF

s = SIZE(prof)
xs = s(1)
ys = s(2)

cutoff = 0.
IF KEYWORD_SET(show) THEN _show = 1L ELSE _show = 0L

dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'get_fitlevel.so'), 'get_fitlevel', FLOAT(prof), FLOAT(peak_max), LONG(n_back), FLOAT(back), FLOAT(dark_current), FLOAT(bg_gain), FLOAT(gain), _show, xs, ys, cutoff)
RETURN,cutoff

END








