#include <stdio.h>
#include <math.h>
#include "Types.h"
#include "Manip.h"

#define PERCENTAGE   25.0
#define DARK_CURRENT 0
#define GAIN         1.2
#define MAX_CYCLE    100

/*
   parameters are in the follwing order:
   
   INPUTS                         IDL TYPE
   argv[0] = the array to process LONG ARRAY (xdim x ydim)
   argv[1] = xdim                 LONG 
   argv[2] = ydim                 LONG
   argv[3] = percentage           FLOAT
   argv[4] = dark_current         FLOAT
   argv[5] = show                 LONG

   OUTPUTS
   argv[6] = noise_index          LONG ARRAY (?x1)
   argv[7] = background           FLOAT ARRAY
   */

void back2d_quick(argc,argv)
int argc;
void *argv[];
{
  /* on se dit qu'un array a deux dimensions a et b
     equivaut a un array de dimension a.b */

  /* variables */

  /* in order to iterate, count, etc. */
  /* the use of some of them could be avoid */
  int i,j,k=0;
  long k1, k2, k3, k4;
  long   sf1, sf2, sf3, sf4;
  int number_cycle;
  int number_back;
  float corr_fac = 0.0;
  int rejected = 1;
  int count1, count2, count3, count4;
  int count;
  int *indx;
  float d;
  long *ix;

  /* dimensions of arrays */
  int xsize = *(int *) argv[1];
  int ysize = *(int *) argv[2];
  long totsize = xsize*ysize;
  
  /* command line options */
  float percentage = PERCENTAGE;
  float dark_current = DARK_CURRENT;
  float perc = (int) PERCENTAGE;
  int show = 0;
  int max_cycle = MAX_CYCLE;

  float *_coeff;
  long *_noise_index;
  float *_o_data;
  float *_res;

  long n_back;
  float bc_mean;
  int bad_flag = 0;

  long *_image = (long *) argv[0];
  
  /* lots of arrays ... */

  Array array;
  Array array1, array2, array3, array4;
  Array wd1, wd2, wd3, wd4;
  Array w1, w2, w3, w4;
  Array ni1, ni2, ni3, ni4;
  Array w;
  Array xy1, xy2, xy3, xy4;
  Array wf1, wf2, wf3, wf4;

  Array noise_index;
  Array noise_density;

  /* indispensable for pointers referencing */
  
  Array ref, ref2;
  FArray fref, fref2;


  /* --- LOADING INPUTS --- */
  _image = (long *) argv[0];
  xsize = *(int*) argv[1];
  ysize = *(int*) argv[2];
  perc = *(float*) argv[3];
  percentage = (float) perc;
  dark_current = *(float *) argv[4];
  show = *(int*) argv[5];

   /* --- AND OUTPUTS --- */
   _noise_index = (long *) argv[6];
   _res = (float *) argv[7];

  array = CreateArray(xsize,ysize);
  k = 0;
  for(i = 0; i < ysize ;i++)
    {
      for(j = 0; j < xsize; j++)
	{
	  array.e[i][j] = (long) _image[k];
	  k++;
	}
    }

  number_back = FixInt(percentage/100.*totsize);

  array1 = CopyArray(array,
		     0,FixInt(((float)xsize)/2.),
		     0,FixInt(((float)ysize)/2.) );
  array2 = CopyArray(array,
		     0, FixInt(((float)xsize)/2.),
		     FixInt(((float)ysize)/2.)+1, ysize);
  array3 = CopyArray(array,
		     FixInt(((float)xsize)/2.)+1, xsize,
		     0, FixInt(((float)ysize)/2.));
  array4 = CopyArray(array,
		     FixInt(((float)xsize)/2.)+1, xsize,
		     FixInt(((float)ysize)/2.)+1, ysize);
  
  wd1 = Where(ref = ArrayGT(array1,(long) dark_current), &count1); Delete(ref);
  wd2 = Where(ref = ArrayGT(array2,(long) dark_current), &count2); Delete(ref);
  wd3 = Where(ref = ArrayGT(array3,(long) dark_current), &count3); Delete(ref);
  wd4 = Where(ref = ArrayGT(array4,(long) dark_current), &count4); Delete(ref);

  if ((count1 == 0) || (count2 == 0) ||
      (count3 == 0) || (count4 == 0))
    {
      w = Where(ref = ArrayGT(array, (long) dark_current), &count); Delete(ref);
      if (count == 0)
	{ 
	  if (show) printf("All pixels below dark current. This does not make much sense !\n");
	  k = 0;
	  for(i = 0; i < ysize; i++)
	    {
	      for(j = 0; j < xsize; j++)
		{
		  _res[k] = (float) array.e[i][j];
		  k++;
		}

	    }
	  Delete(array1);
	  Delete(array2);
	  Delete(array3);
	  Delete(array4);
	  Delete(wd1);
	  Delete(wd2);
	  Delete(wd3);
	  Delete(wd4);
	  Delete(array);
	  return;
	}

      w2 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array,w)),
		     0,min2(count-1, number_back-1),
		     0,1);
      Delete(ref); Delete(ref2);
      noise_index = CreateArray(((xsize*ysize/4)/4)*4,1);
       /* but ... we change noise_index' size virtually */
      noise_index.xsize = w2.xsize ;
      noise_index.ysize = 1;

      ix = (long*)malloc((w.xsize*w.ysize) * sizeof(long));
      k = 0;
      for(i = 0; i < w.ysize; i++)
	{
	  for(j = 0; j < w.xsize; j++)
	    {
	      ix[k] = w.e[i][j];
	      k++;
	    }
	}
      for(i = 0; i < w2.xsize; i++)
	{
	  noise_index.e[0][i] = ix[w2.e[0][i]];
	}

      bad_flag = 1;

      free(ix);
      Delete(w);
      Delete(w2);

    }
  else
    {
      w1 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array1,wd1)),
		     0, min2(count1-1,number_back/4),
		     0,1); Delete(ref); Delete(ref2);
      w2 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array2,wd2)),
		     0, min2(count2-1,number_back/4),
		     0,1); Delete(ref); Delete(ref2);
      w3 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array3,wd3)),
		     0, min2(count3-1,number_back/4),
		     0,1); Delete(ref); Delete(ref2);
      w4 = CopyArray(ref2 = IndSort(ref = CopyArrayFromArrayInd(array4,wd4)),
		     0, min2(count4-1,number_back/4),
		     0,1); Delete(ref); Delete(ref2);

      ni1 = CopyArrayFromArrayInd(wd1,w1);
      ni2 = CopyArrayFromArrayInd(wd2,w2);
      ni3 = CopyArrayFromArrayInd(wd3,w3);
      ni4 = CopyArrayFromArrayInd(wd4,w4);
   
      xy1 = Wheresub(ni1, array1);
      xy2 = Wheresub(ni2, array2);
      xy3 = Wheresub(ni3, array3);
      xy4 = Wheresub(ni4, array4);
     
      wf1 = CreateArray(1, xy1.ysize);
      for(i = 0; i < wf1.ysize; i++)
	{
	  wf1.e[i][0] = xy1.e[i][0] + xsize * xy1.e[i][1];
	}
      sf1 = wf1.ysize;
     
      wf2 = CreateArray(1, xy2.ysize);
      for(i = 0; i < wf2.ysize; i++)
	{
	  wf2.e[i][0] = xy2.e[i][0] + xsize * (xy2.e[i][1] + FixInt(ysize/2.+1));
	}
      sf2 = wf2.ysize;
    
      wf3 = CreateArray(1, xy3.ysize);
      for(i = 0; i < wf3.ysize; i++)
	{
	  wf3.e[i][0] = xy3.e[i][0] + FixInt(xsize/2.+1) + xsize * xy3.e[i][1];
	}
      sf3 = wf3.ysize;
    
      wf4 = CreateArray(1, xy4.ysize);
      for(i = 0; i < wf4.ysize; i++)
	{
	  wf4.e[i][0] = xy4.e[i][0] + FixInt(xsize/2.+1) + 
	    xsize * (xy4.e[i][1] + FixInt(ysize/2. +1));
	}
      sf4 = wf4.ysize;
     
      noise_index = CreateArray(sf1+sf2+sf3+sf4,1);
      for(i = 0; i < sf1; i++)
	{
	  noise_index.e[0][i] = wf1.e[i][0];
	}
      for(i = sf1; i < (sf1 + sf2); i++)
	{
	  noise_index.e[0][i] = wf2.e[i-sf1][0];
	}
      for(i = (sf1+sf2); i < (sf1 + sf2 + sf3); i++)
	{
	  noise_index.e[0][i] = wf3.e[i-sf1-sf2][0];
	}
      for(i = (sf1+sf2+sf3); i < (sf1 + sf2 + sf3 + sf4); i++)
	{
	  noise_index.e[0][i] = wf4.e[i-sf1-sf2-sf3][0] ;
	}

      Delete(w1);
      Delete(w2);
      Delete(w3);
      Delete(w4);

      Delete(ni1);
      Delete(ni2);
      Delete(ni3);
      Delete(ni4);

      Delete(xy1);
      Delete(xy2);
      Delete(xy3);
      Delete(xy4);

      Delete(wf1);
      Delete(wf2);
      Delete(wf3);
      Delete(wf4);

    }


  Delete(array1);
  Delete(array2);
  Delete(array3);
  Delete(array4);

  Delete(wd1);
  Delete(wd2);
  Delete(wd3);
  Delete(wd4);

 /*First selection now done. Proceed with Calculating the mean */

  noise_density = CopyArrayFromArrayInd(array,noise_index);

/*PrintArray(array);*/
/*PrintArray(noise_index);*/
/*PrintArray(noise_density);*/

  bc_mean = 0.0;

  for(i = 0; i < noise_density.ysize; i++)
    {
      for(j = 0; j < noise_density.xsize; j++)
	{
	  bc_mean += (float) noise_density.e[i][j];
	}
    }
  k = 0;
 
  for(i = 0; i < noise_index.ysize; i++)
    {
      for(j = 0; j < noise_index.xsize; j++)
	{
	  _noise_index[k] = (long) noise_index.e[i][j];
	  k++;
	}
    }


  bc_mean = bc_mean / ((float)noise_density.xsize);
  *_res = bc_mean;

  if (show)
    {
      printf("Mean background value : %f\n", bc_mean);
    }


  Delete(array); 
  Delete(noise_density);
  Delete(noise_index);

  return;
}



