#ifndef MANIP_H
#define MANIP_H

/*
   Je definis dans ce fichier un certain nombre de
   fonction de manipulation des tableaux.
   Leur utilisation (parametre, etc.) est identique
   a IDL
   */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include "LUDecomp.h"
#include "Types.h"

#define UT   -3
#define FUT  -3.0

typedef struct _tab_ind
{
  long e; /* element */
  int k;  /* its original index  */
} tab_ind;

long max(a,b)
long a,b;
{
  if (a>b)
    return a;
  else 
    return b;
}

float fmax(a,b)
float a,b;
{
  if(a>b) 
    return a;
  else
    return b;
}

long min(a,b)
long a,b;
{
  if (a<b)
    return a;
  else 
    return b;
}

long min4(a,b,c,d)
     long a,b,c,d;
{
  a = min(a,b);
  a = min(a,c);
  a = min(a,d);
  return a;
}

float fmin(a,b)
float a,b;
{
  if (a<b)
    return a;
  else 
    return b;
}

float fmin4(a,b,c,d)
float a,b,c,d;
{
  a = fmin(a,b);
  a = fmin(a,c);
  a = fmin(a,d);
  return a;
}


float sqr(x)
float x;
{
  return (x*x);
}

/* 

   Un tableau ressemble a cela:

   --xdim--        
   
   a b c d e  |    
   d f g e x  ydim 
   f g h i j  | 

   A savoir: en C, et avec la structure Array consideree, 
   tab(x,y) est designe par tab.e[y][x].

*/

/* Creation d'un array:
   ses champs xsize et ysize sont mis aux bonnes valeurs,
   allocation memoire
   */
Array CreateArray(xdim,ydim)
int xdim;
int ydim;
{
  int i = 0;
  int j = 0;
  Array res;

  res.e = (long**) malloc(ydim*sizeof(long));
  res.xsize = xdim;
  res.ysize = ydim;
  res.allocated = 1;
  for(i = 0; i < ydim; i++)
    {
      res.e[i] = (long*) malloc(xdim*sizeof(long));
      /* on initialise la matrice a UT */
      for(j = 0; j < xdim; j++)
	res.e[i][j] = (long) UT;
    }

  return res;
}

/* Fonction jumelle pour un tableau 
   de floats
   */

FArray CreateFArray(xdim,ydim)
int xdim;
int ydim;
{
  int i = 0;
  int j = 0;
  FArray res;

  res.e = (float**) malloc(ydim*sizeof(float));
  res.xsize = xdim;
  res.ysize = ydim;
  res.allocated = 1;
  for(i = 0; i < ydim; i++)
    {
      res.e[i] = (float*) malloc(xdim*sizeof(float));
      /* on initialise la matrice a FUT */
      for(j = 0; j < xdim; j++)
	res.e[i][j] = (float) FUT;
    }

  return res;
}

/* Si je veux me debarrasser un array,
   ou bien ne pas re-allouer de la memoire inutilement.
   Ex
   Array toto;
   toto = CreateArray(10,10);
   toto = CreateArray(20,10);
   alloue 2 fois la memoire pour toto, sans la liberer.
   Il faut faire
   toto = CreateArray(10,10);
   Delete(toto);
   toto = CreateArray(20,10);
   */
   
void Delete(x)
Array x;
{
  int i;

  if (x.allocated == 1)
    { 
      for(i=0; i < x.ysize; i++)
	{
	  free(x.e[i]);
	}
      free(x.e);
      x.xsize = 0;
      x.ysize = 0;
      x.allocated = 0;
    }
}

void FDelete(x)
     FArray x;
{
  int i;
  if (x.allocated == 1)
    {
      for(i=0; i < x.ysize; i++)
	{
	  free(x.e[i]);
	}
      free(x.e);
      x.xsize = 0;
      x.ysize = 0;
      x.allocated = 0;
    }
} 

/*
   Affichage d'un tableau:
   en fait utilise pour le debugging
   */

void PrintArray(x)
Array x;
{
  int i,j;
  if (x.allocated == 1)
    {
      printf("___________________\n");
      for(i = 0; i < x.ysize; i++)
	{
	  for(j = 0; j < x.xsize; j++)
	    {
	      printf("%d\t", x.e[i][j]);
	    }
	  printf("\n");
	}
    }
  else
    {
      printf("Error: attempt to print an undefined array\n");
    }
}

void PrintFArray(x)
FArray x;
{
  int i,j;
  if (x.allocated == 1)
    {
      printf("___________________\n");
      for(i = 0; i < x.ysize; i++)
	{
	  for(j = 0; j < x.xsize; j++)
	    {
	      printf("%f\t", x.e[i][j]);
	    }
	  printf("\n");
	}
    }
  else
    {
      printf("Error: attempt to print an undefined array\n");
    }
}

/* Fonction identique a WHERE de IDL */
/* Attention: allocation memoire */

Array Where(x,count)
Array x;
int *count;
{
  Array r;
  int i = 0, j = 0;
  int q = 0;
  int p = 0;
  int ct = 0;

  if (x.allocated == 0)
    {
      printf("Error executing Where() on an empty array\n");
      r = CreateArray(1,1);
      return r ;
    }
  else
    {    
      /* d'abord je compte mes affaires */
      for(i = 0; i < x.ysize; i++)
	{
	  for(j = 0; j < x.xsize; j++)
	    {
	      if (x.e[i][j] != 0)
		ct++;
	    }
	}
 
      *count = ct;
      
      r = CreateArray(ct,1);
      q = 0;
      p = 0;
      /* ensuite je m'en occupe */
      for(i = 0; i < x.ysize; i++)
	{
	  for(j = 0; j < x.xsize; j++)
	    {
	      if (x.e[i][j] != 0)
		{
		  r.e[0][q] = p;
		  q++;
		}
	      p++;
	    }
	}
      return r;
    }
}

/*
   J'en avais besoin pour faire
   array GT param
   sous IDL
   */

Array ArrayGT(x,param)
Array x;
long param;
{
  int i,j;
  Array res;

  res = CreateArray(x.xsize,x.ysize);

  if (x.allocated == 0)
    {
      printf("Error executing ArrayGT() on an empty array\n");
      return res ;
    }
  else
    {
      for(i = 0; i < x.ysize; i++)
	{
	  for(j = 0; j < x.xsize; j++)
	    {
	      if(x.e[i][j] > param)
		res.e[i][j] = 1;
	      else
		res.e[i][j] = 0;
	    }
	}
      return(res);
    }
}

/*
   pareil avec EQ. Finalement je l'ai pas utilise pour
   back2d_poly4
   */

Array ArrayEQ(x,param)
Array x;
long param;
{
  int i,j;
  Array res;

  res = CreateArray(x.xsize,x.ysize);

  if (x.allocated == 0)
    {
      printf("Error executing ArrayEQ() on an empty array\n");
      return res ;
    }
  else
    {
      for(i = 0; i < x.ysize; i++)
	{
	  for(j = 0; j < x.xsize; j++)
	    {
	      if(x.e[i][j] == param)
		res.e[i][j] = 1;
	      else
		res.e[i][j] = 0;
	    }
	}
      return(res);
    }
}

/* INDex GENeration */
/* utile pour tester des procedures */


/* cree un tableau a une dimension,
   comme IDL> toto = indgen(xdim)
   */
Array Indgen1(xdim)
int xdim;
{
  Array res;
  int i;

  res = CreateArray(xdim,1);
  
  for(i = 0; i < xdim; i++)
    {
      res.e[0][i] = i;
    }
  return res;
}
  
/* cree un tableau a deux dimension, comme
   IDL> toto = indgen(xdim,ydim)
   */
Array Indgen2(xdim,ydim)
int xdim,ydim;
{
  Array res;
  int i,j,k;
  k = 0;
  
  res = CreateArray(xdim,ydim);

  for(i = 0; i < ydim; i++)
    for(j = 0; j < xdim; j++)
      {
	res.e[i][j] = k;
	k++;
      } 
  return res;
}

/* Produit de matrice */
/* equivalent a a1 ## a2 */
Array MultiplyArray(a1,a2)
Array a1,a2;
{
  int i,j,k;
  Array res;
  int xdim1 = a1.xsize;
  int xdim2 = a2.xsize;
  int ydim1 = a1.ysize;
  int ydim2 = a2.ysize;
  int xsize = xdim2;
  int ysize = ydim1;

  if (a1.allocated * a2.allocated == 0)
    {
      printf("Error executing ArrayGT() on an empty array\n");
      res = CreateArray(xsize,ysize);
      return res ;
    }
  else
    {
      res = CreateArray(xsize,ysize);
      
      for(j = 0; j < ysize; j++)
	{
	  for(i = 0; i < xsize; i++)
	    {
	      res.e[j][i] = 0;
	      for(k = 0; k < min(xsize,ysize); k++)
		res.e[j][i] += a1.e[j][k] * a2.e[k][i];
	    }
	}
      return res;
    }
}

/* equivalent a a1 # a2 */

Array DieseArray(a1,a2)
Array a1,a2;
{
  int i,j,k;
  int xdim1 = a1.xsize;
  int xdim2 = a2.xsize;
  int ydim1 = a1.ysize;
  int ydim2 = a2.ysize;
  int xsize = xdim1;
  int ysize = xdim2;

  Array res;

  res = CreateArray(xsize,ysize);

  if (a1.allocated * a2.allocated == 0)
    {
      printf("Error executing DieseArray() on an empty array\n");
      return res ;
    }
  else
    {
      for(j = 0; j < ysize; j++)
	{
	  for(i = 0; i < xsize; i++)
	    {
	      res.e[j][i] = 0;
	      for(k = 0; k < min(a1.ysize,a2.ysize); k++)
		res.e[j][i] += a1.e[k][i] * a2.e[k][j];
	    }
	}
      return res;
    }
}

/* identique a IDL> toto = replicate(x,dim) */
Array Replicate(x,dim)
long x;
int dim;
{
  Array res;
  int i;

  res = CreateArray(dim,1);

  for(i = 0; i < dim; i++)
    {
      res.e[0][i] = x;
    }
  return res;
}


/* convertit un float en un entier, en
   le troncant */
int FixInt(f)
float f;
{
  /*
     int res = (int) floor((double)f);
     */
  return((int)f);
}

/* toto = CopyArray(orig, xbegin, xend, ybegin, yend)
   est equivalent sous IDL a
   IDL> toto = array(xbegin:xend, ybegin:yend);
*/

Array CopyArray(orig, xbegin, xend, ybegin, yend)
Array orig;
int xbegin, xend;
int ybegin, yend;
{
  Array res;
  int i,j;

  if (orig.allocated == 0)
    {
      printf("Error copying an empty array: CopyArray()\n");
      res = CreateArray(xend-xbegin, yend-ybegin);
      return (res) ;
    }
  else
    {
      res = CreateArray(xend-xbegin, yend-ybegin);
      
      for(i = 0; i < (yend-ybegin); i++)
	{
	  for(j = 0; j < (xend-xbegin); j++)
	    {
	      res.e[i][j] = orig.e[i+ybegin][j+xbegin];
	    }
	}
      return res;
    }
}

/* Quicksorting recursive procedure */ 
/* ne pas toucher a ca... c'est plein
   de structures intermediaires privees 
   */
tab_ind *_ind_sort(r,lo,up)
tab_ind *r;
int lo, up;
{
  int i,j;
  tab_ind temp;

  /*printf("(Sorting0 ... : %d,%d)\n", r[64].e, r[64].k);*/

  while(up > lo)
    {
      i = lo;
      j = up;
      temp.e = r[lo].e;
      temp.k = r[lo].k;
      /*printf("(Sorting4 ... : %d,%d)\n", temp.e, temp.k);*/
      while(i<j)
	{
	  while(r[j].e > temp.e)
	    {
	      j--;
	    }
          /*printf("(Sorting5 ... : %d)\n", j);*/

	  r[i].e = r[j].e;
	  r[i].k = r[j].k;
          /*printf("(Sorting6 ... : %d,%d,%d,%d,%d,%d)\n", r[0].e, r[0].k,i,j,r[j].e,r[j].k);*/
	  while ((i<j) && (r[i].e <= temp.e))
	    {
	      i++;
	    }
	  r[j].e = r[i].e;
	  r[j].k = r[i].k;
	}
      r[i].e = temp.e;
      r[i].k = temp.k;
      /*printf("(Sorting1 ... : %d,%d)\n", r[0].e, r[0].k);*/
      r = _ind_sort(r,lo,i-1);
      lo=i+1;
    }
  /*printf("(Sorting2 ... : %d,%d)\n", r[0].e, r[0].k);*/
  return (r);
}

/* C: toto = IndSort(array);
   IDL> toto = SORT(array)
   */
Array IndSort(x)
Array x;
{
  Array res;
  tab_ind* _res;
  int i,j,k=0;

  if (x.allocated == 0)
    {
      printf("Error: you're trying to sort an empty array !\n");
      res = CreateArray(x.xsize*x.ysize,1);
      return (res);
    }
  else
    {      
      _res = (tab_ind*) malloc((x.ysize*x.xsize)*sizeof(tab_ind));
      res = CreateArray(x.xsize*x.ysize,1);

      /*printf("(Sizes1 : %d,%d)\n", x.xsize,x.ysize); */

      for(i = 0; i < x.ysize; i++)
	{
	  for(j = 0; j < x.xsize; j++)
	    {
	      _res[k].e = x.e[i][j];
	      _res[k].k = k;
	      /*printf("(%d,%d,%d)\n", _res[k].e, _res[k].k,k);*/
	      k++;
	    }
	}

      /*printf("(Calling0 ... : %d,%d)\n", _res[64].e, _res[64].k);*/
      /*printf("(Calling1 ... : %d,%d)\n", _res[300].e, _res[300].k);*/
      
      _res = _ind_sort(_res,0,x.ysize*x.xsize-1);
      
      for(i = 0; i < x.xsize*x.ysize; i++)
	{
	  res.e[0][i] = _res[i].k;
	}
      free(_res);
      return (res);
    }
}

/* C: toto = CopyArrayFromArrayInd(x,ind);
   IDL> toto = x(ind)
   */

Array CopyArrayFromArrayInd(x,ind)
Array x,ind;
{
  int i,j,k=0;
  Array res;
  long *ix;
  
  if (x.allocated * ind.allocated == 0)
    {
      printf("Error executing CopyArrayFromArrayInd() on empty arrays\n");
      res = CreateArray(ind.xsize,1);   
      return (res) ;
    }
  else
    {
      
      ix = (long*)malloc((x.xsize*x.ysize) * sizeof(long));
      
      res = CreateArray(ind.xsize,1);
      /*printf("(Sizes3 : %d,%d)\n", res.xsize,res.ysize); */
      for(i = 0; i < x.ysize; i++)
	{
	  for(j = 0; j < x.xsize; j++)
	    {
	      ix[k] = x.e[i][j];
	      k++;
	    }
	}
      
      for(i = 0; i < ind.xsize; i++)
	{
	  res.e[0][i] = ix[ind.e[0][i]];
	}
      free(ix);
      return (res);
    }
}

/* Random generation for tests */
/* commented out to compile under HPUX 10 */
/*
Array Random(x,y)
int x,y;
{
  Array res;
  int i,j;
  
  srand((int)(time()));

  res = CreateArray(x,y);
  for(i = 0; i < y; i++)
    for(j = 0; j < x; j++)
      res.e[i][j] = (long) 1000*drand48();
  return (res);
}

FArray FRandom(x,y)
int x,y;
{
  FArray res;
  int i,j;
  
  srand((int)(time()));

  res = CreateFArray(x,y);
  for(i = 0; i < y; i++)
    for(j = 0; j < x; j++)
      res.e[i][j] = (float) 1000*drand48();
  return (res);
}
*/

/*
   C: toto = Wheresub(ind,A)
   IDL> toto = Wheresub(ind,A)
   */

Array Wheresub(ind,A)
Array ind;
Array A;
{
  /* Fonction qui renvoie les coord correspondant
     a un element de la matrice vue en deux dim.
     sous forme d'une matrice 2 x n */
  Array res;
  int i;
  if ((A.allocated * ind.allocated) != 0)
    {
      res = CreateArray(2,ind.xsize);
      for(i = 0; i < ind.xsize; i++)
	{
	  res.e[i][0] = (long)((int)ind.e[0][i]) % ((int)A.xsize);
	  res.e[i][1] = (long)((ind.e[0][i] -  res.e[i][0])/ A.xsize);
	}
      return (res);
    }
  else
    {
      printf("An error occured executing Wheresub: xsize = 0\n");
      res.e[0][0] = 0;
      res.e[0][1] = 0;
      return (res);
    }
}


/* Converti un tableau de long (Array) en
   un tableau de flottant (FArray)
   SANS FAIRE D'ALLOCATION MEMOIRE
   Cette fonction est utilise dans la
   boucle principal de back2d_poly4 
   qui doit etre avant tout rapide */

void ConvertToFloat(a,f)
FArray f;
Array a;
{
  int i,j;
  f.xsize = a.xsize;
  f.ysize = a.ysize;
  for(i = 0; i < a.ysize; i++)
    {
      for(j = 0; j < a.xsize; j++)
	{
	  f.e[i][j] = (float) a.e[i][j];
	}
    }
}

/* idem mais dans l'autre sens */

void ConvertToArray(f,a)
FArray f;
Array a;
{
  int i,j;
  a.xsize = f.xsize;
  a.ysize = f.ysize;
  for(i = 0; i < a.ysize; i++)
    {
      for(j = 0; j < a.xsize; j++)
	{
	  a.e[i][j] = (long) f.e[i][j];
	}
    }
}


#endif

