;PROW vsn1.2 --> batch file to integrate DENZO data
;+
;LATEST VERSION : 01/08/97
;batch file for integration:
; 
;
;******************************************************************;
;PARAMETERS TO BE DEFINED BY USER;
;******************************************************************;

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&& PARAMETERS FOR LOG FILE &&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;info for log file
logdir = '/users/bourgeoi/ARNON/integ/REV3/' ; <--- HERE
logfile = 'integ_test.log' ; <--- HERE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&& PARAMETERS FOR DENZO PATTERN PREDICTION &&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;The denzo .x files were created with which format ?
;If the format is YORK then set york_type to 'yes', otherwise 
;to 'no' :
york_type = 'yes' ; <--- HERE

;Input the denzodir and denzo_root:
; File name: 'denzodir+denzo_root+image_no+denzo_ext
;
denzodir= '/users/bourgeoi/ARNON/denzo/sweep2/x/' ; <--- HERE
denzo_root= 'tk3_ot_' ; <--- HERE
denzo_ext= '.x' ; <--- HERE

; Set to 1 if you want to refine the predictions locally
; to center of gravity, 0 if no local prediction change.
; (Advisable to set to 0 if the pattern is weak or streaky)
; (Takes significantly longer time)
loc_refine= 0 ; [] ; <--- HERE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&    OUTPUT IDL FILES    &&&&&&&&&&&&&&&&&&&&
;&&&&&&&&& CONTAINING INTEGRATED INTENSITIES &&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;info for output files containing integrated intensities and parameters
integdir = '/users/bourgeoi/ARNON/integ/REV3/' ; <--- HERE
integfile_root = 'junk_' ; <--- HERE
integfile_ext = '.prow' ; <--- HERE
refspots_ext = '.ref' ; <--- HERE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&& IMAGES TO BE PROCESSED &&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;info for input image files containing data
; File name:
; 'image_dir+imagefile_root+image_no+imagefile_ext'

imagedir = '/data/opid09/inhouse/inhouse_px/bourgeoi/arnon/' ; <--- HERE
imagefile_root = 'tmp4_2_' ; <--- HERE
imagefile_ext = '.image' ; <--- HERE

; input the number of the first and last images to integrate
min_image_no = 118; <--- HERE
max_image_no = 118; <--- HERE

;Do you want to skip integration of some images ?
skip_images = 0 ; [0 : No ; 1 : Yes] <--- HERE
;If yes input here the numbers of the images to skip
images_skipped = [ $
	80	$
		 ] ; <--- HERE

;detector type ['small_bar','big_mar', or 'ccd'] :
det_type = 'small_mar' ; <--- HERE

; Image size [raster] and raster [um] 
xsize=1200 ; <--- HERE
ysize=1200 ; <--- HERE
raster = 150 ; <--- HERE


;In order to suppress predicted spots falling behind the beamstop, the
;pixels in the images standing  behind the beamstop shadow should be 
;set to zero.
;Do you want to apply a beamstop mask ?
set_beamstop_mask = 1 ; [0:No ; 1:Yes] <-- HERE
;To create the beamstop mask use the PROW GUI.
;Input the full pathname of the relevant file.
beamstop_mask_file = '/users/bourgeoi/ARNON/integ/tk_beamstop.idl' ; <--- HERE

;Do you want to set an additionnal mask (bad area in the detector ...,
;problems due to shadowing of some sort ...) ?
set_mask = 0 ; [0:No ; 1:Yes] <-- HERE
;To create the beamstop mask use the PROW GUI.
mask_file= '/data/opid09/external/ls519/integ/w3_001_mask.idl' ; <--- HERE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&& PARAMETERS FOR INTEGRATION &&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

;chosen boxsize for integration [more than 4*spotsizeFWHM is advisable]
boxsize_x = 17 ;[raster] ; <--- HERE
boxsize_y = 17 ;[raster] ; <--- HERE

;do you want to define a region in box for the reference spots ?
;This option is advised.
;It is specially useful if the program has trouble to find a sufficient
;number of reference spots, for exemple if too few strong spots
;are not well isolated in the images.
set_region = 1 ; [1 : Yes, 0 : No] <--- HERE
;To create the spot region use the PROW GUI
region_file= '/users/bourgeoi/ARNON/integ/REV1/spot_region.idl' ; <--- HERE

;distance below which spots are considered as overlapped (i.e. they 
;will be deconvoluted)  [about 2*spotsizeFWHM is advisable]
ovlp_dist = 0.9 ; [mm] ; <--- HERE

;distance below which it is considered that spots can not be deconcoluted 
;[half of spot FWHM is a good choice]
ovlp_min_dist = 0.25 ; [mm] ; <--- HERE

;distance below which spots are considered as overlapped for
;reference peaks. [in general, OK to use 120% of ovlp_dist]
ovlp_dist_ref = 0.9 ; [mm] ; <--- HERE

;saturation value of the detector
satvalue = 90000 ;[detector counts] ; <--- HERE

;offset of the detector (0 for MAR IP detectors)
det_offset = 0 ;[detector counts] ; <--- HERE

;gain of the detector at 1.5418 A (CuKalpha) (1.2 for MAR IP detectors)
gain = 1.2 ;[at 1.5418 A, no unit] ; <--- HERE

;percentage of pixels in box initially considered as noise for
;background evaluation. Example : if noise_percentage = 10, then the 10%
;lower value pixels will be taken. The correct and final value will be 
;adjusted by the program.
noise_percentage = 25 ;[%] ; <--- HERE

;Are the reference spots (the ".ref" files already existing ? 
use_old_ref = 0 ; [1 : Yes, 0 : No] <--- HERE 

;maximum,minimum number of reference peaks (1000 and 100 are 
;good starting choices)
max_ref_spots = 200 ; <--- HERE
min_ref_spots = 60 ; <--- HERE

;minimum I/Sig(I) for initial selection of reference peaks.
min_sob = 3.0 ; <--- HERE

;use also partials for selection of reference spots ?
;[usually Yes, unless profiles from partials differ from
;profiles of fullies]
use_partials = 1 ;  [1 : Yes, 0 : No] <--- HERE 

;allowed oscillation distance for selection of reference peaks
;in [degree]. This allows to extend the selection of reference
;spots to neighbouring images.
max_osc_distance=0 ; [set to 0 to use only the image under study]

;radial distance to look around for getting the reference peak when 
;integrating a weak or overlapped peak by profile fitting method.
ref_distance = 50 ; [mm] ; <--- HERE

;angular distance to look around for getting the reference peak when 
;integrating a weak or overlapped peak by profile fitting method.
ref_ang_width = 30 ; [degrees] ; <--- HERE

;in case reference peaks are missing, do you want to extend the search 
;to symmetrical regions of the image (normally : No)
sym_rad = 1 ; [1 : Yes, 0 : No] ; <--- HERE

;do you want to reinterpolate reference profile in case of bad
;fit, based on the experimental peak position. This is 
;dangerous if you don't know what you are doing. Although statistics
;are generally improved, it may introduce systematic errors.
second_interp =0 ; [1 : Yes, 0 : No] ; <--- HERE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&& PARAMETERS FOR "DEBUGGING" &&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

; Set SHOW_IMAGE to 0 to avoid using graphics or 1 to get image displayed
; (with predictions etc). (Set to 1 if any of the SHOW parameters
; below is set to 1.)
show_image = 1  ; <--- HERE

;debug parameter
show_ref_peaks = 0; [0: no debug, 1: debug] ; <--- HERE
show_strong_peaks = 0; [0: no debug, 1: debug] ; <--- HERE
show_weak_peaks = 0; [0: no debug, 1: debug] ; <--- HERE
show_ovlp_peaks = 0; [0: no debug, 1: debug] ; <--- HERE
show_m = 0 ; [0: no debug, 1: debug] ; <--- HERE
miller_h = -2 ; <--- HERE
miller_k = 14 ; <--- HERE
miller_l = -35; <--- HERE

;info for user about the .flag field
;flag = 0 --> correctly integrated
;flag = 1 --> bad background (spot should be rejected)
;flag = 2 --> bad integrated intensity (spot should be rejected)
;flag = 3 --> spot predicted overlapped but treated as single
;flag = 4 --> weak spot (integrated intensity = 0, variance = 1 arbitrary)
;flag = 5 --> cholewsky method failed (usually means problem with indexing)

;info for user about the .close field
;close = 0 --> non saturated
;close = 1 --> saturated
;close = 1 --> overlapped spot too close to be deconvoluted 
;			 (integrated intensity = 0, variance = 1 arbitrary)

;******************************************************************;
;END OF USUAL INPUT BY USER.
;******************************************************************;
;for safety
CLOSE,1

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&& CREATE LOG FILE &&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

start_time = SYSTIME(1)
;close any previous journaling session
IF !JOURNAL NE 0 THEN JOURNAL

dum = FINDFILE(STRCOMPRESS(logdir+logfile,/REMOVE_ALL),count=count)
IF count NE 0 THEN BEGIN
rem=''
READ,'Log file exists. Remove it [y/n] ? ',rem
IF rem EQ 'y' THEN SPAWN,'/bin/rm -f '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL)ELSE GOTO,escape
ENDIF

JOURNAL,STRCOMPRESS(logdir+logfile,/REMOVE_ALL)

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&& DELETE ALL WINDOWS &&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

FOR i=0,!D.WINDOW+10 DO WDELETE

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&& CHOOSE IMAGES TO PROCESS &&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

image_names = FINDFILE(STRCOMPRESS(imagedir+imagefile_root+ $
	'*'+imagefile_ext,/REMOVE_ALL),count=count)
IF (count EQ 0) THEN MESSAGE, 'No images found ...'
image_numbers = FIX(STRMID(image_names,STRLEN(imagedir+imagefile_root),3))
s = WHERE(image_numbers GE min_image_no AND image_numbers LE max_image_no)
image_names = image_names(s)
image_numbers = image_numbers(s)

IF skip_images THEN BEGIN
FOR j=0,(SIZE(images_skipped))(1)-1 DO BEGIN
sk = WHERE(image_numbers NE images_skipped(j),skcount)
IF skcount GT 0 THEN BEGIN
	image_numbers = image_numbers(sk)
	image_names = image_names(sk)
ENDIF
ENDFOR
ENDIF

PRINT,'Number of images to process : ',(SIZE(image_names))(1)

;s= WHERE(integrate ne 0, count)
;IF count EQ 0 THEN MESSAGE,'No image to process !'
;image_no= image_no(s) 

images= (SIZE(image_names))(1)

frame_start=INTARR(images)
frames=INTARR(images)+1
;frame_start= frame_start(s)
;frames= frames(s)

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&& PRINT INFORMATION &&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
@batch_info_denzo

;suppress nasty messages for arithmetic errors
junk = CHECK_MATH(trap = 0)

IF show_image THEN BEGIN
	WIN,xsize/2,ysize/2
	LOADCT,0
	blue_col=[255,0,0]
	green_col=[0,255,0]
	red_col=[0,0,255]
	TVLCT,red_col,green_col,blue_col,!D.N_COLORS-3
ENDIF

;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&& PREDICT AND INTEGRATE EACH IMAGE &&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

FOR i=0,(images-1) DO BEGIN
    CATCH, error_status
    IF (error_status ne 0) THEN BEGIN
      BATCH_ERROR, image_name
      error_status=0
      GOTO, end_of_image
    ENDIF
      image_name=image_names(i)

 start_image_time = SYSTIME(1)
PRINT, 'Time from beginning of session [s] : ',start_image_time-start_time
   PRINT, 'Image name : ',image_name

;&&&&&&&&& GET PREDICTED REFLECTIONS &&&&&&&&&&&&&

	    denzo_name=STRCOMPRESS(denzodir+denzo_root+ $
		STRMID(image_name,STRLEN(imagedir+imagefile_root),3)+denzo_ext,/REMOVE_ALL)
	    dummy=FINDFILE(denzo_name, count=count)

	    IF (count eq 0) THEN MESSAGE, "Couldn't find DENZO .x file."
		CASE det_type OF 
		'small_mar': BEGIN
			CASE york_type OF
			'yes' : refl = READ_DENZOX(denzo_name, par, RASTER=raster)
			'no' : refl = READ_DENZOX(denzo_name, par, RASTER=raster, /NOYORK)
			else : MESSAGE,'York format ?'
			ENDCASE
			END
 		'big_mar': BEGIN
			CASE york_type OF
			'yes' : refl = READ_DENZOX(denzo_name, par, RASTER=raster, /BIG_MAR)
			'no' : refl = READ_DENZOX(denzo_name, par, RASTER=raster, /NOYORK, /BIG_MAR)
			else : MESSAGE,'York format ?'
			ENDCASE
			END
 		'ccd': BEGIN
			CASE york_type OF
			'yes' : refl = READ_DENZOX(denzo_name, par, RASTER=raster)
			'no' : refl = READ_DENZOX(denzo_name, par, RASTER=raster, /NOYORK)
			else : MESSAGE,'York format ?'
			ENDCASE
			END
		ENDCASE
	    ;write additional parameters    

	IF set_region EQ 1 THEN BEGIN
		    RESTORE,region_file
		IF (boxsize_x NE boxsize_reg.x) OR (boxsize_y NE boxsize_reg.y) THEN BEGIN
			PRINT,'Boxsize for spot region : ',boxsize_reg.x,boxsize_reg.y
			PRINT,'User defined boxsize : ',boxsize_x,boxsize_y
			MESSAGE,'Spot region incompatible with chosen boxsize !'
		ENDIF
	    	    par = CREATE_STRUCT(par,'region',region)
	ENDIF ELSE  par = CREATE_STRUCT(par,'region',0)
 
	WRITEPAR_LAUE2,par,beamsize=0,sample_depth=0,$
	   	dark_current=det_offset,boxsize={box, x:boxsize_x,y:boxsize_y},gain=gain,$
	  	bg_gain=gain*1.5418/par.wave,noise_percentage=noise_percentage,satvalue=satvalue,$
	   	ovlp_dist=ovlp_dist,ovlp_min_dist=ovlp_min_dist

;&&&&&&&&& OPEN IMAGE AND DISPLAY IT &&&&&&&&&&&&&
 
    ;check the image file :
    PRINT,'Checking image file.'
    SPAWN,'date', date & PRINT, date
    SPAWN,'file ' + image_name
    SPAWN,'date', date & PRINT, date
    image=READ_DENZO_MAR(file=image_name,rows=xsize,columns=ysize)

    IF (SIZE(image))(0) EQ 2 THEN BEGIN  ; file exists
 
    IF set_beamstop_mask EQ 1 THEN BEGIN
      ; Set image behind beamstop to zero so that ROILAUE3 removes 
      ; predictions in this region:
      RESTORE, beamstop_mask_file
      image(mask) = 0
    ENDIF
    IF set_mask EQ 1 THEN BEGIN
      RESTORE, mask_file
      image(mask) = 0
    ENDIF

      red=REBIN(image,xsize/2,ysize/2)
    
      ;display the image
      IF show_image THEN BEGIN
	  index_sat=WHERE(red GE satvalue, count_sat)
	  red_displayed = (!D.N_COLORS-2)*ALOG(red>1)/ALOG(satvalue)
	  ; Set the marked pixels to such a high value so that after rebinning
	  ; it is still above !D.N_COLORS-1 :
  	  IF (count_sat gt 0) THEN  red_displayed(index_sat)= 10.0^20
	  TV, red_displayed < (!D.N_COLORS-1)
      ENDIF


	read_image_time = SYSTIME(1)
	PRINT, 'Time to read image and prediction [s] : ',read_image_time-start_image_time

      ;take only the spots inside image and where the image is not empty
      refl2 = ROILAUE3(refl,image,par,0,0,xsize-1,ysize-1)

;&&&&&&&&& ADDITIONAL REFINEMENT IF WANTED &&&&&&&&&&&&&

IF loc_refine EQ 1 THEN BEGIN
      PRINT,'Searching for overlaps ...[for refinement]'
      ; Find overlaps to avoid that refinement brings two spots at the 
;same position
      FIND_QUICKOVLP,refl2,par,3*SQRT(2)*raster*0.001

      ;run the local refinement routine 1 time with changing positions
      refl_obs=LOC_REFINE1(refl2,image,par,0,weak,sigma,back,change_pred=loc_refine)
ENDIF ELSE BEGIN
      refl_obs=LOC_REFINE2(refl2,image,par)
ENDELSE

match_image_time = SYSTIME(1)
PRINT, 'Time for internal refinement [s] : ',match_image_time-read_image_time

      ;overplot predicted positions on image
      IF show_image THEN dummy = PIXLAUE2(refl_obs,red,image,par,draw=4,color=2)

;&&&&&&&&& SEARCH FOR OVERLAPS &&&&&&&&&&&&&

      ; Find overlaps when selecting reference peaks; severe criteria!
      FIND_QUICKOVLP,refl_obs,par, ovlp_dist_ref
      refl_obs.ovlp2=refl_obs.ovlp
      ;get the overlapping pattern
      FIND_OVLP2,refl_obs,par,par.ovlp_dist,par.ovlp_min_dist

ovlp_image_time = SYSTIME(1)
PRINT, 'Time for finding overlaps [s] : ',ovlp_image_time-match_image_time

;&&&&&&&&& INTEGRATION &&&&&&&&&&&&&

    PRINT,'Integrating :',image_name

      miller = [miller_h,miller_k,miller_l]

IF use_old_ref THEN BEGIN
 ;restore the reference spots :
 file_restore0 = STRCOMPRESS(integdir+integfile_root+ $
	  STRMID(image_name,STRLEN(imagedir+imagefile_root),3)+refspots_ext,/REMOVE_ALL)
 dum=FINDFILE(file_restore0,count=count)
 IF count NE 1 THEN MESSAGE,'Could not find the file with old reference spots !'
 RESTORE,file_restore0

 PRINT,'Number of reference spots : ', number_ref_spots
 PRINT,'Number of strong spots : ', number_strong_spots

ENDIF ELSE BEGIN

  new_ref_spots = FIND_REFSPOTS(image,red,refl_obs,par,$
	max_ref_spots=max_ref_spots, $
	min_ref_spots=min_ref_spots, $
	other_spots=other_spots, $
	number_ref_spots=number_ref_spots, $
	number_other_spots=number_other_spots, $
	min_sob=min_sob, $
	show_image=show_image, $
	show_ref_peaks=show_ref_peaks, $
	use_partials=use_partials)

 ;get the strong spots
  strong_spots = REPLICATE(new_ref_spots(0),number_ref_spots+number_other_spots)
  strong_spots(0:number_ref_spots-1)=new_ref_spots
  IF number_other_spots GT 0 THEN $
   strong_spots(number_ref_spots:number_ref_spots+number_other_spots-1)=other_spots
  number_strong_spots=(SIZE(strong_spots))(1)
 
 IF i EQ 0 THEN old_ref_spots=0

 ;get the reference spots
  ref_spots = MERGE_REFSPOTS(new_ref_spots,old_ref_spots,par,$
				MAX_OSC_DISTANCE=max_osc_distance,$
				MAX_REF_SPOTS=max_ref_spots,$
				SHOW=0)

  old_ref_spots = ref_spots
 

 ;save the reference and strong spots :
      file_save0 = STRCOMPRESS(integdir+integfile_root+ $
	  STRMID(image_name,STRLEN(imagedir+imagefile_root),3)+refspots_ext,/REMOVE_ALL)
      SAVE,file=file_save0,ref_spots,strong_spots,par,number_ref_spots,number_strong_spots

ENDELSE 

;integrate the data with profile fitting and overlap deconvolution

      integ = INTEGRATE_DENZO1(image,red,refl_obs,par,$
	ref_spots=ref_spots,$
	strong_spots=strong_spots,$	
	ref_distance=ref_distance, $
	ref_ang_width=ref_ang_width, $
	show_image=show_image,$
	show_strong_peaks=show_strong_peaks,$
	show_weak_peaks=show_weak_peaks, $
	show_ovlp_peaks=show_ovlp_peaks, $
	show_m=show_m, miller=miller, $
	use_partials=use_partials, $
	sym_rad=sym_rad, $
	second_interp=second_interp)

integ_image_time = SYSTIME(1)
PRINT, 'Time for integration [s] : ',integ_image_time-ovlp_image_time

      ;remove saturated spots and spots too close to integrate !
      integ = integ(WHERE(integ.close EQ 0))

;add weak spots if necessary
	IF (SIZE(weak))(0) GE 1 THEN integ = MERGE_INTEG(integ,weak)

	;get some statistics
PRINT,''
PRINT,'&&&&&& SOME STATISTICS &&&&&'
     w=WHERE(integ.flag eq 2,ct)
PRINT,STRCOMPRESS('Number of spots with bad integrated intensities : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')
     w=WHERE(integ.flag eq 1,ct)
PRINT,STRCOMPRESS('Number of spots with bad background : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')
     w=WHERE(integ.flag eq 5,ct)
PRINT,STRCOMPRESS('Number of spots with bad deconvolution : '+STRING(ct)+' ie: '+STRING(100.*ct/(SIZE(integ))(1))+ ' %')


        file_save1 = STRCOMPRESS(integdir+integfile_root+ $
	  STRMID(image_name,STRLEN(imagedir+imagefile_root),3)+integfile_ext,/REMOVE_ALL)

      SAVE,file=file_save1,integ,par

      PRINT,''
    ENDIF ELSE BATCH_ERROR, image_name
    end_of_image:


end_image_time = SYSTIME(1)
PRINT, 'Total time for this image [s] : ',end_image_time-start_image_time

ENDFOR ; Image loop

JOURNAL

;remove garbage in the logfile
SPAWN,'/bin/cp ' + STRCOMPRESS(logdir+logfile,/REMOVE_ALL) + ' temp'

SPAWN,'awk '' $2 !~ /ie/ && $3 !~ /ie/ && $1 !~ /;p/ && $1 !~ /;\+/ && $1 !~ /;o/ && $1 !~ /;\*/ && $1 !~ /;b/ && $1 !~ /;i/ && $1 !~ /;s/ {print}'' temp'+' > '+STRCOMPRESS(logdir+logfile,/REMOVE_ALL)

escape :
;***********************************
END
;***********************************
;-





