;+
; NAME:
;	IDLGEASC_BATCH
;
; PURPOSE:
;
;	Batch file exemple for writing back .geasc and .ge files with IDL.
;	Modify this file for your own purpose.
;	To do that type :
;	"cp /users/o/ursby/idl/pub/integ/batch/idlgeasc_batch.pro ./mybatch.pro"
;	This brings the file into your directory.
;	Then edit and modify the file with emacs, vi ...
;	Start idl and type ".run mybatch"
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	.run IDLGEASC_BATCH
;
; RESTRICTIONS :
;	The ccp4.setup routine to access ccp4 library MUST be called
;	with the alias "ccp4"
;
; MODIFICATION HISTORY : LAST VERSION IS : JUNE 8th, 1995
;
; HERE FOLLOWS THE EXEMPLE :
;
;
;
;;batch file to convert into .ge files the idl integrated files :
;;CUTIN22_4_1.INTEG --> CUTIN22_4_18.INTEG
;
;;******************************************************************;
;;PARAMETERS TO BE DEFINED BY USER;
;;******************************************************************;
;
;;info for log file
;logdirectory = '/users/o/bourgeoi/laue/cut_may/' ; <--- HERE
;logfile = 'cut22_4_ge2.log' ; <--- HERE
;
;;info for input files containing integrated intensities
;integdirectory = '/users/o/bourgeoi/laue/cut_may/' ; <--- HERE
;integfile_root = 'cut22_4_' ; <--- HERE
;integfile_ext = '.integ' ; <--- HERE
;integnumber_start = 1 ; <--- HERE
;integnumber_end = 18 ; <--- HERE
;
;;info for input files containing original geasc files
;geascdir = '/users/o/bourgeoi/laue/cut_may/' ; <--- HERE
;geascfile_root = 'cut22_4_' ; <--- HERE
;geascnumber_start = 1 ; <--- HERE
;geascnumber_end = 18 ; <--- HERE
;
;;info for output .ge1 and ge2 files
;gedirectory = '/users/o/bourgeoi/laue/cut_may/' ; <--- HERE
;gefile_root = 'cut22_4_idl2_' ; <--- HERE
;
;;do you want to save output .geasc files
;savegeasc = 0 ; [0 : No ; 1 : Yes] <--- HERE
;
;;do you want to remove multiples
;removemultiples = 1 ; [0 : No ; 1 : Yes] <--- HERE
;
;;do you want to remove overlapped spots
;removeovlp = 1 ; [0 : No ; 1 : Yes] <--- HERE
;
;;do you want to save spots only in a limited region
;savelimited = 1 ; [0 : No ; 1 : Yes] <--- HERE
;;if yes enter minimum and maximum distance from beam center [mm]
;rmin = 15
;rmax = 10000.
;
;;do you want to remove outliers
;removeoutliers = 1 ; [0 : No ; 1 : Yes] <--- HERE
;
;;do you want to scale down values
;scaledown = 32765. ; [0 : No ; Value : Yes, type the value] <--- HERE
;
;;******************************************************************;
;;END
;;******************************************************************;
;
;dum = FINDFILE(STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL),count=count)
;IF count NE 0 THEN BEGIN
;rem=''
;READ,'Log file exists. Remove it [y/n] ? ',rem
;IF rem EQ 'y' THEN SPAWN,'rm -f '+STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL)ELSE GOTO,escape
;ENDIF
;JOURNAL,STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL)
;
;;print sumup of all parameters :
;PRINT,'**************************************************'
;PRINT,' '
;PRINT,'Name of log file : ',STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL)
;PRINT,'Root name of output .ge files : ',STRCOMPRESS(gedirectory+gefile_root,/REMOVE_ALL)
;PRINT,'Root name of input files containing integrated intensities : ',STRCOMPRESS(integdirectory+integfile_root,/REMOVE_ALL)
;PRINT,'Root name for initial input .geasc files : ',STRCOMPRESS(geascdir+geascfile_root,/REMOVE_ALL)
;PRINT,'First image to be integrated : ',integnumber_start
;PRINT,'Last image to be integrated : ',integnumber_end
;PRINT,' '
;
;IF savegeasc EQ 1 THEN $
;PRINT,'Also saving output geasc files ...' ELSE $
;PRINT,'Not saving output geasc files ...'
;
;IF removeoutliers EQ 1 THEN $
;PRINT,'Removing outliers  ...' ELSE $
;PRINT,'Not removing outliers ...'
;
;IF removemultiples EQ 1 THEN $
;PRINT,'Removing multiples ...' ELSE $
;PRINT,'Keeping multiples ...'
;
;IF removeovlp EQ 1 THEN $
;PRINT,'Removing overlapped spots ...' ELSE $
;PRINT,'Keeping overlapped spots ...'
;
;IF savelimited EQ 1 THEN $
;PRINT,'Keeping spots between ',rmin,' and ',rmax,' [mm] from beam center' ELSE $
;PRINT,'Keeping spots in the entire image ...'
;
;IF scaledown GT 0 THEN $
;PRINT,'Scaling down to :',scaledown ELSE $
;PRINT,'Not scaling down ...'
;
;PRINT,'**************************************************'
;
;
;;for safety
;CLOSE,1
;
;
;;1/ Get the maximum value, and scale down to 32765
;max=0.
;
;IF scaledown GT 0 THEN BEGIN
;FOR i=integnumber_start,integnumber_end DO BEGIN
;
;integ_name=STRCOMPRESS(integdirectory+integfile_root+STRING(i)+integfile_ext,/REMOVE_ALL)
;PRINT,'Opening :',integ_name
;RESTORE,integ_name
;
;IF removemultiples EQ 1 THEN  integ=integ(WHERE(integ.mul EQ 1))
;IF removeovlp EQ 1 THEN  integ=integ(WHERE(integ.ovlp EQ 0))
;IF savelimited EQ 1 THEN integ = integ(WHERE((SQRT((integ.x)^2+(integ.y)^2) GE rmin) AND (SQRT((integ.x)^2+(integ.y)^2) LE rmax)))
;IF removeoutliers EQ 1 THEN integ=integ(WHERE((integ.flag eq 0) OR (integ.flag EQ 4)))
;
;max = max>MAX(integ.intp(0))
;
;ENDFOR
;PRINT,'Maximum integrated intensity :',max
;
;ENDIF
;
;
;;2/ Write geasc files
; 
;FOR i=integnumber_start,integnumber_end DO BEGIN
;geascnumber = geascnumber_start + i - integnumber_start
;
;integ_name=STRCOMPRESS(integdirectory+integfile_root+STRING(i)+integfile_ext,/REMOVE_ALL)
;geasc_name=STRCOMPRESS(geascdir+geascfile_root+STRING(geascnumber),/REMOVE_ALL)
;
;PRINT,'Opening :',integ_name
;RESTORE,integ_name
;
;;number of initial reflections
;num_refl = (SIZE(integ))(1)
;
;IF removemultiples EQ 1 THEN  integ=integ(WHERE(integ.mul EQ 1))
;IF removeovlp EQ 1 THEN  integ=integ(WHERE(integ.ovlp EQ 0))
;IF savelimited EQ 1 THEN integ = integ(WHERE((SQRT((integ.x)^2+(integ.y)^2) GE rmin) AND (SQRT((integ.x)^2+(integ.y)^2) LE rmax)))
;IF removeoutliers EQ 1 THEN integ=integ(WHERE((integ.flag eq 0) OR (integ.flag EQ 4)))
;
;;scale down to max=scaledown if necessary !
;IF scaledown GT 0 THEN BEGIN
;integ.intp(0) = integ.intp(0)*(scaledown/FLOAT(max))
;integ.isigp(0) = integ.isigp(0)*(scaledown/FLOAT(max))
;ENDIF
;
;
;;number of kept reflections
;num_kept_refl = (SIZE(integ))(1)
;PRINT,'Number of kept reflexions :',num_kept_refl,' ie : ',num_kept_refl/FLOAT(num_refl)*100,' %'
;
;ge_name=STRCOMPRESS(gedirectory+gefile_root+STRING(geascnumber),/REMOVE_ALL)
;WRITE_GEASC,ge_name,integ
;PRINT,'Done !'
;
;;get the geasc file with good header
;SPAWN,'source /users/o/bourgeoi/ccp4/scripts/merge_geasc.scr ' + geasc_name + ' ' + ge_name
;
;;get the .ge files
;SPAWN,'source /users/o/bourgeoi/ccp4/scripts/get_ge.scr ' + ge_name
;
;;Remove the .geasc file if necessary
;IF savegeasc EQ 0 THEN BEGIN
;SPAWN, 'rm -f ' + STRCOMPRESS(ge_name+'.geasc',/REMOVE_ALL) 
;PRINT,'Removing ',STRCOMPRESS(ge_name+'.geasc',/REMOVE_ALL),' ...'
;ENDIF
; 
;ENDFOR
;
;JOURNAL
;escape : 
;END
;
;
;
;-





