;batch file to convert into DENZO .x files the idl integrated files :

;******************************************************************;
;PARAMETERS TO BE DEFINED BY USER;
;******************************************************************;

;info for log file
logdirectory = '/users/bourgeoi/ISOMERO/MONO/070697/NEW/' ; <--- HERE
logfile = 'denzox.log' ; <--- HERE

;info for input files containing integrated intensities
integdir = '/data/opid09/inhouse/inhouse_px/bourgeoi/ir/070697/PROW/' ; <--- HERE
integfile_root = 'ir_3n_' ; <--- HERE
integfile_ext = '.integ' ; <--- HERE
integnumber_start = 1 ; <--- HERE
integnumber_end = 155 ; <--- HERE
;Do you want to skip some files ?
skip_integs = 0 ; [0 : No ; 1 : Yes] <--- HERE
;If yes input here the numbers of the integ files to skip
integs_skipped = [ $
	1,	4,	76	$
		 ] ; <--- HERE

;info for input file containing original x file
orxdir = '/users/bourgeoi/ISOMERO/MONO/070697/DENZO/' ; <--- HERE
orxfile = 'ir_3n_' ; <--- HERE
orxfile_ext = '.x' ; <--- HERE
;format for original x files ('york', 'noyork')
orx_format = 'york' ; <--- HERE
 
;info for output .x files
xdirectory = '/data/opid09/inhouse/inhouse_px/bourgeoi/ir/070697/XPROW/' ; <--- HERE
xfile_root = 'ir_3n_idl_' ; <--- HERE
xfile_ext = '.x' ; <--- HERE

;do you want to combine scaled box integrated intensities with
;profile fitted intensities
combine = 1 ; [0 : No ; 1 : Yes] <--- HERE

;do you want to remove overlapped spots
removeovlp = 0 ; [0 : No ; 1 : Yes] <--- HERE

;do you want to set all negative intensities to 0 ?
set_zero = 0 ; [0 : No ; 1 : Yes] <--- HERE

;do you want to remove reflexions with intensities below a threshold ?
set_neg_thres = -5000 ; [0 : No ; Negative Number : Yes, give the value] <--- HERE

;do you want to save spots only in a limited region
savelimited = 0 ; [0 : No ; 1 : Yes] <--- HERE
;if yes enter minimum and maximum distance from beam center [mm]
rmin = 10.5
rmax = 10000.

;do you want to remove spots with integrated intensities
;deviating a lot from average in their resolution bin ?
remove_largerms = 0 ; [0 : No ; 1 : Yes] <--- HERE

;do you want to remove outliers
removeoutliers = 1 ; [0 : No ; 1 : Yes] <--- HERE

;if yes, do you want to keep low resolution data, even if
;they are outliers ?
keeplowres = 1.8 ; [100 : No ; if yes, input the low resolution limit] <--- HERE

;do you want to scale down values
scaledown = 0 ; [0 : No ; Value : Yes, type the value] <--- HERE

;******************************************************************;
;END
;******************************************************************;
;close any previous journaling session
IF !JOURNAL NE 0 THEN JOURNAL

dum = FINDFILE(STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL),count=count)
IF count NE 0 THEN BEGIN
rem=''
READ,'Log file exists. Remove it [y/n] ? ',rem
IF rem EQ 'y' THEN SPAWN,'/bin/rm -f '+STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL)ELSE GOTO,escape
ENDIF
JOURNAL,STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL)

;******************************************************************;
;FILES TO PROCESS
;******************************************************************;

integ_names = FINDFILE(STRCOMPRESS(integdir+integfile_root+ $
	'*'+integfile_ext,/REMOVE_ALL),count=count)
integ_numbers = FIX(STRMID(integ_names,STRLEN(integdir+integfile_root),3))
s = WHERE(integ_numbers GE integnumber_start AND integ_numbers LE integnumber_end)
integ_names = integ_names(s)
integ_numbers = integ_numbers(s)

IF skip_integs THEN BEGIN
FOR j=0,(SIZE(integs_skipped))(1)-1 DO BEGIN
sk = WHERE(integ_numbers NE integs_skipped(j),skcount)
IF skcount GT 0 THEN BEGIN
	integ_numbers = integ_numbers(sk)
	integ_names = integ_names(sk)
ENDIF
ENDFOR
ENDIF

n_integs = (SIZE(integ_names))(1)
PRINT,'Number of integ files to process : ',(SIZE(integ_names))(1)
;******************************************************************;

;print sumup of all parameters :
PRINT,'**************************************************'
PRINT,' '
PRINT,'Name of log file : ',STRCOMPRESS(logdirectory+logfile,/REMOVE_ALL)
PRINT,'Root name of output .x files : ',STRCOMPRESS(xdirectory+xfile_root,/REMOVE_ALL)
PRINT,'Format of input DENZO files : ',orx_format
PRINT,'Root name of input files containing integrated intensities : ',STRCOMPRESS(integdir+integfile_root,/REMOVE_ALL)
PRINT,'Name of initial input .x file : ',STRCOMPRESS(orxdir+orxfile,/REMOVE_ALL)
PRINT,'First image to be integrated : ',integnumber_start
PRINT,'Last image to be integrated : ',integnumber_end
PRINT,' '

IF removeoutliers EQ 1 THEN $
PRINT,'Removing outliers  ...' ELSE $
PRINT,'Not removing outliers ...'

IF remove_largerms EQ 1 THEN $
PRINT,'Removing potential ice spots (spots with too large deviation from average)  ...' ELSE $
PRINT,'Not removing ice spots ...'

IF keeplowres NE 100 THEN $
PRINT,'Keeping low resolution data even if outliers up to [A] : ',keeplowres

IF combine EQ 1 THEN $
PRINT,'Combining box and profile fitted intensities ...' ELSE $
PRINT,'Using only profile fitted intensities ...'

IF removeovlp EQ 1 THEN $
PRINT,'Removing overlapped spots ...' ELSE $
PRINT,'Keeping overlapped spots ...'

IF savelimited EQ 1 THEN $
PRINT,'Keeping spots between ',rmin,' and ',rmax,' [mm] from beam center' ELSE $
PRINT,'Keeping spots in the entire image ...'

IF set_zero EQ 1 THEN $
PRINT,'All negative intensities will be set to 0 !'

IF set_neg_thres LT 0 THEN $
PRINT,'Remove all reflections with integrated intensities lower than : ',set_neg_thres

IF scaledown GT 0 THEN $
PRINT,'Scaling down to :',scaledown ELSE $
PRINT,'Not scaling down ...'

PRINT,'**************************************************'


;for safety
CLOSE,1


;1/ Get the maximum value, and scale down to 32765
max=0.

IF scaledown GT 0 THEN BEGIN
FOR i=0,n_integs-1 DO BEGIN

integ_name=integ_names(i)
PRINT,'Opening :',integ_name
RESTORE,integ_name

IF combine EQ 1 THEN BEGIN
 w=WHERE(integ.intb(0) EQ 0)
 ;if gfit is good then rather keep PF, else rather keep BOX 
 integ(w).intp(0) = integ(w).intp(0)*integ(w).gfit+integ(w).intp(2)*(1-integ(w).gfit)
ENDIF

IF removeovlp EQ 1 THEN  integ=integ(WHERE(integ.ovlp EQ 0))
IF savelimited EQ 1 THEN integ = integ(WHERE((SQRT((integ.x)^2+(integ.y)^2) GE rmin) AND (SQRT((integ.x)^2+(integ.y)^2) LE rmax)))
IF removeoutliers EQ 1 THEN integ=integ(WHERE(((integ.flag eq 0) OR (integ.flag eq 3) OR (integ.flag EQ 4) OR (integ.res GE keeplowres)) AND (integ.flag NE 1)))

IF remove_largerms EQ 1 THEN BEGIN
;we use the field .ipoint as a flag
;any problem with that flag ?
IF MAX(integ.ipoint) NE 0 THEN MESSAGE,'Problem with field .ipoint to reject ice spots ...'
max_deviation = 10
sbins = 10.
sbinsize = (1/(2*MIN(integ.res)))^2/sbins
  FOR ind=0,sbins-1 DO BEGIN
    w = WHERE(((1/(2*integ.res)^2) gt ind*sbinsize) and $
	((1/(2*integ.res)^2) le (ind+1)*sbinsize), count)

print,0.5/SQRT(ind*sbinsize)
print,0.5/SQRT((ind+1)*sbinsize)
print,'Number of selected ref : ',count
    IF (count ge 10) THEN BEGIN
     ord=REVERSE(SORT(integ(w).intp(0)))
     first20=ord(0:FIX(((SIZE(ord))(1)-1)*0.2)>1)
     intfirst=(integ(w))(first20)
     ii_rms = STDEV(intfirst.intp(0),ii_mean)
     w2 = WHERE((integ(w).intp(0)-ii_mean) GT max_deviation*ii_rms,ct)
print,'RMS,mean :',ii_rms,ii_mean
     IF ct GT 0 THEN integ(w(w2)).ipoint = 1 
    ENDIF
  ENDFOR
;Plot it ?
w = WHERE(integ.ipoint EQ 0)
w2 = WHERE(integ.ipoint EQ 1,ct)
;PLOT,integ(w).res,integ(w).intp(0),PSYM=3,XTITLE='Resolution [A]', YTITLE='Integrated intensity',CHARSIZE=1.5
;IF ct GT 1 THEN OPLOT,integ(w2).res,integ(w2).intp(0),PSYM=3
;IF ct EQ 1 THEN XYOUTS,integ(w2).res,integ(w2).intp(0),'*',/DATA
ENDIF


max = max>MAX(integ.intp(0))

ENDFOR
PRINT,'Maximum integrated intensity :',max

ENDIF


;2/ Write x files
 
FOR i=0,n_integs-1 DO BEGIN
;xnumber = xnumber_start + i - integnumber_start

integ_name = integ_names(i)
orx_name=STRCOMPRESS(orxdir+orxfile+ $
		STRMID(integ_name,STRLEN(integdir+integfile_root),3)+orxfile_ext,/REMOVE_ALL)
dummy=FINDFILE(orx_name, count=count)
IF (count eq 0) THEN MESSAGE, "Couldn't find original DENZO .x file."
x_name=STRCOMPRESS(xdirectory+xfile_root+ $
		STRMID(integ_name,STRLEN(integdir+integfile_root),3)+xfile_ext,/REMOVE_ALL)

;orx_name=STRCOMPRESS(orxdir+orxfile+STRING(xnumber),/REMOVE_ALL)
;x_name=STRCOMPRESS(xdirectory+xfile_root+STRING(xnumber),/REMOVE_ALL)

PRINT,'Opening :',integ_name
RESTORE,integ_name

;number of initial reflections
num_refl = (SIZE(integ))(1)

IF combine EQ 1 THEN BEGIN
 w=WHERE(integ.intb(0) EQ 0)
 ;if gfit is good then rather keep PF, else rather keep BOX 
 integ(w).intp(0) = integ(w).intp(0)*integ(w).gfit+integ(w).intp(2)*(1-integ(w).gfit)
 wg=WHERE(integ(w).gfit NE 1,cwg)
 PLOT,integ(w).intp(0),integ(w).intp(2),psym=3,XTITLE='Profile fitted',YTITLE='Scaled box'
PRINT,'Number of spots with modified PF intensities [combine] : ', cwg
ENDIF

IF removeovlp EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
 integ=integ(WHERE(integ.ovlp EQ 0))
PRINT,'Number of rejected spots [overlaped] : ', s1-(SIZE(integ))(1)
ENDIF

IF savelimited EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
integ = integ(WHERE((SQRT((integ.x)^2+(integ.y)^2) GE rmin) AND (SQRT((integ.x)^2+(integ.y)^2) LE rmax)))
PRINT,'Number of rejected spots [outside region] : ', s1-(SIZE(integ))(1)
ENDIF

IF removeoutliers EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
integ=integ(WHERE(((integ.flag eq 0) OR (integ.flag eq 3) OR (integ.flag EQ 4) OR (integ.res GE keeplowres)) AND (integ.flag NE 1)))
PRINT,'Number of rejected spots [outliers] : ', s1-(SIZE(integ))(1)
ENDIF

IF set_neg_thres LT 0 THEN BEGIN
 s1=(SIZE(integ))(1)
 w_pos_thres = WHERE(integ.intp(0) GE set_neg_thres,ct_pos_thres)
IF ct_pos_thres GT 0 THEN integ=integ(w_pos_thres)
PRINT,'Number of rejected spots [intensity below negative threshold] : ', s1-(SIZE(integ))(1)
ENDIF

IF remove_largerms EQ 1 THEN BEGIN
 s1=(SIZE(integ))(1)
;we use the field .ipoint as a flag
;any problem with that flag ?
IF MAX(integ.ipoint) NE 0 THEN MESSAGE,'Problem with field .ipoint to reject ice spots ...'
max_deviation = 10
sbins = 10.
sbinsize = (1/(2*MIN(integ.res)))^2/sbins
  FOR ind=0,sbins-1 DO BEGIN
    w = WHERE(((1/(2*integ.res)^2) gt ind*sbinsize) and $
	((1/(2*integ.res)^2) le (ind+1)*sbinsize), count)

;print,0.5/SQRT(ind*sbinsize)
;print,0.5/SQRT((ind+1)*sbinsize)
;print,'Number of selected ref : ',count
    IF (count ge 10) THEN BEGIN
     ord=REVERSE(SORT(integ(w).intp(0)))
     first20=ord(0:FIX(((SIZE(ord))(1)-1)*0.2)>1)
     intfirst=(integ(w))(first20)
     ii_rms = STDEV(intfirst.intp(0),ii_mean)
     w2 = WHERE((integ(w).intp(0)-ii_mean) GT max_deviation*ii_rms,ct)
;print,'RMS,mean :',ii_rms,ii_mean
     IF ct GT 0 THEN integ(w(w2)).ipoint = 1 
ok=''
;PLOT,integ(w).res,integ(w).intp(0),PSYM=3,XTITLE='Resolution [A]', YTITLE='Integrated intensity'
;IF ct GT 1 THEN OPLOT,integ(w(w2)).res,integ(w(w2)).intp(0),PSYM=2
;IF ct EQ 1 THEN XYOUTS,integ(w(w2)).res,integ(w(w2)).intp(0),'*',/DATA
;read,'Ok ? ',ok
    ENDIF
  ENDFOR
;Plot it ?
w2 = WHERE(integ.ipoint EQ 1,ct)
PLOT,integ.res,integ.intp(0),PSYM=3,XTITLE='Resolution [A]', YTITLE='Integrated intensity'
IF ct GT 1 THEN OPLOT,integ(w2).res,integ(w2).intp(0),PSYM=2
IF ct EQ 1 THEN XYOUTS,integ(w2).res,integ(w2).intp(0),'*',/DATA
integ = integ(WHERE(integ.ipoint EQ 0))
PRINT,'Number of rejected spots [large deviation (ice spots ?)] : ', s1-(SIZE(integ))(1)
ENDIF

;scale down to max=scaledown if necessary !
IF scaledown GT 0 THEN BEGIN
integ.intp(0) = integ.intp(0)*(scaledown/FLOAT(max))
integ.isigp(0) = integ.isigp(0)*(scaledown/FLOAT(max))
ENDIF

wz = WHERE(integ.intp(0) LE 0,nz)
PRINT,'Number of negative intensity spots : ',nz
IF set_zero EQ 1 THEN BEGIN
	IF nz GT 0 THEN integ(wz).intp(0) = 1
ENDIF
;the standard deviation should never be zero (scaling effect !)
integ.isigp(0) = integ.isigp(0) > 1

;number of kept reflections
num_kept_refl = (SIZE(integ))(1)
PRINT,'Number of kept reflexions :',num_kept_refl,' ie : ',num_kept_refl/FLOAT(num_refl)*100,' %'

IF orx_format EQ 'noyork' THEN WRITE_DENZOX,x_name,orx_name,integ,/NOYORK $
ELSE WRITE_DENZOX,x_name,orx_name,integ

ENDFOR

JOURNAL
escape : 
END






