function WHEREREG,xmin,xmax,ymin,ymax,array
;+
; NAME:
;	WHEREREG
;
; PURPOSE:
;	Convert a 2d region of an array into the ensemble of indices 
;	position in array
;
; CATEGORY:
;	Signal, image processing.
;
; CALLING SEQUENCE:
;	Result = WHEREREG(xmin,xmax,ymin,ymax,array)
;
; INPUTS:
;	xmin : the minimum x value in array
;	xmax : the maximum x value in array
;	ymin : the minimum y value in array
;	ymax : the maximum y value in array
;	array:	The array where to get the subscript
;
; OUTPUTS:
;	Result= the 1d subscript position
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, November  1994.
;-

on_error,2                              ;Return to caller if an error occurs
;check the number of pixels
numb_pix_x = xmax-xmin+1
numb_pix_y = ymax-ymin+1
sub = LONARR(numb_pix_x*numb_pix_y)

;xsize of array
xsize=(SIZE(array))(1)

FOR i=0,numb_pix_x-1 DO BEGIN
 FOR j=0,numb_pix_y-1 DO BEGIN
   
sub(i*numb_pix_y+j) = xmin+i+ xsize*(j+ymin)
ENDFOR
ENDFOR
RETURN,sub

END
