pro LAUE_DRAW_SEC,image,reb_fac,par,angular_min,angular_max,r_min,r_max
;+
; NAME:
;	LAUE_DRAW_SEC
;
; PURPOSE:
;
;	Draws the sectors of integration, for profile fitting. This is 
;	cosmetics !
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	LAUE_DRAW_SEC,image,reb_fac,par,angular_min,angular_max,r_min,r_max
;
; INPUTS:
;	image : the original image
;	reb_fac : rebinning factor for displaying the image
;	par : the parameter from the reflist.pro routine
;	r_min : the lower radius value [mm]
;	r_max : the higher radius value [mm]
;	angular_min : the lower angular value [degree]
;	angular_max : the higher angular value [degree]
;
; OUTPUTS:
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Quite straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1994.
;-

!ERR = 0
;position of the center of the image [raster]
centerX = par.cenx-1
centerY = par.ceny-1

;y scale
scaleY = par.yscale

;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

;original pixel size [micrometers]
pix_size = par.raster
pix_sizeX = 0.001*pix_size
;pix_sizeY = 0.001*pix_size/scaleY


;coordinates values for the circle of radius r_min:
;change to rasters
radius =  (r_min/pix_sizeX)/FLOAT(reb_fac)
;change to radian
rad_max = angular_max*!Pi/180.
rad_min = angular_min*!Pi/180.
theta_range = ABS(rad_max - rad_min)
IF theta_range EQ 0 THEN theta_range = 2*!Pi

theta = rad_min + findgen(FIX(radius*theta_range)>1) * (theta_range / FLOAT(FIX(radius*theta_range)>1))  
x1 = radius*COS(theta) + centerX/FLOAT(reb_fac)
y1 = radius*SIN(theta) + centerY/FLOAT(reb_fac)

DEVICE, SET_GRAPHICS=6  
XYOUTS,x1,y1,'.',/DEVICE

;coordinates values for the circle of radius r_max:
;change to rasters
radius =  (r_max/pix_sizeX)/FLOAT(reb_fac)
;change to radian
theta = rad_min + findgen(FIX(radius*theta_range)) * (theta_range / FLOAT(FIX(radius*theta_range)))  
x2 = radius*COS(theta) + centerX/FLOAT(reb_fac)
y2 = radius*SIN(theta) + centerY/FLOAT(reb_fac)

PLOTS,[x1(0),x2(0)],[y1(0),y2(0)], COLOR=!D.N_COLORS,/DEVICE
PLOTS,[x1((SIZE(x1))(1)-1),x2((SIZE(x2))(1)-1)],[y1((SIZE(y1))(1)-1),y2((SIZE(y2))(1)-1)], COLOR=!D.N_COLORS,/DEVICE
XYOUTS,x2,y2,'.',/DEVICE
DEVICE, SET_GRAPHICS=3



END








