function GET_PIXVAR,pix_value,n_back,back,gain,bg_gain,dark_current,show=show
;+
; NAME:
;	GET_PIXVAR
;
; PURPOSE:
;
;	Returns the expected variance (sigma^2) of a background subtracted pixel
;	according to Poisson statistics.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	variance = GET_PIXVAR(pix_value,n_back,back,gain,bg_gain,dark_current,/show)
;
; INPUTS:
;	pix_value : the background subtracted pixel value [count]
;	nback : the number of pixels used to calculate the background
;	back : the constant level background value [count]
;	gain : the gain of the detector at the peak energy
;	bg_gain : the mean gain of the detector for background
;	dark_current : the dark_current (offset) of the detector
;	show : set this keyword to show information
;
; OUTPUTS:
;	variance : the variance of the integrated intensity [count].
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	The formula is adapted from A.G.W Leslie.
;	Molecular Data Processing, Chapter 4
;
; MODIFICATION HISTORY:
;	D.Bourgeois, January 1995.
;-

variance = gain*pix_value + bg_gain*(1 + 1/FLOAT(n_back))*(back-dark_current)

IF KEYWORD_SET(show) THEN BEGIN
PRINT,'Variance (sigma^2) [counts] :',variance
ENDIF

RETURN,variance
END








