function GET_OVLPV2,ref_prof,prof,peak_area,n_back,back,gain,mean_gain,dark_current,show=show
;+
; NAME:
;	GET_OVLPV2
;
; PURPOSE:
;
;	For profile fitting, returns the variance (sigma^2) of the b_vect part
;	of an  integrated peak according to Poisson statistics
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	variance = GET_OVLPV2(ref_prof,prof,peak_area,n_back,back,gain,mean_gain,dark_current,/show)
;
; INPUTS:
;	ref_prof : the reference profile for the spot to integrate
;	prof : the (background subtracted) peak to integrate
;	peak_area : the area where the peak can be integrated (usually truncated) 
;	n_back : the number of pixels used to calculate the background
;	back : the constant level background value.
;	gain : the gain of the detector at the peak energy
;	mean_gain : the mean gain of the detector for background
;	dark_current : the dark_current (offset) of the detector
;	show : set this keyword to show information
;
; OUTPUTS:
;	variance : the variance of the integrated intensity.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	The formula is adapted from A.G.W Leslie.
;	Molecular Data Processing, Chapter 4
;
; MODIFICATION HISTORY:
;	D.Bourgeois, January 1995.
;-

w = peak_area(WHERE(peak_area NE 0))

variance = gain*TOTAL(ref_prof(w)^2*(prof(w) - back)) + mean_gain*(back-dark_current)*TOTAL(ref_prof(w)^2) + mean_gain*(1/FLOAT(n_back))*(back-dark_current)*TOTAL(ref_prof(w))^2

IF KEYWORD_SET(show) THEN BEGIN
PRINT,'Variance (sigma^2) [counts] :',variance
ENDIF

RETURN,variance
END








