function GET_OVLPCOV, struc1,struc2,lambda1,lambda2,par,j
;+
; NAME:
;	GET_OVLPCOV
;
; PURPOSE:
;	Returns the covariance between two overlapped peaks defined by
;	struc1 and struc2. The structures
;	must contain the fields "indices" and "adapted_profile" and "area" 
;	and "bc_coeff".
;	The sorting is done according to "indices".
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	covar = GET_OVLPCOV(struc1,struc2,lambda1,lambda2,par,j) ;
;
; INPUTS:
;	struc1,2 : the structures to process. These are structures, not array
;		of structures.
;	lambda1 : wavelength for the first peak [A]
;	lambda2 : wavelength for the second peak [A]
;	par : parameters of the experiment
;
; OUTPUTS:
;	covar : The covariance
;	j : [optionnal] returns the number of common pixels between peaks 1 
;	    and 2
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	The covariance is expressed as : 
;	covar = gain*(SUM_OVER_COMMON_PIXEL_INDICES[adapted_profile1*
;	adapted_profile2*background_subtracted_pixel_value]) + 
;	background_gain*(SUM_OVER_COMMON_PIXEL_INDICES[adapted_profile1*
;	adapted_profile2*background_pixel_value] + 
;	(SUM_OVER_FIRST_SPOT_INDICES[adapted_profile1]*
;	SUM_OVER_SECOND_SPOT_INDICES[adapted_profile2])*
;	SQRT(mean_background1/nb1*mean_background2/nb2))
;	And nb1, nb2 are the number of pixels used to determine the
;	background levels for spots 1 and 2.
;
;
; MODIFICATION HISTORY:
;	D.Bourgeois, Mars 97.
;-

;on_error,2                              ;Return to caller if an error occurs

num_pixel1=struc1.count
num_pixel2=struc2.count

final = {adap_pro1 : FLTARR(num_pixel1),adap_pro2 : FLTARR(num_pixel2), area : FLTARR(num_pixel1 > num_pixel2), background : FLTARR(num_pixel1 > num_pixel2) }
j = 0

;Check the intersection between struc1.indices and struc2.indices

FOR i=0,num_pixel2-1 DO BEGIN
 index = WHERE(*struc1.indices EQ (*struc2.indices)(i), count)

 IF count NE 0 THEN BEGIN
    final.adap_pro1(j) = struc1.adapted_profile((*struc1.peak_area)(index))
    final.area(j) = 0.5*(struc1.area((*struc1.peak_area)(index))+struc2.area((*struc2.peak_area)(i)))
    final.background(j) = 0.5*(struc1.background((*struc1.peak_area)(index))+struc2.background((*struc2.peak_area)(i))) - par.dark_current
    final.adap_pro2(j) = struc2.adapted_profile((*struc2.peak_area)(i))
   j = j + 1
 ENDIF
ENDFOR

;PRINT,'Number of common pixels : ',j
;PRINT,'Percentage : ', 100*j/FLOAT(num_pixel)
;plot,final.adap_pro1(0:j-1)
;oplot,final.adap_pro2(0:j-1),linestyle=2
;OK=''
;PRINT,'OK ? [Y/N]'
;READ,OK

gain =  par.gain*1.5418/((lambda1+lambda2)/2.)
bg_gain = par.bg_gain

IF j GE 1 THEN covar = gain*TOTAL(final.adap_pro1(0:j-1)*final.adap_pro2(0:j-1)*final.area(0:j-1)) + bg_gain*(TOTAL(final.adap_pro1(0:j-1)*final.adap_pro2(0:j-1)*final.background(0:j-1)) + TOTAL(struc1.adapted_profile(*struc1.peak_area))*TOTAL(struc2.adapted_profile(*struc2.peak_area))*SQRT((struc1.bc_coeff(2)-par.dark_current)*(struc2.bc_coeff(2)-par.dark_current)/(struc1.bc_coeff(1)*struc2.bc_coeff(1)))) $
ELSE covar = bg_gain*TOTAL(struc2.adapted_profile(*struc2.peak_area))*SQRT((struc1.bc_coeff(2)-par.dark_current)*(struc2.bc_coeff(2)-par.dark_current)/(struc1.bc_coeff(1)*struc2.bc_coeff(1)))

RETURN,covar

END



