function GET_DEADPIX,profile,cut,boxsize,dead_pix,p2,show=show
;+
; NAME:
;	GET_DEADPIX
;
; PURPOSE:
;	This routine finds out dead pixels in profile.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	boolean = GET_DEADPIX(profile,cut,boxsize,dead_pix,/show)
;
; INPUTS:
;	profile : the background subtracted peak to integrate.
;	cut : the fit_level cutoff [%] as returned by GET_BOXLEVEL.PRO
;	boxsize : the size of profile (normaly par.boxsize)
;	show : set this keyword if a message is to be displayed.
;
; OUTPUTS:
;	boolean : 0 if no dead pixel, 1 if any.
;	dead_pix : [optional] Contains the coordinates in profile of the first
;		found dead pixel, if any. If none, set to 0.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	All the pixels with an intensity > (cut>2.5) intensity are set to 1, 
;	all
;	the others to zero. Then the program looks for "0" pixels which are 
;	surrounded by more than 7 "1" pixels. These pixels are called dead
;	pixels.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1995.
;-




dead_pix = 0
p2 = profile
p2(*) = 0

w = WHERE(profile GE MAX(profile)*(cut>2.5)/100.)
c = WHERESUB(w,profile)
p2(w) = 1

minX = MIN(FLOAT(c))
maxX = MAX(FLOAT(c))

minY = MIN(IMAGINARY(c))
maxY = MAX(IMAGINARY(c))

;look for all these
reg = p2(minX : maxX, minY : maxY)
w2 = WHERE(reg EQ 0,count)

IF count NE 0 THEN BEGIN ; study each case

FOR i=0,count-1 DO BEGIN
xy =WHERESUB(w2(i),reg)
x = xy(0)
y = xy(1)

IF (x NE 0) AND (x NE (maxX-minX)) AND (y NE 0) AND (y NE (maxY-minY)) THEN BEGIN
surround = reg(0>(x-1):(x+1)<(maxX-minX),0>(y-1):(y+1)<(maxY-minY))
;if less than 3 pixels of surround are 0, then it is a dead pixel
dummy = WHERE(surround EQ 0, n_zero)
IF n_zero LE 2 THEN BEGIN
IF KEYWORD_SET(show) THEN PRINT,'Dead pixel found!'
;find the coordinates of the dead pixel in profile
dead_pix = [x + minX, y + minY]
RETURN,1
ENDIF

ENDIF
ENDFOR
ENDIF

;if this point reached, there was no dead pixel
RETURN,0
END









