FUNCTION GET_CENTERED_PROFILE,profile,SHOW=SHOW,X=X,Y=Y
;+
; NAME:
;	GET_CENTERED_PROFILE
;
; PURPOSE:
;	Interpolates a profile in order to center its position.
;
; CATEGORY:
;	Data processing.
;
; CALLING SEQUENCE:
;	profile2=GET_CENTERED_PROFILE(profile,SHOW=SHOW,X=X,Y=Y)	
;
; INPUTS:
;	profile : a 2D array
;	X 	: [optional] the X position of the profile
;	Y 	: [optional] the Y position of the profile
;
; OUTPUTS:
;	profile2 : the shifted profile
;	show : keyword set to look at what happens
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Based on cubic interpolation.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June 97.
;-

sx=(SIZE(profile))(1) & sy=(SIZE(profile))(2)

;search the center of gravity from the pixels above 10% of the maximum
IF NOT N_ELEMENTS(x) OR NOT N_ELEMENTS(y) THEN BEGIN
 cen_reg = profile(sx/2-1:sx/2+1,sy/2-1:sy/2+1)
 w_max_cen = WHERESUB(WHERE(cen_reg EQ MAX(cen_reg)),cen_reg)
 w_max_cen = w_max_cen(0)
 w_max = [sx/2-1+FLOAT(w_max_cen),sy/2-1+IMAGINARY(w_max_cen)]
 w_cog = SEARCH2D(profile,w_max(0),w_max(1),MAX(cen_reg)/10.,MAX(cen_reg))
 p1=profile
 p1(*)=0
 p1(w_cog)=profile(w_cog)
 row=TOTAL(p1,2)>0.1
 column=TOTAL(p1,1)>0.1
 ;compute center of gravity
 indx=INDGEN(sx)
 indy=INDGEN(sy)

 ;the center of gravity is given by : 
  ; note the + 0.5 due to "integrated pixels"
  ; ie if we find cgx is 1 for exemple, it means that the peak
 ; center is in the middle of pixel 1, ie 1.5 
 cgx=TOTAL(indx*row)/TOTAL(row) + 0.5   
 cgy=TOTAL(indy*column)/TOTAL(column) + 0.5
 IF KEYWORD_SET(show) THEN PRINT,'Center of gravity before : ',cgx,cgy

 ;the center of gravity is shifted from the center of the box by 
 ;cog = n*raster + rest

 nx = FIX(cgx) - sx/2
 rx = cgx MOD 1

 ny = FIX(cgy) - sy/2
 ry = cgy MOD 1

 ;do the integer number of raster shift
 profile2 = SHIFT(profile,-1*nx,-1*ny)
ENDIF ELSE BEGIN
 profile2=profile
 rx=x
 ry=y
 IF KEYWORD_SET(show) THEN BEGIN
  ;search the center of gravity from the pixels above 10% of the maximum
  cen_reg = profile(sx/2-1:sx/2+1,sy/2-1:sy/2+1)
  w_max_cen = WHERESUB(WHERE(cen_reg EQ MAX(cen_reg)),cen_reg)
  w_max_cen = w_max_cen(0)
  w_max = [sx/2-1+FLOAT(w_max_cen),sy/2-1+IMAGINARY(w_max_cen)]
  w_cog = SEARCH2D(profile,w_max(0),w_max(1),MAX(cen_reg)/10.,MAX(cen_reg))
  p1=profile2
  p1(*)=0
  p1(w_cog)=profile2(w_cog)
  row=TOTAL(p1,2)>0.1
  column=TOTAL(p1,1)>0.1
  ;compute center of gravity
  indx=INDGEN(sx)
  indy=INDGEN(sy)

  ;the center of gravity is given by : 
  ; note the + 0.5 due to "integrated pixels"
  ; ie if we find cgx is 1 for exemple, it means that the peak
  ; center is in the middle of pixel 1, ie 1.5
  cgx=TOTAL(indx*row)/TOTAL(row) + 0.5  
  cgy=TOTAL(indy*column)/TOTAL(column) + 0.5
  PRINT,'Center of gravity before : ',cgx,cgy
  ENDIF
ENDELSE

;now do the rest of the shift
profile2=GET_INTERP_PROFILE(profile2,rx,ry,/REVERSE)


IF KEYWORD_SET(show) THEN BEGIN
 ;search the center of gravity from the pixels above 10% of the maximum
 cen_reg = profile2(sx/2-1:sx/2+1,sy/2-1:sy/2+1)
 w_max_cen = WHERESUB(WHERE(cen_reg EQ MAX(cen_reg)),cen_reg)
 w_max_cen = w_max_cen(0)
 w_max = [sx/2-1+FLOAT(w_max_cen),sy/2-1+IMAGINARY(w_max_cen)]
 w_cog = SEARCH2D(profile2,w_max(0),w_max(1),MAX(cen_reg)/10.,MAX(cen_reg))
 p1=profile2
 p1(*)=0
 p1(w_cog)=profile2(w_cog)
 row=TOTAL(p1,2)>0.1
 column=TOTAL(p1,1)>0.1
 ;compute center of gravity
 indx=INDGEN(sx)
 indy=INDGEN(sy)

 ;the center of gravity is given by : 
 ; note the + 0.5 due to "integrated pixels"
 ; ie if we find cgx is 1 for exemple, it means that the peak
 ; center is in the middle of pixel 1, ie 1.5
 cgx=TOTAL(indx*row)/TOTAL(row) + 0.5  
 cgy=TOTAL(indy*column)/TOTAL(column) + 0.5
 PRINT,'Center of gravity after : ',cgx,cgy

 SURFACE,profile
 PRINT,'Old profile'
 ok=''
 READ,'OK ? ',ok
 SURFACE,profile2
 PRINT,'New profile'
 ok=''
 READ,'OK ? ',ok
ENDIF


RETURN,profile2
END


