function GET_BOXREG,profile,cutoff,boxsize,fine_search=fine_search
;+
; NAME:
;	GET_BOXREG
;
; PURPOSE:
;	For Box integration : get the region around the peak where to add
;	pixels. Cutoff is the contour level at which the ratio SigI/I is
;	minimized. But to be safe, a contour level twice as big is preferable.
;	
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	region = GET_BOXREG(profile,cutoff,boxsize,[/fine_search])
;
; INPUTS:
;	profile : the background subtracted peak to integrate.
;	cutoff : the fit_level cutoff [%] as returned by GET_BOXLEVEL.PRO
;	boxsize : the size of profile (normaly par.boxsize)
;	fine_search : set this keyword if the search2d IDL procedure is to be used.
;
; OUTPUTS:
;	region : an array of indices containing the optimum region where to
;		perform box integration.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	See Clive Wilkinson and Hanna W. Khamis, J. Appl. Cryst (1988), 21
;	, p471-478. These guys take an optimum ellipsoid around the peak.
;	Here a more precise contour is taken.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1995.
;-



;this is the peak center
center = (WHERESUB(WHERE(profile EQ MAX(profile)),profile))(0)

;the goal is to inflate (usually by a factor of 2) the contour region in 
;profile at level MAX(p)*cutoff/100. 
;We do it via the use of the rebin procedure

inflate = 2
p2 = REBIN(profile,boxsize.x*inflate,boxsize.y*inflate)
IF NOT KEYWORD_SET(fine_search) THEN $
 c2 = WHERESUB(WHERE(p2 GE MAX(p2)*cutoff/100.),p2) $
ELSE $
 c2 =WHERESUB(SEARCH2D(p2,FLOAT(center)*inflate,IMAGINARY(center)*inflate,MAX(p2)*cutoff/100.,MAX(p2)),p2)

;c2 is now shifted by center to give the coordinates in profile, but
;these coordinates must satisfy 0 < (x or y) < boxsize-1

allowed = WHERE(FLOAT(c2-center) GE 0 AND FLOAT(c2-center) LE (boxsize.x-1) AND IMAGINARY(c2-center) GE 0 AND IMAGINARY(c2-center) LE (boxsize.y-1),count)

IF count GE 1 THEN BEGIN
c1 = c2(allowed) - center 

RETURN,FIX(FLOAT(c1) + boxsize.x*IMAGINARY(c1))
ENDIF ELSE MESSAGE,'Bad box integration ...'
END








