;+
;  
; 
;===============================  Xop   ========================================
; 
; XOP is a widget based interface which drives different programs that
; calculates the synchrotron radiation source spectra
; (bending magnet, wigglers and undulators) and the reflection and
; transmission characteristics of optical elements as:
; mirror, filters, flat crystals, bent perfect crystals, and multilayers.
; XOP also contains programs for multi-purpose data analysis and
; visualization. 
;
; XOP runs under most Unix machines and Windows (95/98 and NT).
;
; The point-and-click interface is used as a driver for a variety
; of codes from different authors written in different computer languages.
; The XOP interface and many of its applications are written in IDL.
; IDL is a programming language from  Research Systems:
;     Email: info@rsinc.com  WWW: http://www.rsinc.com/
;     Phone: (1) (303) 786-9900 Fax: (1) (303) 786-9909
; The XOP interface largely simplifies the use of the codes and may be used
; without prior knowledge of how to run a particular program.
; 
; XOP includes a flexible DAta BAse for X-ray applications (DABAX), which is a 
; compilations of tables for x-ray applications with a collection of codes
; to access, visualize and process these tables. 
;
; DESCRIPTION OF THE MAIN WINDOW CONTROLS:
; ========================================
; 
; The main XOP window contains several entries in the menu-bar that are 
; starting points for the differents applications included in the interface.
; The menus are fully customizable, thus the final aspect may vary from
; one XOP installation to another. (See the file README_HOWTO in the
; main XOP directory.)
;
; The recommended menus (found in most installations) are:
;        FILE: (with the  EXIT entry to quit the program).
;        SOURCE: include programs for spectral calculation of synchrotron 
; 		radiation sources (undulator, wiggler and bending magnets).
;        OPTICS: include programs that simulate x-ray interaction with 
;		materials and optical elements. Three groups are available:
; 	   TABLES: group of programs for x-ray cross sections, optical 
; 		constants, attenuation coefficients of materials. It includes
;               entries to all DABAX applications.
; 	   MIRRORS & FILTERS: Programs to calculate mirror reflectivities and 
;		filter transmissions and to apply them to a source. 
; 	   CRYSTALS: group of programs for crystal optics.
; 	   MULTILAYERS: group of programs for multilayer properties.
; 	   OBSOLETE: include programs already obsoleted by other xop 
;		applications but they are kept for occasional use and
;		comparison with the new applications.
;        TOOLS: different tools available on-line.
;        HELP: Access to XOP documentation.  
; 
; GENERAL INFORMATION:
; ====================
;
; The application driven by Xop are very numerous and in few cases redundant. 
; The xop autors recommend and maintain only few of them. Nevertheless we may
; keep in the interface of all the codes that have been used with xop (see 
; the OBSOLETED menu).
;
; XOP and DABAX are fully extensible, and it is possible to create and
; integrate new applications. 
;
; XOP is written in IDL and is supported for Unix and PC platforms.
; XOP can be run in two modes:
;  Embedded mode: the default. The user has no access to the source code
;                 and the IDL license is integrated (embedded) in XOP. XOP
;		  is thus presented as a standalone application not requiring 
;                 any additional package or library.
;  Developer mode: for users that have a valid IDL license. The IDL code
;                 is compiled "on the fly". Users have access to the IDL
;                 code. 
;
; For more information read the README files in the main XOP directory
; and consult the XOP man page under Unix.
;
; COPYRIGHT:
; ==========
;	Please refer to the README_COPYRIGHT file in the manin XOP directory. 
;
; CREDITS:
; ========
;	Published calculations made with XOP should refer at least one of the 
;	following publications:
;
;	  M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	  SPIE proceedings vol. 3448, 1998.
;
;	  M. Sanchez del Rio and R. J. Dejus "XOP: A Multiplatform Graphical 
;	  User Interface for Synchrotron Radiation Spectral and Optics 
;	  Calculations" SPIE proceedings vol. 3152, pags. 148-157, 1997.
;
;	  R.J. Dejus and M. Sanchez del Rio "XOP: A Graphical User Interface 
;	  for Spectral Calculations and X-Ray Optics Utilities" 
;	  Rev.  Sci. Instrum. 67(9) 1996 (Proceedings of the Conference on 
;	  Synchrotron Radiation Instrumentation '95).
;
; LAST MODIFICATION: current version is XOP 2.0
;
;-
;
; -----------------------------------------------------------------------
;        Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF, Nov 1993
;        Modification history:
;                94/03/02 MSR Adds Xmlayer
;                94/03/03 MSR Adds Periodic Table call.
;                94/10/14 MSR changes the interface look. Recrates the
; 			main window by using wided. More logical
; 			rearrangement of the programs. Changes Periodic T.
;                95/03/31 MSR includes xfilter and releases xop 1.2
;                95/10/24 MSR updates to idl4.0  and releases xop 1.3beta:
; 			Main updates:
; 				-File saving of input data in many appl.
; 				-xop_defaults customized by user 
; 					file ~/.xop_defaults
; 				-Now we never use the idl widget editor (wided)
;                96/01/20 MSR prepares  xop 1.3
;                96/04/23 MSR adds xxcom and absorp. New version is 1.3.1
;                96/04/30 MSR adds xhenke, xatten and xtrans applications 
; 			which interface henke,atten and trans written by R.J.
; 			Dejus. They use Henke tables (xhenke) and the 
; 			EPDL (Evaluated Photon Data Library) from LLNL.
; 			New version is 1.3.2. Updates Xop/Help/Xop.
;                96/05/17 MSR adds theh function xop_users that wites
; 			the user host and time for each user that starts
; 			and quits XOP. The file with the users list 
; 			is $XOP_HOME/xop_users.lis (must have write
; 			permission for world).
;                96/05/17 MSR adds optics/tables/dabax. New version 1.3.3.
;                96/05/17 MSR adds xpenpol. New version 1.3.4.
;                96/10/23 MSR version 1.4. It runs under solaris. Scripts
; 			to call xop from the unix shell (not longer need
; 			of changing .cshrc)
;                96/12/19 MSR add sup-options to DABAX call
;                97/01/03 MSR add xcrystal_bent and removes xreflex and xpenpol
; 			version is now 1.5
;                97/01/08 MSR adds main page image.
;                97/01/13 MSR adds xhelp common block.
;                97/02/05 MSR adds Widget font selection. Version 1.7
;			(back from Windows version)
;                97/03/13 MSR introduces a customizable file  :
;			$XOP_HOME/data/xop_menu.dat to define the menus.
;			Version 1.8. Works under IDL 5.
;                97/09/27 MSR introduces XOP_WD (working directory)
;			environment variable. Eliminates case statement in 
;			xop_event. Adds xop_* routines. Uses SDEP.
;                97/10/01 MSR calls xfont() with the /modal keyword,
;			after receiving a debugged xfont.pro from rsi.
;                97/10/02 extracts xop_wd to an independent file and
;			add the /DEFAULT keyword.
;                97/11/07 srio@esrf.fr updated the doc. Menu data files
;			moved from $XOP_HOME/data to $XOP_HOME/ifc.
;		 98/11/04 srio@esrf.fr Use catch. Remove XHELP common
;			block (now in XOP_INI.PRO). Message window when 
;			Execute() fails. Updates doc. Changes for WWW.
;		 98/12/07 srio@esrf.fr Remove calls to xop_defaults.
;			Using now wnvironment variables. 
;		 98/12/10 srio@esrf.fr removes call to xop_wd (done in xop_ini)
;		 99/01/05 srio@esrf.fr changes colot part to use tek_color table
;		 01/10/09 srio@esrf.fr addes no_block keyword and set
;			default to 1 (required for running the INES extension).
;		  02/02/25 srio@esrf.fr changes gif by png image.
;                     Cleaning of the color table definition.
;		      xop_menu.dat renamed to xop.men
;		      Remove the XOP_IFC variable. Use XOP_PROJECT variable
;			to define the .men and .png files. 
;		 02/03/01 srio@esrf.fr XOP_VERSION environment variable
;			obsoleted. Use XOP_BARTITLE env variable for defining 
;			the bar title of the main window instead.
;
;
;=====================================================================
;
FUNCTION Xop_Version,Group=group
; version=Xop_GetEnv('XOP_VERSION')
; IF version EQ '' THEN version='2.1'
; RETURN,version
RETURN,'2.11'
END ; Xop_Version
;
;=====================================================================
;
PRO xop_exit,group=group
;
; quits xop
;

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'XOP_EXIT: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   Return
endif
; file = (xop_defaults('xop')).logusersFile
; if strcompress(file,/rem) NE '' then xop_users,file,/out
widget_control,group,/destroy
end ; xop_exit
;
;=====================================================================
;
PRO XOP_Event, Event
COMMON COLORS, R_ORIG, G_ORIG, B_ORIG, R_CURR, G_CURR, B_CURR

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(Dialog_Parent=event.top, $
   /Error,'XOP_EVENT: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   Return
endif
widget_control,event.id,get_uvalue = uval, get_value = val

if tag_names(event,/Structure_Name) eq 'WIDGET_TRACKING' then begin
  if event.enter eq 1 then begin ; entry
      widget_control,event.top,get_uvalue = state
      tvlct,state.red,state.green,state.blue
  endif else tvlct,R_ORIG,G_ORIG,B_ORIG
  return
endif

command = uval+',group='+strcompress(event.top,/rem)+'L'
message,/info,' executing command: '+command
tmp = execute(command)
IF tmp NE 1 THEN itmp = Dialog_Message(Dialog_Parent=event.top,$
  /Error,['XOP_EVENT: error executing: ',command])
  

END ; xop_event
;
;=====================================================================
;
PRO xop, GROUP=Group, No_Block=no_block
COMMON COLORS, R_ORIG, G_ORIG, B_ORIG, R_CURR, G_CURR, B_CURR
;
;
;
catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(Dialog_Parent=group,$
     /Error,'XOP: error caught: '+!error_state.msg)
   If Type(stateid) EQ 3 THEN $
     IF Widget_Info(wWindow,/Valid_Id) EQ 1 THEN $
     Widget_Control,wWindow,/Destroy
   catch, /cancel
   on_error,2
   Return
endif

IF N_Elements(no_block) EQ 0 THEN no_block=1 ; use no_block by default
;
; change to working directory
;
; xop_wd,group=group,/default
;
; get xop defaults structure from xop_defaults
;
; xop_str = xop_defaults('xop')
IF N_ELEMENTS(Group) EQ 0 THEN GROUP=0


sep = sdep(/ds)

;
; get the image (this is the same code as in xop_load_image.
; (to be changed in a future version)
;
IF N_Elements(r_orig) LE 0 THEN BEGIN 
  loadct,0
  tek_color
ENDIF


imagefile =  Xop_getenv('XOP_HOME')+sep+'ifc'+sep+Xop_getenv('XOP_PROJECT')+'.png'
IF CheckFile(imagefile) NE 1 THEN BEGIN
  tmp = Dialog_Message(/Error,'XOP: Image file not found: '+imagefile)
  image = dist(300)
ENDIF ELSE BEGIN
  image = read_png(imagefile,rr,gg,bb) 
  tvlct,rr,gg,bb
ENDELSE
xpix = n_elements(image[*,0])
ypix = n_elements(image[0,*])    

;
; widget definition
;
w = lonarr(100)
IF Xop_GetEnv('XOP_BARTITLE') NE '' THEN $
 wtitle=Xop_GetEnv('XOP_BARTITLE') ELSE $
 wtitle='XOP '+Xop_Version()
wWindow = Widget_base(title=wtitle,MBAR=wMenuBar) ; base window
wBase = Widget_base(wWindow,/Column)	; base widget
w(0) = wMenuBar

;
; build the menu bar
;
  file = Xop_getenv('XOP_HOME')+sep+'ifc'+sep+Xop_getenv('XOP_PROJECT')+'.men'
  text = read_textfile(file)
  wtmp=0L
  ; auxiliar variales (just in case they are needed)
  a0=0 & a1=0 & a2=0 & a3=0 & a4=0 & a5=0 & a6=0  & a7=0  & a8=0  & a9=0
  for i=0,n_elements(text)-1 do begin
     itmp=execute(text(i))
     if itmp NE 1 then itmp = Dialog_Message(Dialog_Parent=group,$
     /Error,['Error executing:',text(i),'in file: ',file])
  endfor

  D1 = widget_draw(wBase,xs=xpix,ys=ypix,/TRACKING_EVENTS,RETAIN=2)

  WIDGET_CONTROL, wWindow, /REALIZE
  
  widget_control,/hourglass
  ; logfile = (xop_defaults('xop')).LogUsersFile 
  ; if strcompress(LogFile,/rem) NE '' then xop_users,LogFile,/in

  ; check if $XOP_HOME is defined
  ;spawn,'echo $XOP_HOME',tmp
  tmp = Xop_getenv('XOP_HOME')
  if tmp(0) EQ '' then begin
    itmp = Dialog_Message( Dialog_Parent=group,  [$
	'XOP needs that the environment variable $XOP_HOME should be ',$
	'define. This is for findig several binaries of the called ',$
	'applications.',' ', $
	'$XOP_HOME environment variable IS NOT defined in your installation.',$
	' ', $
	'E-mail to srio@esrf.fr or dejus@aps.anl.gov if you have problems.'])
  endif

  tv,image
  ;xyouts,.02,.02,/norm,Charsize=0.6, $
  ;  'XOP '+version+' (c) M. Sanchez del Rio, R. J. Dejus'

  state = { red:r_orig, green:g_orig, blue:b_orig}
  widget_control,wWindow,set_uvalue=state

  ;if strmid(!version.release,0,1) EQ '4' then begin
  ;  XMANAGER, 'xop', wWindow 
  ;endif else begin
    ;if xop_str.announce EQ 1 then xop_announce,group=wWindow
    IF Xop_GetEnv('XOP_ANNOUNCE') NE '' THEN Xop_Announce,Group=wWindow
    XMANAGER, 'xop', wWindow ,NO_BLOCK=no_block
  ;endelse
END ; xop
