FUNCTION xplot2d_prof2image,pfile,Plot=fPlot, Dummy_Pixels=dummyu_pixels, $
	size=nsize, center=ncenter, Dist=dist, pixelSize=pixelSize1, scale=scale,  $
	e0 = e0, e1 = e1

;
; defaults
;
IF N_Elements(dist) EQ 0 THEN dist = 11.0 ; cm
IF N_Elements(pixelSize1) EQ 0 THEN pixelSize = 78.94e-4 ELSE $
	pixelSize=pixelSize1*1e-4
IF N_Elements(pfile) EQ 0 THEN pfile='calcite_champ.UXD'
IF N_Elements(dummy_pixels) EQ 0 THEN dummy_pixels = 2
IF N_Elements(fPlot) EQ 0 THEN fPlot = 1
IF N_Elements(scale) EQ 0 THEN scale = 1.
IF N_Elements(e0) EQ 0 THEN e0 = 8047.8
IF N_Elements(e1) EQ 0 THEN e1 = 10000.0

help,e0,e1,scale,dist

IF N_Elements(nsize) EQ 0 THEN BEGIN ; image dimensions
  nx = 2048L
  ny = 2048L
ENDIF ELSE BEGIN
  nx = Long(nsize[0])
  ny = Long(nsize[1])
ENDELSE

IF N_Elements(ncenter) EQ 0 THEN BEGIN ; image center
  cx = 0.
  cy = 0.
ENDIF ELSE BEGIN
  cx = Float(ncenter[0])
  cy = Float(ncenter[1])
ENDELSE


;
; read profile
;
a=rascii(pfile,npoints=np)

; redefine first two points for a flat interpolation
x=a[0,*]
a[1,0]=min(a[1,*])
a[1,1]=a[1,0]

; 
; change energy from Cu Ka to new one
;
a[0,*]=a[0,*]/2.0
a[0,*]=sin(a[0,*]*!pi/180.0)
a[0,*]=a[0,*]*e0/e1
a[0,*]=asin(a[0,*])
a[0,*]=2.0*180.0/!pi*a[0,*]


xplot,make_set(reform(x),reform(a[0,*]),reform(a[1,*])),/no, coltitles=$
	['pixel','twoTheta','intensity']


twoThetaDet = atan(nx*pixelsize/2/dist)
print,'twoThetaDet [deg] : ',twoThetaDet*180/!pi

im=fltarr(nx,ny)
imR=fltarr(nx,ny)
imA=fltarr(nx,ny)


FOR j=0,ny-1 DO BEGIN
  FOR i=0,nx-1 DO BEGIN
    d = sqrt((i-cx)^2+(j-cy)^2) > dummy_pixels ; to avoid infinites 
    imR[i,j]=d*pixelsize ; in cm
    imA[i,j]=atan(d*pixelsize/dist)*180./!pi ; in deg
  ENDFOR
ENDFOR
xlong = reform(imA,nx*ny)
ylong = interpol(a[1,*],a[0,*],xlong)
im = reform(ylong,nx,ny)/(2*!pi*imR)

IF fPlot EQ 1 THEN BEGIN
  window,/free,xsize=nx*scale,ysize=ny*scale
  im2 = congrid(im,nx*scale,ny*scale)
  tvscl,im2
  profiles,im2
ENDIF
RETURN,im
END
