function font_names,name,RETURN_LIST=RETURN_LIST


;+
; NAME:
;	FONT_NAMES
; PURPOSE:
;	Returns a complete font name giving a short name. 
; CATEGORY:
;	Utilities.
; CALLING SEQUENCE:
;	long_name = FONT_NAMES(short_name)
; INPUTS:
;    short_name: The font short name. Valid names are:
;	timessmall, timesmedium, timeslarge, 
;	helveticasmall, helveticamedium, helveticalarge, 
;	newcenturysmall, newcenturymedium,  newcenturylarge, 
;	lucidasmall, lucidamedium, lucidalarge, 
;	couriersmall, couriermedium, courierlarge
;	These names are case insensitive and blank spaces can be
;	inserted (i.e. 'Times Small' is equivalent to 'timessmall')
; KEYWORDS:
;	RETURN_LIST: when set, returns a string array with all the valid 
;	short names.
; OUTPUTS:
;	A string whith the corresponding long font name.
; PROCEDURE:
;	Straightforward.
; EXAMPLE:
;	print,font_names('Times Large')
;	You get: 
;	-adobe-times-medium-r-normal--20-140-100-100-p-96-iso8859-1
; MODIFICATION HISTORY:
;	Created 05-FEB-1997 by M. Sanchez del Rio (srio@esrf.fr)
;	97/02/09 srio@esrf.fr adapts for Windows95
;	97/10/27 srio@esrf.fr sdep() used.
;-
on_error,2

if keyword_set(RETURN_LIST) then begin
  if sdep() EQ 'UNIX' then $
   list = ['Times Small','Times Medium','Times Large', $
	'Helvetica Small','Helvetica Medium','Helvetica Large', $
	'New Century Small','New Century Medium','New Century Large', $
	'Lucida Small','Lucida Medium','Lucida Large', $
	'Courier Small','Courier Medium','Courier Large'] else $
   list = ['Times Small','Times Medium','Times Large', $
	'Century Small','Century Medium','Century Large', $
	'Verdana Small','Verdana Medium','Verdana Large', $
	'Courier Small','Courier Medium','Courier Large']
  return,list
endif 


name1 = strcompress(strlowcase(name),/rem)
if !d.name EQ 'X' then begin
  case name1 of
    'timessmall': font=$
      '-adobe-times-medium-r-normal--11-80-100-100-p-54-iso8859-1'
    'timesmedium': font=$
      '-adobe-times-medium-r-normal--14-100-100-100-p-74-iso8859-1'
    'timeslarge': font=$
      '-adobe-times-medium-r-normal--20-140-100-100-p-96-iso8859-1'
    'helveticasmall': font=$
      '-adobe-helvetica-medium-r-normal--11-80-100-100-p-56-iso8859-1'
    'helveticamedium': font=$
      '-adobe-helvetica-medium-r-normal--14-100-100-100-p-76-iso8859-1'
    'helveticalarge': font=$
      '-adobe-helvetica-medium-r-normal--20-140-100-100-p-100-iso8859-1'
    'newcenturysmall': font=$
      '-adobe-new century schoolbook-medium-r-normal--11-80-100-100-p-60-iso8859-1'
    'newcenturymedium': font=$
      '-adobe-new century schoolbook-medium-r-normal--14-100-100-100-p-82-iso8859-1'
    'newcenturylarge': font=$
      '-adobe-new century schoolbook-medium-r-normal--25-180-100-100-p-136-iso8859-1'
    'lucidasmall': font=$
      '-b&h-lucida-medium-r-normal-sans-11-80-100-100-p-63-iso8859-1'
    'lucidamedium': font=$
      '-b&h-lucida-medium-r-normal-sans-14-100-100-100-p-80-iso8859-1'
    'lucidalarge': font=$
      '-b&h-lucida-medium-r-normal-sans-20-140-100-100-p-114-iso8859-1'
    'couriersmall': font=$
      '-adobe-courier-medium-r-normal--11-80-100-100-m-60-iso8859-1'
    'couriermedium': font=$
      '-adobe-courier-medium-r-normal--11-80-100-100-m-60-iso8859-1'
    'courierlarge': font=$
      '-adobe-courier-medium-r-normal--25-180-100-100-m-150-iso8859-1'
    else: font=''
  endcase
endif else begin
  case name1 of
    'timessmall': font='times*12'
    'timesmedium': font='times*14'
    'timeslarge': font='times*18'
    'centurysmall':font='CenturySchoolbook*12'
    'centurymedium':font='CenturySchoolbook*14'
    'centurylarge':font='CenturySchoolbook*18'
    'verdanasmall':font='verdana*12'
    'verdanamedium':font='verdana*14'
    'verdanalarge':font='verdana*18'
    'couriersmall':font='couriernew*12'
    'couriermedium':font='couriernew*14'
    'courierlarge':font='couriernew*18'
    else: font=''
  endcase
endelse
return,font
end
