pro CUTSET,setin,setout,XRANGE=xrange,CUTCOL=cutcol,MOUSECUT=mousecut
;
;+
; NAME:
;	CUTSET
;
; PURPOSE:
;	This procedure cuts a n-column set creating another set with only
;	the points inside the defined interval of the selected column
;
; CATEGORY:
;	General utilities.
;
; CALLING SEQUENCE:
;
;	CUTSET, set_in, set_out
;
; INPUTS:
;	setin:	fltarr(ncol,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	XRANGE=[xmin,xmax] :	 Defines the interval in the X axis
;	CUTCOL=index of the column where to look for the XRANGE
;	MOUSECUT= when set allow the user to define the cutting limits 
;		with the mouse
;
; OUTPUTS:
;	set_out new set with the selected points
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		CUTSET, set1, set2, xrange=[-3,3]
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;	MSR 93/03/10 remove YRANGE, add CUTCOL and MOUSECUT and allow ncol
;	MSR 95/08/20 MSR avoids error when xrange = [n,n]
;	MSR 96/08/22 MSR avoids error when no data point in xrange.
;	MSR 97/10/27 MSR includes points in the xrange limit (uses LE and GE).
;	MSR 99/01/13 MSR substitute calls to plotset by plot 
;-
;
on_error,2
;
if not(keyword_set(cutcol)) then cutcol=0
ncol=n_elements(setin(*,0))
tmpx=setin(cutcol,*) 
;
if not(keyword_set(xrange)) then begin
  xmin = -1e100
  xmax = +1e100
endif else begin
  xmin = float(xrange(0))
  xmax = float(xrange(1))
endelse

if (xmin EQ xmax) then begin
  xmin = -1e100
  xmax = +1e100
end
;
; cut the x array
;
if keyword_set(mousecut) then begin
  plot,tmpx,setin(1,*)
  print,' Please, click the min value for the bftr'
  cursor,xmin,tmp,3
  ; plotset,[[xmin,-1e10],[xmin,1e10]],/over
  oplot,[xmin,xmin],[-1e10,1e10]
  print,' Please, click the max value for the bftr'
  cursor,xmax,tmp,3
  ; plotset,[[xmax,-1e10],[xmax,1e10]],/over
  oplot,[xmax,xmax],[-1e10,1e10]
  print,' The selected points are: ',xmin,xmax
endif
;
if (keyword_set(xrange) or keyword_set(mousecut)) then begin
  good = where((tmpx ge xmin)and(tmpx le xmax))
  if good(0) EQ -1 then begin
     message,/info,'No good points in the selected interval. Returning '+$
	'the original set.'
     setout = setin
     return
  endif else tmp2x=tmpx(good)
endif else begin
  tmp2x = tmpx 
endelse
setout=fltarr(ncol,n_elements(tmp2x))
setout(cutcol,*)=tmp2x
;
; cut the rest of arrays
;
for i=0,ncol-1 do begin
  if (i ne cutcol) then begin
    tmp=setin(i,*)
    tmp2=tmp(where((tmpx ge xmin)and(tmpx le xmax)))
    setout(i,*)=tmp2
  endif
endfor
;
;
return
end
