# Korn shell commands to define IDL environment variables and aliases.
#
# This script can be used by IDL users who use ksh as their interactive shell
# to define the environment variables and aliases required by IDL
# related commands (idl, idlde, idlhelp, idldemo) if the symbolic links to
# the default directory (/usr/local/rsi/idl) are not being used.
#
# ksh users should run idl_setup from their .profile file 
# using the following command:
#
#    . /opt/rsi/idl_6.0/bin/idl_setup.ksh
#
RSI_DIR=/opt/rsi
IDL_DIR=/opt/rsi/idl_6.0
export IDL_DIR RSI_DIR
alias -x rsilicense=$IDL_DIR/bin/rsilicense
alias -x idl=$IDL_DIR/bin/idl
alias -x idlde=$IDL_DIR/bin/idlde
alias -x idldeclient=$IDL_DIR/bin/idldeclient
alias -x idlhelp=$IDL_DIR/bin/idlhelp
alias -x idlman=$IDL_DIR/bin/idlman
alias -x idlrpc=$IDL_DIR/bin/idlrpc
alias -x idldemo=$IDL_DIR/bin/idldemo
