;
;==================================================================================================
;
PRO xplot2d_overplotpeaks,wid,refresh=refresh

COMMON Xplot2D_common_variables, max_acceptable_screen_size_factor, scroll_step, margin_space, fileDir

Forward_Function xplot2d_draw_cake
;
; overplots circles corresponding to peaks in a XRD profile
; (peaks are read from a file in theta-2theta)
;

Widget_Control,wid,Get_UValue=info


; 
; get image 
;
pData=info.data->Value([info.image_num],/pointer)
imageTitle=info.data->Value([info.image_num],/title)
img = *pData
ssize=size(img)

IF info.overplotPeaks EQ 1 THEN BEGIN 
  ;
  ; get peaks
  ;
  a = rascii(info.file_peaks)
  peaks_e0=Reform(a[0,*])
  ncol = N_Elements(a[*,0])

  ;print,'>>>>>>peaks for e0: ', a[0,*]
  ;
  ; change peaks energy from Cu Ka to new one
  ;
  ;a[0,*]=a[0,*]/2.0
  ;a[0,*]=sin(a[0,*]*!pi/180.0)
  ;a[0,*]=a[0,*]*info.e1/info.e0
  ;a[0,*]=asin(a[0,*])
  ;a[0,*]=2.0*180.0/!pi*a[0,*]
  peaks_e1 = info.e0/info.e1 * sin(peaks_e0/2.0*!pi/180.0)
  peaks_e1 = 2.0*asin(peaks_e1)*180.0/!pi  ; 2theta in deg
  
  ; 
  ; normalize intensities to 100
  ;

  IF ncol EQ 3 THEN BEGIN
    intens = Reform(a[1,*])
    phases = Reform(a[2,*])
    diff_phases = phases[UNIQ(phases, SORT(phases))]
    FOR i=0,N_Elements(diff_phases)-1 DO BEGIN
      igood = where(phases EQ diff_phases[i])
      intens[igood]=intens[igood]/max(intens[igood])*100
    ENDFOR
    a[1,*]=intens
  ENDIF ELSE BEGIN
    a[1,*]=a[1,*]/max(a[1,*])*100
  ENDELSE
  
  
  ;
  ; change 2theta to pixels
  ;
  ;peaks_e1 = reform(a[0,*])
  peaks2 = info.detector_dist*tan(peaks_e1*!pi/180.0)/(info.pixelsize*1e-4)
  
  ;
  ; take only peaks inside the image range
  ;
  
  rmax = sqrt( (ssize[1]-(info.center)[0])^2 + $
         (ssize[2]-(info.center)[1])^2 )
  ;rmax = (ssize[1]-(info.center)[0])
  
  igood = where(peaks2 LE rmax)
  IF igood[0] EQ -1 THEN BEGIN
    itmp = Dialog_Message('No peaks found for dist < '+String(rmax), Dialog_Parent=wid)
    Goto,more
  ENDIF

  peaks_e0=peaks_e0(igood)
  peaks_e1=peaks_e1(igood)
  peaks2=peaks2(igood)
  intens=Reform(a[1,igood])
  IF ncol EQ 3 THEN BEGIN
    color = Reform(a[2,*])
    color = color[igood]+1
  ENDIF ELSE BEGIN
    color=intens*0+2
  ENDELSE

  ;
  ; refresh image (really needed???)
  ;
  IF Keyword_Set(refresh) THEN XPLOT2D_DISPLAY_IMAGE,event.top
  
  ; overplot circles
  print,'>> e0,e1: ',info.e0,info.e1
  print,'>> lambda0,lambda1: ',physical_constants('hc')/info.e0,physical_constants('hc')/info.e1
  print,'>> dspacing intensity peak# 2theta(e0) 2theta(e1) d_pixels: '
  FOR i=0,N_Elements(peaks2)-1 DO BEGIN
    points=XPLOT2D_DRAW_CAKE((info.center)[0]*info.Scale+info.image_position[0]+margin_space,$
      (info.center)[1]*info.Scale+info.image_position[1]+margin_space, $
      0.0,peaks2[i]*info.Scale,0.0,2*!Pi)
    Plots, points[0,*], points[1,*], linestyle=1, color=color[i], /device
    plots, points[0,0], points[1,0], linestyle=1, color=color[i], /device, /continue ;connect last point to the first
    xyouts,points[0,0], points[1,0]+randomu(seed)*40, color=color[i], /device,String(intens[i],Format='(I3)')
    print, (physical_constants('hc')/info.e1)/2./sin(peaks_e1[i]/2*!pi/180), $
	intens[i],i+1,peaks_e0[i],peaks_e1[i],peaks2[i]
  ENDFOR
  print,'>> '
ENDIF

more:
  
IF info.overplotDspacing EQ 1 THEN BEGIN 
  ;
  ; get peaks
  ;
  a = rascii(info.file_dspacing)

  ;
  ; get 2theta from dspacing
  ;
  lambda=physical_constants('hc')/info.e1
  a[0,*]=2.*asin(lambda/a[0,*]/2) ; in rads
  
  ; 
  ; normalize intensities to 100
  ;
  a[1,*]=a[1,*]/max(a[1,*])*100
  
  
  ;
  ; change 2theta to pixels
  ;
  peaks = reform(a[0,*])
  peaks2 = info.detector_dist*tan(peaks)/(info.pixelsize*1e-4)
  
  ;
  ; take only peaks inside the image range
  ;
  
  rmax = sqrt( (ssize[1]-(info.center)[0])^2 + $
         (ssize[2]-(info.center)[1])^2 )
  ;rmax = (ssize[1]-(info.center)[0])
  
  igood = where(peaks2 LE rmax)
  IF igood[0] EQ -1 THEN BEGIN
    itmp = Dialog_Message('No peaks found for dist < '+String(rmax), Dialog_Parent=wid)
    RETURN
  ENDIF
  peaks2=peaks2(igood)
  intens=Reform(a[1,igood])

  ncol = N_Elements(a[*,0])
  IF ncol EQ 3 THEN BEGIN
    color = Reform(a[2,*])
    color = color[igood]+1
  ENDIF ELSE BEGIN
    color=intens*0+2
  ENDELSE


  ;
  ; refresh image (really needed???)
  ;
  IF Keyword_Set(refresh) THEN XPLOT2D_DISPLAY_IMAGE,event.top
  
  ; overplot circles
  FOR i=0,N_Elements(peaks2)-1 DO BEGIN
    points=XPLOT2D_DRAW_CAKE((info.center)[0]*info.Scale+info.image_position[0]+margin_space,$
      (info.center)[1]*info.Scale+info.image_position[1]+margin_space, $
      0.0,peaks2[i]*info.Scale,0.0,2*!Pi)
    Plots, points[0,*], points[1,*], linestyle=1, color=color[i], /device
    plots, points[0,0], points[1,0], linestyle=1, color=color[i], /device, /continue ;connect last point to the first
    xyouts,points[0,0], points[1,0], color=color[i], /device,String(intens[i],Format='(I3)')
  ENDFOR
ENDIF

; 
; display legend
;
clr = color[Uniq(color)]
IF N_Elements(clr) GT 1 THEN $
    Legend,linestyle=Replicate(1,N_Elements(clr)),color=clr,'phase '+StrCompress(1+IndGen(N_Elements(clr)))

END
