PRO Xop_Input_Save,str_par,_Extra=extra,Group=group,Comment=comment,$
  Default=default

;+
; NAME:
;       XOP_INPUT_SAVE
;
; PURPOSE:
;       This procedure writes in a file the XOP application's parameters
;	stored in an IDL structure.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       Xop_Input_Save,str
;
; INPUTS:
;	str: the IDL structure with the XOP's application parameters.
;       
; KEYWORD PARAMETERS:
;       GROUP:  The widget ID of the group leader of the widget.  If this
;               keyword is specified, the death of the group leader results i n
;               the death of widgets created by XOP_WD.
;	Comment: a string array containg comments to be added to the 
;		file. 
;	_Extra: any other keyword to be passed to Dialog_PickFile
;		(If inputFile is not selected, starts the file browser).
;	Default: a string with the default file name to be displayed in
;		the file browser.
; OUTPUTS:
;       
;
; SIDE EFFECTS:
;	Write a file.
;
; PROCEDURE:
;       Uses the syntaxis defined in Make_Str and Write_Str functions.
;
; USE:
;       This procedure is to be used by any XOP application to write a
;	  file to store the input parameters. The first line, included
;	  in the comment, contains the application name and version.
;
; EXAMPLE:
;       str = (xop_defaults('xwiggler')).parameters
;	Xop_Input_Save,str_par,File='xwiggler.xop',$
;          /Write, Comment='; xop/xwiggler(v2.3) input file on '+SysTime()
;
;
; MODIFICATION HISTORY:
;       Written by:     Manuel Sanchez del Rio (srio@esrf.fr) 98/11/05
;	99-01-11 srio@esrf.fr better error managing.
;-
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/W) THEN itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'XOP_INPUT_SAVE: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
endif

back:

IF NOT(Keyword_Set(default)) THEN BEGIN
  ffile = Dialog_Pickfile(_Extra=extra)
  if strcompress(ffile,/rem) EQ '' then Return
  IF CheckFile(ffile) THEN BEGIN
    itmp = Dialog_Message(Dialog_parent=group,/Question,/Cancel,$
      ['File '+ffile+' exists.','Overwrite it?'])
    IF itmp EQ 'Cancel' THEN RETURN
    IF itmp EQ 'No' THEN GoTo,back
  ENDIF
ENDIF ELSE BEGIN
  dire = Xop_GetEnv('XOP_DEFAULTS_DIR')
  IF StrCompress(dire,/Rem) EQ '' THEN  BEGIN
    itmp = Dialog_message(/Error,Dialog_Parent=group,$
	['XOP_INPUT_SAVE: Failed to find user directory to save defaults',$
	 'It must be defined in the XOP_DEFAULTS_DIR environment variable'])
    RETURN
  ENDIF
  sd = SDep(/DS)
  ffile = dire + sd+default
  ierr=0
  Catch,/Cancel
  OpenW,unit,ffile,/Delete,/Get_Lun,Error=ierr
  IF ierr NE 0 THEN BEGIN
    itmp = Dialog_message(/Error,Dialog_Parent=group,$
	['XOP_INPUT_SAVE: Failed to open file: ',$
	 '  '+ffile,$
	 ' ','Please check that:',$
	 '      1) the directory "'+dire+'" exists.',$
	 '      2) you have write permission to write on it.'])
    RETURN
  ENDIF
  Catch, error_status
  Free_Lun,unit
ENDELSE

tmp=Write_Str(str_par,File=ffile,Group=group,Comment=comment)

IF Type(tmp) NE 7 THEN Message,'Error from WRITE_STR'

IF KeyWord_Set(defaults) THEN BEGIN
  text=['Application input saved to file (in defaults directory):',ffile,'',$
   '(This file can be edited or shortened. The customizable numerical',$
   ' values are in the third column. Do not change variable names.)']
ENDIF ELSE BEGIN
  text=['Application input saved to file:',ffile,'',$
   '(This file can be edited or shortened. The customizable numerical',$
   ' values are in the third column. Do not change variable names.)']
ENDELSE

itmp = Dialog_Message(/Info,Dialog_parent=group,text)

END
