function HISTOGRAMW,arr,wei,binsize=p_binsize,max=p_max,min=p_min, $
  input=hy,omax=omax,omin=omin,xval=xval, nbins=nbins
;+
; NAME:
;	HISTOGRAMW
; PURPOSE:
;	Same as HISTOGRAM, but weighted by wei array
; CATEGORY:
;	General
; CALLING SEQUENCE:
;	a= HISTOGRAMW(arr,wei,keywords)
; INPUTS:
;	ARR name of the array with data
; OPTIONAL INPUT PARAMETERS:
;	WEI name of the array with weigths 
;	None.
; KEYWORD PARAMETERS:
;	BINSIZE
;	The size of the bin to use. If this keyword is not specified, a bin size
;	of 1 is used.
;	
;	MAX
;	is the maximum value to consider. If this keyword is not specified,
;	Array is searched for its largest value.
;	
;	MIN
;	is the minimum value to consider. If this keyword is not specified,
;	and Array is of type byte, 0 is used. If this keyword is not specified
;	and Array is not of byte type, Array is searched for its smallest value.
;	
;	OMAX
;	A named variable that, upon exit, contains the maximum data value used
;	in constructing the histogram.
;	
;	OMIN
;	A named variable that, upon exit, contains the minimum data value used
;	in constructing the histogram.
;	
;	INPUT
;	Set this keyword to a named variable that contains an array to be added
;	to the output of HISTOGRAM. The density function of Array is added to
;	the existing contents of INPUT and returned as the result. The array is
;	converted to longword type if necessary and must have at least as many
;	elements as are required to form the histogram.
;	Multiple histograms can be efficiently accumulated by specifying partial
;	sums via this keyword.
;
;	XVAL 
;	Set this keyword to a named variable that contains an array with the
;	x(abscissas) values for the histogram
;
;	NBINS 
;	Set this keyword to a number of bins  desired for the plot. If
;	this keyword is set, the binsize kw is irrelevant.
;
; OUTPUTS:
;	Density function of ARR (see HISTOGRAM, IDL Users' Guide B-49)
; OPTIONAL OUTPUT PARAMETERS:
;	Same as HISTOGRAM.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble May 1991
;	94-09-27 MSR change keyword_set by n_elements when checking the
;		existence of the min and max keywords. This allows the
;		program when for example min=0, otherwise takes the
;		0 as keyword not defined and recalculates the value.
;	95-02-14 MSR Puts wei as OPTIONAL input parameter
;	96-05-13 MSR speeds it up. Adds O[MIN,MAX], INPUT, NBINS and XVAL 
;		keywords.
;-
on_error,2
if keyword_set(p_binsize) then binsize = p_binsize else binsize = 1
if n_params() EQ 1 then wei=replicate(1.,n_elements(arr)) 

; new data considering limits
icut = 0
if (n_elements(p_max) ne 0) then begin
  nmax = float(p_max) 
  icut = 1
endif else nmax = max (arr)
if (n_elements(p_min) ne 0) then begin
  nmin = float(p_min) 
  icut = 1
endif else nmin = min (arr)
if icut then begin
  flg =  where( (arr GE nmin) AND (arr LE nmax) )
  arr = arr( flg )
  wei = wei( flg )
endif


nelem = n_elements(arr)


if keyword_set(nbins) then  begin
  binsize =  (nmax - nmin) /nbins
endif else begin
  nbins = round( (nmax - nmin) /binsize)
endelse
;print,'HISTOGRAMW: binsize: ', binsize
;print,'HISTOGRAMW: nbins: ', (nmax - nmin) /binsize,nbins


if n_elements(hy) EQ 0 then hy = fltarr (nbins) ; if not input set
if ((n_elements(omax) NE 0) OR (n_elements(omin) NE 0)) then $
	omax=max(arr,min=omin)
if n_elements(xval) NE 0 then $
	xval = nmin + findgen(nbins)/(nbins-1)*(nmax-nmin)

hwarr = long( (arr-nmin)/binsize ) < (nbins-1)
;print,'Min max: ',min(hwarr),max(hwarr),nbins
for ii=0L,nelem-1 do begin
  hw = hwarr(ii) 
  hy(hw) = hy(hw) + wei(ii)
endfor

return, hy
end
