Function dabax_pathf,file,path,group=group

; 
; European Synchrotron Radiation Facility (ESRF)
;+
; NAME:
;       DABAX_PATHF
;
; PURPOSE:
;	Access to a dabax file. Returns the full data file name with path.
;	
; CATEGORY:
;       DABAX (DAta Base for Atomic X-rays properties) applications.
;
; CALLING SEQUENCE:
;	fullname = DABAX_PATHF(file[,path])
; INPUTS:
;	FILE:  DABAX data set file or SPEC data file.
; OPTIONAL INPUTS:
;	PATH:  string with DABAX directory path. If not set, uses
;		the value in the environment variable $DABAX_PATH
;	
; KEYWORDS:
;       group = The widget ID of the widget that calls the routine.
;               This is passed to widget_message in its dialog_parent
;               keyword to center the window message.
;
; OUTPUT:
;	String with the full name.
;
; PROCEDURE:
;
; EXAMPLE:
;	Name = dabax_pathf( 'CrystalStructures.dat', $
;	'.:/pgexp/applications1/XRayOptics/DABAX/data')
;
; MODIFICATION HISTORY:
;       96-07-10 Written by M. Sanchez del Rio (srio@esrf.fr)
;       97-02-14 srio@esrf.fr port to Windows. It only works for a 
;		DABAX_PATH with a single directory (by now...).
;       97-10-16 srio@esrf.fr adds group kw.
;	98-09-04 better error management
;	98-12-14 Cosmetics for xop2.0.
;	99-01-04 Adapted for Mac.
;	99-03-18 Adapted for Windows with multiple DABAX_PATH.
;on_error,2

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'SPEC_PATHF: error caught: '+!error_state.msg)
   Catch, /Cancel
   On_Error,2
   RETURN,''
ENDIF

if n_params() LT 1 then message,$
  'Usage: out=dabax_pathf(file [,path])'

if n_elements(path) EQ 0 then path = Xop_GetEnv('DABAX_PATH')

path_sep = SDep(/PS)
file_sep = SDep(/DS)

if strpos(path,path_sep) eq -1 then begin  ; only one directory in path
  tmp = path+file_sep+file
  if checkfile(tmp) EQ 0 then begin
     if sdep(/w) then $
	itmp = Dialog_Message(dialog_parent=group,/error, $
	'DABAX_PATHF: File '+file+' not found in path: '+path) else $
	 message,/info,'File '+file+' not found in path '+path
     return,''
  endif
  return,tmp
endif else begin
  pathlist=''
  n=strparse(path,path_sep,pathlist)
  if n LT 0 then  Message,'Not valid DABAX_PATH: '+path
  
  for i=0,n do begin
    a = FindFile(pathlist[i]+file_sep+file)
    IF a[0] NE '' THEN RETURN,pathlist[i]+file_sep+file
  endfor
  if sdep(/w) then itmp = Dialog_Message(dialog_parent=group,/error, $
     'DABAX_PATHF: File '+file+' not found in path: '+path) else $
     message,/info,'File '+file+' not found in path '+path
  return,''
endelse
end
