# Bash shell commands to define IDL environment variables and aliases.
#
# This script can be used by IDL users who use Bash as their interactive shell
# to define the environment variables and aliases required by IDL
# related commands (idl, idlde, idlhelp, idldemo) if the symbolic links to
# the default directory (/usr/local/rsi/idl) are not being used.
#
# Bash users should run idl_setup from their .profile file 
# using the following command:
#
#    . /opt/rsi/idl_6.0/bin/idl_setup.bash
#
RSI_DIR=/opt/rsi
IDL_DIR=/opt/rsi/idl_6.0
export IDL_DIR RSI_DIR
alias rsilicense=$IDL_DIR/bin/rsilicense
alias idl=$IDL_DIR/bin/idl
alias idlde=$IDL_DIR/bin/idlde
alias idldeclient=$IDL_DIR/bin/idldeclient
alias idlhelp=$IDL_DIR/bin/idlhelp
alias idlman=$IDL_DIR/bin/idlman
alias idlrpc=$IDL_DIR/bin/idlrpc
alias idldemo=$IDL_DIR/bin/idldemo
