PRO xop_wd,GROUP=group,default=default,_Extra=extra
;+
; NAME:
;	XOP_WD
;
; PURPOSE:
;	Changes XOP working directory. XOP working directry is where
;	XOP writes temporary files. 
;
; CATEGORY:
;	XOP
;
; CALLING SEQUENCE:
;	XOP_WD
; INPUTS:
;	None
;
; KEYWORD PARAMETERS:
;       GROUP:  The widget ID of the group leader of the widget.  If this 
;               keyword is specified, the death of the group leader results in
;               the death of widgets created by XOP_WD.
;	DEFAULT: When this keyword is set, XOP_WD changes directory to
;		the default XOP Working Directory. This directory is
;		specified in the XOP_WD environment variable. If the
;		XOP_WD environment variable is not set, the XOP Working
;		Directory is  %XOP_HOME%\tmp under WINDOWS and .
;		(dot=current directory) under UNIX.
;		If this keyword is not set, a dialog_pickfile window 
;		appears to select interactively the Working Directory.
;
; OUTPUTS:
;	None
;
; SIDE EFFECTS:
;	Changes directory using the IDL's cd command.
;
; PROCEDURE:
;	Straightforward.
;
; USE:
;	This procedure is to be used by XOP_INI when starting XOP.
; EXAMPLES:
;	xop_cw
;	xop_cw,/defaults
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (srio@esrf.fr) 97/10/02
;	98/11/04 srio@esrf.fr adds Catch. Use of /Dir kw in Dialog_Pickfile().
;	99/01/12 srio@esrf.fr fixed doc.
;-

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(/Error,'XOP_WD: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   Return
endif
if keyword_set(default) then begin
  wd = Xop_GetEnv('XOP_WD')
  if wd eq '' then begin
    if sdep() EQ 'WINDOWS' then cd,Xop_GetEnv('XOP_HOME')+'\tmp'
  endif else begin
    cd,wd
  endelse
  cd,current=wd
  message,/info,'XOP working directory is '+wd
endif else begin
  wd=''
  cd,current=wdold
  tmp = Dialog_Pickfile(path=wdold,get_path=wd,group=group,$
  title='Select XOP working directory',/Dir)
  if tmp NE '' then begin
   cd,wd
   message,/info,'XOP working directory is '+wd
   itmp = Dialog_Message(/Info,Dialog_Parent=group,$
     ['XOP working directory is: ',wd])
  endif
endelse
end ; xop_wd
