function xplot_defaults,inpstring
;
; ONLY FOR INTERNAL USE OF XPLOT (NOT DOCUMENTED)
;
; define defaults (customized for xplot). 
; Warning: some initial parameters are defined in several variables!!!
;
; Modification history:
;     97-08-27 srio@esrf.fr Makes the structures anonymous (for assuring
;     compatibility between the backup files between different Xplot
;     versions). Added MESH option.
;     97-09-10 srio@esrf.fr add wids tag to strcontrols
;     97-10-16 srio@esrf.fr fixes a bug Ymin=Ymax
;     97-10-22 srio@esrf.fr xplot_defaults may be customized with the 
;		file defined in the XPLOT_DEFAULTS environment variable.
;     98-08-27 srio@esrf.fr improves setlimits and use of system variables
;     98-09-30 srio@esrf.fr Version 2.6Beta3.
;     98-11-20 srio@esrf.fr Version 2.6Beta5. (fixed bug in save/restore xplot
;		backup file, added "add to file" in spec.
;     99-03-12 srio@esrf.fr adds !p.font. Version 2.7 B1
;     01-02-23 srio@esrf.fr Preparing XOP couse at ESRF. Version 2.8
;
on_error,2

inpstring = STRLOWCASE(inpstring)

case inpstring of
  'xpdt': begin
	sysvardef = $
	['!p.charsize = 0.0', $
	'!p.ticklen = ' + strcompress(!p.ticklen,/rem), $
	'!x.range = [0.0,0.0]', $  ; check with xptd_limits
	'!y.range = [0.0,0.0]', $  ; check with xptd_limits
	'!x.style = 0', $                         ; check with xptd_limits
	'!y.style = 0', $                         ; check with xptd_limits
	'!p.background = 0', $ ; strcontrols
	'!p.color = 255',  $   ; strcontrols
	'!p.font = -1']        ; set strcontrols.font in [0,15] range
	
	xpdt = { $
	Xcol:0L , Ycol:0L, $
	Connect:0L, Psym:0L, Linestyle:0L, Kind:1L, $
	Thick:1.0, Nfiles:0L, FileName:' ', Font:'0', $
	Shift:[0.0,0.0], ErrPlot:[0,0], Infile:' ', $
	sysvar:sysvardef, $
	zoompixmap:-1L,zoom_on:0,$
	zoomsel:[0.,0.,0.,0.], axis2:[0.,0.,0.,0.],$
	mesh:{ flag:['0','NO','YES'], $
	     kind:['0','lines','surface','contour','shaded surf'], $
	     split:['0','Each N points','Using a "label" column'],$
	     points:10, col:2,$
	     keywords:''}  }
      end
  'xpdt_limits': xpdt_limits = $
	{ Xmin:0.0, $
	  Xmax:0.0, $
	  Xstyle0:['0','Rounded','Exact'],$
	  Xstyle1:['0','Exact','Extend 5%'],$
	  Xstyle2:['0','Draw','Suppress'],$
	  Xstyle3:['0','Draw','Suppress'],$
	  Xstyle4:['0','Always included','Not always included'],$
	  Ymin:0.0, $
	  Ymax:0.0, $
	  Ystyle0:['0','Rounded','Exact'],$
	  Ystyle1:['0','Exact','Extend 5%'],$
	  Ystyle2:['0','Draw','Suppress'],$
	  Ystyle3:['0','Draw','Suppress'],$
	  Ystyle4:['0','Always included','Not always included'] }
  'xpdt_titles': xpdt_titles = $
	{ Title:' ', Xtitle:' ', Ytitle:' '}
  'strcontrols': strcontrols = $
	{ connect:0L, symbol:0L,LineStyle:0L,Axis:0L,$
	Ticks:0L, Thickness:1.0,CharSize:1.0,Font:0,BackGround:0, $
	Axiscolor:255, Color:255, $
        wids:{Main:0L, Connect:0L, Symbol:0L, Linestyle:0L, Axis:0L,$
                Ticks:0L, Font:0L, Thickness:0L, CharSize:0L, $
                BackGround:0L, Axiscolor:0L, Color:0L} }

  ; NOTE: if changing this structure, change also flags and titles in
  ; xplot_evaluate!!
  'xpevaluate': xpevaluate = $
	{  $
	Expression_x:'Cx = Ax*1.0', $
	Expression_y:'Cy = Ay*1.0', $
	nset:['0','1','2'], $
	set1:'current set', $
	set2:'xplot.dat', $
	save_as:['0','No','Yes'], $
	filename:'xplot.dat', $
	over:['0','No','Yes'] }


  ; NOTE: if changing this structure, change also flags and titles in
  ; xplot_event!!
  'xpconvolution': xpconvolution = $
	{ $
	METHOD: ['0','Convolution','Correlation'] ,$
	TYPE: ['0','Auto convolution/correlation', $
		   'with a Gaussian or/and Lorentzian',$
		   'with data from external file'] , $
	FILENAME: '' , $
	NORMALIZATION: ['2','No','To the first set','To the second set',$
			   'To both sets'], $
	VOIGT_RATIO:0.0,$
	VOIGT_FWHM:0.1,$
	OVER: ['0','No','Yes'], $
	WRITE: ['0','No','Yes'], $
	FILEOUT: 'xplot.dat', CALCULATION:['0','FFT','Intregrals'] }

  
  ; NOTE: if changing this structure, change also flags and titles in
  ; xplot_saveascii!!
  'saveascii': saveascii = $
	{ ffile:'?',$
	  save: ['0','Current data','All columns'],$
	  header: ['0','No','Yes'],$
	  comment:'',$
	  format:'(G0.6," ")'  }

  'version': version = {version:'2.8'}
  'autoreloadfile': autoReLoadFile = { $
	set:{check:['1','Always','Only if modified'], timer:5.0, start:['1','No','Yes']}, $
	titles:['Update: ','Wait before updating [sec]','Start auto-reload now'],$
	reloadflag:0}

  else: out = 0
endcase
;
; update values with values in
; files .xplot_defaults in a directory in !PATH
;
file = getenv('XPLOT_DEFAULTS')
if file EQ '' then goto,out
tmp = checkfile(file)
if tmp NE 1 then goto,out
; Message,/Info,'Reading Xplot defaults from file: '+file
openr,Unit,file,/GET_LUN
command = ''
while (not(eof(Unit))) do begin
  readf,Unit,command
  nn = strparse(command,'.',list)
  if strupcase(inpstring) EQ strupcase(strcompress(list(0))) then begin
  ; print,'***'+command+'***'
  tmp = execute(command)
  endif
endwhile
free_lun,Unit
; message,/info,'Defaults from file: '+file+'
;
; return
;
out:
out = 0
command = 'out = '+inpstring
;print,command 
tmp = execute(command)
return,out
end
