
;+
; NAME:
;	CW_PICKFILE
;
; PURPOSE:
;	CW_PICKFILE is a compound widget that displays a file name
;	allowing the user to edit the name and use a browser
;	(Dialog_Pickfile) to load a file name.
;
; CATEGORY:
;	Compound widgets.
;
; CALLING SEQUENCE:
;	Widget = CW_PICKFILE(Parent)
;
; INPUTS:
;	Parent:	  The ID of the parent widget.
;
; KEYWORD PARAMETERS:
;	UVALUE:	The user value for the widget.
;	TITLE:	A label or title (Default='File: ')
;	VALUE:	The initial file name (the default displays '<none>'
;		and returns an empty string ('').
;	COLUMN:	Display widgets inside the compound widget in column.
;	FRAME:	Display a frame around the compound widget.
;	XSIZE:	the size (in characters) of the text widget with the
;		directory name.
;	PATH:	the directory path to be passed to Dialog_Paickfile.
;		If not set, it used the current directory AT THE 
;		TIME OF THE WIDGET DEFINITION.
;		Note: For using the current directory at any time, 
;		set explicitely "PATH=0"
;
;	In addition to these keywords, cw_pickfile accepts all the
;	keywords accepted by Dialog_Pickfile. These keywords are passed
;	to the Dialog_Pickfile routine when the user clicks on the
;	"Browser..." button.
;
; OUTPUTS:
;	The ID of the created widget is returned.
;
; SIDE EFFECTS:
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;
;	;
;	; Use this program to test cw_pickfile
;	;
;	Pro test_cw_pf_event, event
;	Widget_Control, event.id, get_UValue=eventUValue
;	if not(keyword_set(eventUValue)) then eventUValue=''
;
;	stateid = Widget_Info(event.handler,/Child)
;	Widget_Control, stateid, get_UValue=state, /No_Copy
;
;	Case eventUValue OF
;	    'DONE': Begin
;		Widget_Control, event.top, /destroy
;		Return
;		End
;	    'GETVALUE': Begin
;		Widget_Control,state.file,Get_Value=aa
;		message,/info,'>> value is: '+aa
;		end
;	    else:
;	ENDCASE
;	Widget_Control, stateid, Set_UValue=state, /No_Copy
;	END ; test_cw_pf_event
;	;
;	;
;	Pro test_cw_pf
;	tlb=widget_base(/col)
;	wtmp=widget_base(tlb) ; to store state
;
;	wtmp = Widget_Button(tlb,Value='DONE',UValue='DONE')
;	wtmp = Widget_Button(tlb,Value='GETVALUE',UValue='GETVALUE')
;	; the important part:
;	wfile = cw_pickfile(tlb,/write,Title='File to write:',/Frame)
;
;	state = {file:wfile}
;
;	widget_control,Widget_Info(tlb,/Child),set_uvalue=state
;	widget_control,tlb,/realize
;	xmanager, 'test_cw_pf', tlb
;	end ; test_cw_pf
;
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, srio@esrf.fr
;	December, 1997
;	98/03/20 srio@esrf.fr fix a bug with VALUE kw. Adds XSIZE kw.
;	00/07/17 srio@esrf.fr added PATH keyword (some problems got
;			in windows)
;	04/06/10 srio@esrf.fr fix a problem with starting directory,
;		pointed out by H. Rocchiccioli. 
;-
;
;===============================================================
;
Pro CW_PickFile_Set, id, value
; acceps 'Default' and , for instance, [0,3,3]
;
child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

IF n_elements(value) EQ 0 THEN value = '<none>'
Widget_Control,state.wids.FileName, Set_Value = value

Widget_Control, child, Set_UValue=state, /No_Copy
END
;
;===============================================================
;
Function CW_PickFile_Get, id
child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

Widget_Control,state.wids.FileName, Get_Value = value

Widget_Control, child, Set_UValue=state, /No_Copy
IF StrCompress(value(0),/Rem) EQ '<none>' THEN value = ''
Return, value(0)
END
;
;===============================================================
;
Function CW_PickFile_Event, event

child = Widget_Info(event.handler, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

Widget_Control, event.id, Get_UValue=uvalue
IF N_Elements(uvalue) EQ 0 THEN uvalue=''

iret = 1
IF uvalue EQ 'BROWSER' THEN BEGIN
  IF Keyword_Set(   state.path) THEN BEGIN
    IF type(state.extra) EQ 8 THEN $
    ;tmp = Dialog_Pickfile(_Extra=state.extra,Path=state.path) ELSE $
    ;tmp = Dialog_Pickfile(Path=state.path)
      tmp = Dialog_Pickfile(_Extra=state.extra,Path=state.path) ELSE $
      tmp = Dialog_Pickfile(Path=state.path)
  ENDIF ELSE BEGIN
    IF type(state.extra) EQ 8 THEN $
      tmp = Dialog_Pickfile(_Extra=state.extra)  ELSE $
      tmp = Dialog_Pickfile()
  ENDELSE
  ;IF tmp EQ '' THEN tmp = '<none>'
  IF tmp EQ '' THEN BEGIN
    iret=0
    goto,out
  ENDIF
  Widget_Control,state.wids.FileName,Set_Value=tmp
ENDIF

out:
Widget_Control, child, Set_UValue=state, /No_Copy
;
; return event structure
;
if iret then begin
  WIDGET_CONTROL, event.id, get_uvalue=uvalue
  if n_elements(uvalue) EQ 0 then uvalue=0
  return, { ID:event.handler, TOP:event.top, HANDLER:0L, value:uvalue }
endif else return,0

END
;
;
;===============================================================
;
Function CW_PickFile, parent, UValue=uval, Title=init_label, $
  Value=init_value,Column=Column,Frame=Frame, Path=path, $
  _EXtra=extra, XSIZE=xsize

On_Error,1
;If N_Params() NE 1 THEN Message,'Must have one parameter'
If N_Elements(uval) EQ 0 THEN uval = 0
If N_Elements(Frame) EQ 0 THEN Frame = 0
If N_Elements(init_label) EQ 0 THEN init_label = 'File: '
If N_Elements(value) EQ 0 THEN value = ''
IF N_Elements(extra) EQ 0 THEN extra=0
IF N_Elements(path) EQ 0 THEN BEGIN
  path=0
  CD,Current=path
ENDIF


row=1
If keyword_set(column) then row=0 else Column=0



cw_tlb = Widget_Base(parent, Frame=Frame, Uvalue=uval, $
   Column=Column,Row=Row, $
   Event_Func='CW_PickFile_Event',$
   Pro_Set_Value='CW_PickFile_Set', $
   Func_Get_Value='CW_PickFile_Get')
wtmp = Widget_Base(cw_tlb) ; To store state

wbutton = Widget_Button(cw_tlb,Value='Browser...',UVALUE='BROWSER')
wlabel = Widget_Label(cw_tlb, Value=init_label)
wFileName = Widget_Text(cw_tlb, VALUE=value, UVALUE='FILENAME',/Edit,$
	Xsize=xsize)



wids={label:wlabel,FileName:wFileName}
state = {wids:wids, Extra:extra, Path:path}

child=Widget_Info(cw_tlb, /Child)
Widget_Control, child, Set_UValue=state , /No_Copy

widget_control,cw_tlb,set_value=init_value

Return, cw_tlb
END
