function eq_edit,eq1,flags,a

;+
; NAME:
;	EQ_EDIT
;
; PURPOSE:
;	To edit an equation as defined in curvefit1. It returns the 
;	equation with the fixed values and with the rearranged parameter
;	indeces.
;	To be used by curvefit1 for allowing fitting with fixed parameters.
;
; CATEGORY:
;	Utilities.
;
; CALLING SEQUENCE:
;
;	Result = eq_edit(eq,flags,a)
;
; INPUTS:
;	eq1:  A string wuth the equation.
;
;	flags: An array of the same dimension of the free parameters
;	containing zeros or ones (0=fix, 1=free) depending if the corresponding
;	parameters is fox or free in the fitting process. 
;	
;	a: the array with the initial values.
;
; OUTPUTS:
;	This function returns the equation with the parameters placed in
;	their corresponding place when they are fixed and with the 
;	free parameters sorted.
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	eq1 = 'A(0) * exp( A(1) * X) + A(2) + A(3) * sin(x) +a(0)'
;	flags = [1,0,0,1]
;	a=[10.0,-7.0,9.0,4.0]
;	print,eq_edit(eq1,flags,a)
;	A(0)*exp((-7.00000)*X)+(9.00000)+A(1)*sin(x)+a(0)
;
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanched del RIo (srio@esrf.fr) 97-10-23
;	99-03-04 srio@esrf.fr allows for both () and [] indices syntax.
;		Parameter my be named either A or P.
;-
catch, error_status
if error_status ne 0 then begin
  message,/info,'error caught: '+!error_state.msg
  catch, /cancel
  return,eq1
endif
if n_params() NE 3 then begin
  message,/info,'Usage: eq_new=eq_edit(eq_old,flags,params)'
  return,eq1
endif
;eq1 = 'A(0) * exp( A(1) * X) + A(2) + A(3) * sin(x) +a(0)'
eqnew = strcompress(eq1,/rem)
;flags = [1,1,1,1]
;a=[10.0,-7.0,9.0,4.0]

nflags = n_elements(flags)-1

str1=['A(','A[','P(','P[']
str2=[')',']',')',']']
FOR KK=0,3 DO BEGIN
  shorted = 0
  for i=0,nflags do begin
    if flags(i) EQ 0 then begin
      eqnew = strsubstitute(eqnew,str1[kk]+strcompress(i-shorted,/rem)+$
	str2[kk],'('+strcompress(a(i),/rem)+')',/NOCASE)
      if i+1 le n_elements(flags)-1 then begin
        for j=i+1,n_elements(flags)-1 do begin
          eqnew = strsubstitute(eqnew,str1[kk]+strcompress(j-shorted,/rem)+$
	  str2[kk],str1[kk]+strcompress(j-shorted-1,/rem)+str2[kk],/NOCASE)
        endfor
        shorted = shorted + 1
      endif
    endif
  endfor
ENDFOR

return,eqnew
end

