Function straccumulate,line,separator
;+
; NAME:
;	STRACCUMULATE
; PURPOSE:
;	Accumulates a string array in a single string.
; CATEGORY:
;	String Processing
; CALLING SEQUENCE:
;	Result = STRACCUMULATE( STRING_ARRAY [, SEPARATOR]
; INPUTS:
;    STRING_ARRAY
;	String array.
; OPTIONAL INPUT PARAMETERS:
;	SEPARATOR = a strinng to be placed between the STRING_ARRAY elements.
; KEYWORD PARAMETERS:
; OUTPUTS:
;	A string.
; OPTIONAL OUTPUT PARAMETERS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
; EXAMPLE:
;	print,straccumulate(['1','2','3'],':')
;	You get: 1:2:3
; MODIFICATION HISTORY:
;	Created 10-Jul-1996 by M. Sanchez del Rio (srio@esrf.fr)
;-
;
on_error,2
if n_elements(separator) EQ 0 then separator=''
n = n_elements(line)
out = line(0)
for i=1,n-1 do out = out + separator + line(i)
return,out
end


