;+
;
;==================================  DABAX     =================================
;
;   DABAX is a widget based graphical interface to visualize and 
;   process data stored in the DABAX data base.
;
;   This is the main interface that allows to access to the contains
;   of the files, makes plots and start processing applications based
;   on that files.
;
;   More information about DABAX can be found at the XOP web page 
;   (select the DABAX entry):
;   http://www.esrf.fr/computing/scientific/xop
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;   Download new DABAX file...
;	Information on how to add and update files to your DABAX directory.
;	It also includes a socket mechanism to automatically download and install
;		files.
;   Quit: to exit from the program
;  Edit: 
;   DABAX Path: Permits to edit the DABAX path. Dabax path is a 
;	list of directories (separated by columns ':') that
;	define the placed where the DABAX files are located.
;	The utility of redefining the DABAX path here is to add
;	user-files located in user directories.
;  View:
;   Refresh File List: refresh main window with DABAX list of files. 
;   DABAX Path: Displays the current DABAX Path.
;   Full File Name: Displays the Full name of the selected DABAX
;	file. This is useful when several versions of a file
;	with the same name are present in different directories 
;	in the DABAX path.
;  Help:
;   DABAX: Displays doc of DABAX interface application (this text).
;
; COPYRIGHT:
;	DABAX  belongs to XOP package and it is distributed within XOP.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;
; CREDITS:
;	Published calculations made with XOP should refer:
;
;	  M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	  SPIE proceedings vol. 3448, pp.340-345, 1998.
;
;
; LAST MODIFICATION: msr/msr/03-01-10
;
;
;-
;
;
;	MODIFICATION HISTORY:
;       by  Manuel Sanchez del Rio. ESRF. July 1996.
;	srio@esrf.fr (MSR) 96-09-18 cosmetics.
;	srio@esrf.fr (MSR) 97-10-15 Adapsts for xop 1.9. Changes the
;		interface look to overcome a bug in idl that resizes
;		the window when clicking on the files. 
;	srio@esrf.fr (MSR) 98-12-14 small changes for XOP2.0.
;	srio@esrf.fr (MSR) 99-01-04 Use of Xop_{sg}etenv (from XOP-MAC)
;	srio@esrf.fr (MSR) 99-03-16 Doc updated.
;	srio@esrf.fr (MSR) 99-03-18 Edit menu also in windows.
;	srio@esrf.fr (MSR) 00-07-17 update web links
;	srio@esrf.fr (MSR) 01-11-15 added no_xray keyword (for neutrons)
;	srio@esrf.fr (MSR) 03-01-10 added refresh and download mechanisms. 
;
;-
;
;=====================================================================
PRO dabax_event,event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'DABAX_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   If Type(stateid) EQ 3 THEN $
     If Widget_Info(stateid,/Valid_Id) AND N_Elements(state) NE 0 THEN $
     Widget_Control,stateid,Set_UValue=state ; ,/No_Copy
   On_Error,2
   RETURN
ENDIF

Widget_Control, event.id, get_UValue=eventUValue

if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''

stateid = Widget_Info(event.handler,/Child)

Widget_Control, stateid, get_UValue=state ; , /No_Copy

if event.top eq event.id then begin ; resize drawing area
    ;widget_control,state.wids.list,scr_xsize=event.x-145,scr_ysize=event.y-220
    widget_control,state.wids.list,scr_xsize=event.x-10,scr_ysize=event.y-160
    goto,out
endif


;help,eventuvalue
widget_control,/hourglass
case eventuvalue of
  'EXECUTE': begin
	widget_control,event.id,get_value=val
	IF val EQ 'Other...' THEN BEGIN
 	  tmp='xF0'
	  XEDIT, tmp, TEXT='Enter application to be run: ', $
	    TITLE='Run DABAX application',ACTION=action
	  if action eq 'CANCEL' then goto,out
	  val=tmp
	ENDIF
	command = val+',group='+strcompress(event.top,/rem)+'L'
	message,/info,' executing command: '+command
	tmp = execute(command)
	IF tmp NE 1 THEN BEGIN
	  itmp = Dialog_Message(Dialog_Parent=event.top,/Error,$
	    ['DABAX_EVENT: Error executing command: ',val])
	ENDIF
	end
  'LIST': begin
	state.ListSel=event.index
	widget_control,/hourglass
	Widget_Control,state.wids.listFiles,Get_UValue=list
	file = list(state.ListSeL)
	widget_control,state.wids.path,get_uvalue=path
	file = dabax_pathf(file,path(0),group=event.top)
	widget_control,state.wids.sel,set_uvalue=file
	end
  'QUIT':begin	
	widget_control,/destroy,event.top
	return
	end
  'EDITPATH':begin	
	widget_control,state.wids.path,get_uvalue=path
	path1 = path(0)
	;XEDIT, path1, TEXT='Enter DABAX Path: ', TITLE='Edit DABAX Path',$
	;ACTION=action
	action=''
	XPickFile, file=path1, Title='Enter DABAX Path: ', WTitle=$
	  'Edit DABAX Path',Action=action
	IF action NE 'DO' THEN GoTo,out
	Xop_SetEnv,'DABAX_PATH='+path1
	Widget_Control,state.wids.path,Set_UValue=path1
	List = dabax_ls(path1)
	state = { wids:state.wids, ListSel:state.ListSel}
	widget_control,state.wids.path,set_uvalue=path1
	widget_control,state.wids.list,set_value=List
	widget_control,state.wids.listFiles,set_UValue=list
	end
  'SHOWPATH':begin	
	widget_control,state.wids.path,get_uvalue=path
	itmp = widget_message(dialog_parent=event.top,/INFO,$
	  ['DABAX Path is: ',path(0)])
	end
  'SHOWNAME':begin	
	widget_control,state.wids.sel,get_uvalue=file
	if strcompress(file(0),/rem) EQ '<none>' then begin
	  itmp = widget_message(dialog_parent=event.top,/error,$
	  'Please click on a data file name.')
	  goto,out
	endif
	itmp = widget_message(dialog_parent=event.top,/INFO,$
	  ['Selected DABAX File is: ',file])
	end
  'INFO':begin	
	widget_control,state.wids.sel,get_uvalue=file
	if strcompress(file(0),/rem) EQ '<none>' then begin
	  itmp = widget_message(dialog_parent=event.top,$
		/error,'Please click on a data file name.')
	  goto,out
	endif
	h=dabax_access(file(0))
	text = spec_headers(h,-1,'UD',/all,/index)
	n = n_elements(text)
	for i=0,n-1 do text(i) = strsubstitute(text(i),'#UD','')
	;textwindow,text,group=event.top,title='Doc for: '+file
	xdisplayfile1,text=text,group=event.top,title='Doc for: '+file
	end
  'INSPECT':begin	
	widget_control,state.wids.sel,get_uvalue=file
	if strcompress(file(0),/rem) EQ '<none>' then begin
	  itmp = widget_message(dialog_parent=event.top,$
		/error,'Please click on a data file name.')
	  goto,out
	endif
	h=dabax_access(file(0))
	n = strparse(file(0),'/',tmp)
	if n ge 0 then file = tmp(n) else file = file(0)
help,/str,state
	xspecview,h,GROUP=event.top,title='Inspecting DABAX file: '+file,$
	  no_block=state.no_block
	end
  'PLOT':begin	
	widget_control,state.wids.sel,get_uvalue=file,/hourglass
	if strcompress(file(0),/rem) EQ '<none>' then begin
	  itmp = widget_message(dialog_parent=event.top,$
		/error,'Please click on a data file name.')
	  goto,out
	endif
	h=dabax_access(file(0))
	widget_control,/hourglass
	xplot,spec=h,wtitle=file(0),xtitle='-1',ytitle='-1',title='#S',$
	  no_block=state.no_block
	end
  'PROCESS':begin	
	widget_control,state.wids.sel,get_uvalue=file,/hourglass
	if strcompress(file(0),/rem) EQ '<none>' then begin
	  itmp = widget_message(dialog_parent=event.top,$
		/error,'Please click on a data file name.')
	  goto,out
	endif
	h=dabax_access(file(0))
	text = spec_headers(h,-1,'UIDL',/all,/index)
	if strcompress(text(0),/rem) EQ ''  then begin
	  tmp=widget_message(dialog_parent=event.top,$
	    ['No IDL application associated to DABAX'+$
	    ' file: '+file(0),'','IDL applications are associated to'+$
	    ' DABAX files using their #UIDL keyword.'])
	  goto,out
	endif
	for i=0,n_elements(text)-1 do begin
	  command = strsubstitute(text(i),'#UIDL','')
	  command = command+',group = '+strcompress(event.top,/rem)+'L'
          command = command+',no_block = '+strcompress(state.no_block,/rem)
          Message,/Info,'Executing: '+strcompress(command,/rem)
	  itmp = execute(command)
	endfor
	end
  'REFRESH':begin	
	widget_control,state.wids.path,get_uvalue=path
	path1 = path(0)
	path = Xop_GetEnv('DABAX_PATH')
	List = dabax_ls(path)
	Widget_Control,state.wids.list,Set_value='<none>'
	wait,0.5
	Widget_Control,state.wids.list,Set_value=list
	Widget_Control,state.wids.listFiles,Set_Uvalue=list
        state.ListSel=-1
        widget_control,state.wids.sel,Set_UValue='<none>'
	end

  'DOWNLOAD':begin	
	destDir = Xop_Getenv('XOP_HOME')+SDep(/ds)+'data'+SDep(/ds)+'dabax'+SDep(/ds)
	cd,c=pwd
	txt = ['DABAX files in your local XOP installation can be ',$
         'updated. Also, other DABAX files can be added. ',$
         ' ',$
         'In order to update or add DABAX files, you must download ',$
         'the corresponding DABAX file from ',$
         '     http://ftp.esrf.fr/pub/scisoft/xop/DabaxFiles/ ',$
         'and install (copy) it in your local directory ',$
         '     '+destDir,$
         ' ',$
         'VERY IMPORTANT: The download must be done in ASCII mode.  ',$
         'For that, it is recommended to use an ftp application and set ',$
         'the transfer in ASCII. Downloading the file with a www browser ',$
         'like iexplorer or netscape may give problems as the transfer  ',$
         'mode could be modified.  ',$
         ' ',$
         'XOP can help to install/update new files (but the success is not ',$
         'guaranteed). ',$
         ' ',$
         'Do you want to install/update a new DABAX file now? ',$
         ' (requires internet connection, and writing permission in ',$
         ' the destination directory)' ,$
         ' ']
        itmp = Dialog_Message(/Question,txt,Dialog_Parent=event.top)
	IF itmp EQ 'No' THEN GoTo,out

	; get list of files
	socket, unit, 'ftp.esrf.fr', 80, /get_lun
	printf, unit, 'GET http://ftp.esrf.fr/pub/scisoft/xop/DabaxFiles/LIST.TXT'
	tmps = ''
	while eof(unit) EQ 0 do begin
	  readf, unit, tmps
	  IF N_Elements(list) EQ 0 THEN list=tmps ELSE list=[list,tmps]
	endwhile
	free_lun, unit
        itmp = wmenu2(['Cancel',list],WTitle='Select a file: ',Dialog_Parent=event.top)
	IF itmp EQ 0 THEN  GoTo,out
	file = list[itmp-1]
	itmp = Dialog_Message(['Download '+file,'Please confirm'],/Question,$
	  Dialog_Parent=event.top)
	IF itmp EQ 'No' THEN GoTo,out


	socket, unit, 'ftp.esrf.fr', 80, /get_lun
	printf, unit, 'GET http://ftp.esrf.fr/pub/scisoft/xop/DabaxFiles/'+file
	tmps = ''
	openw, unitout, file, /get_lun
	while eof(unit) EQ 0 do begin
	  readf, unit, tmps
	  printf, unitout, tmps
	endwhile
	free_lun, unit
	free_lun, unitout

	IF checkfile(file) NE 1 THEN BEGIN
	  itmp = Dialog_Message(' File not created. Some problem arrived.', $
		Dialog_Parent=event.top,/Error)
	  GoTo,out
	ENDIF 
	
	itmp = Dialog_Message(/Question, $
	  [' File: '+file+' created in current directory: '+pwd, $
	   ' ','Install (move) it on destination directory: '+destDir], $
	  Dialog_Parent=event.top)
	IF itmp EQ 'No' THEN GoTo,out

	command = [destDir+file+' '+destDir+file+'-old', $
		   pwd+SDep(/ds)+file+' '+destDir+file]
	IF  SDep() EQ 'UNIX' THEN command = 'mv '+command ELSE command = 'move '+command
	itmp = Dialog_Message(['Executing (spawn): ',command,' ','Please confirm'],/Question,$
	 Dialog_Parent=event.top)
	IF itmp EQ 'No' THEN GoTo,out
	spawn,command[0]
	spawn,command[1]
	; refresh
	widget_control,state.wids.path,get_uvalue=path
	path1 = path(0)
	path = Xop_GetEnv('DABAX_PATH')
	List = dabax_ls(path)
	Widget_Control,state.wids.list,Set_value='<none>'
	wait,0.5
	Widget_Control,state.wids.list,Set_value=list
	Widget_Control,state.wids.listFiles,Set_Uvalue=list
        state.ListSel=-1
        widget_control,state.wids.sel,Set_UValue='<none>'
	end


  'HELPIDLDABAX': xhelp,group=event.top,'dabax'
  else:
endcase

out:
Widget_Control, stateid, set_UValue=state ; , /No_Copy
end
;
;=======================================================================
;
PRO dabax,GROUP=group,No_Xray=No_Xray,No_Block=no_block
;
;
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'DABAX: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
base = widget_base(/COLUMN,TITLE='DABAX',/TLB_SIZE_EVENTS,$
	MBAR=wMenuBar)
;auxiliar base to define things that do not appear on the scrre
base_aux = widget_base()
;
; the menu bar
;

;Menu bar
wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Download new DABAX file...', $
	Uvalue= 'DOWNLOAD')
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit', Uvalue= 'QUIT')
wEditMenu =  WIDGET_BUTTON(wMenuBar, VALUE='Edit', /MENU)
    wtmp=WIDGET_BUTTON(wEditMenu, VALUE='DABAX Path', Uvalue= 'EDITPATH')
wViewMenu =  WIDGET_BUTTON(wMenuBar, VALUE='View', /MENU)
  wtmp=WIDGET_BUTTON(wViewMenu, VALUE='Refresh File List', Uvalue= 'REFRESH')
  wtmp=WIDGET_BUTTON(wViewMenu, VALUE='DABAX Path', Uvalue= 'SHOWPATH')
  wtmp=WIDGET_BUTTON(wViewMenu, VALUE='Full File Name', Uvalue= 'SHOWNAME')
wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
  tmp = widget_button(wHelpMenu,VALUE='DABAX',UVALUE='HELPIDLDABAX')
;  tmp = widget_button(wHelpMenu,VALUE='DABAX WWW Home Page',UVALUE='HELPDABAX')
 

;
;
; the blocks box
;


path = Xop_GetEnv ('DABAX_PATH') 
Bbox = widget_base(base,/COLUMN)

Bpath = widget_base(base_aux,UVALUE=path)

tmp = widget_label(Bbox,VALUE='Data Files (click one): ')
List = dabax_ls(path)
Blist = widget_list( Bbox, VALUE=List,UVALUE='LIST', YSIZE=10)


Bsel = widget_base(base_aux,UVALUE='<none>')
BlistFiles = widget_base(base_aux,UVALUE=list)

tmpbase = widget_base(Bbox,/row)
tmp = widget_button(tmpbase,VALUE='File Doc',UVALUE='INFO')

tmpbase = widget_base(Bbox,/row)
tmp = widget_button(tmpbase,VALUE='View/Inspect Data',UVALUE='INSPECT')
tmp = widget_button(tmpbase,VALUE='Plot Data',UVALUE='PLOT')
tmp = widget_button(tmpbase,VALUE='Process Data',UVALUE='PROCESS')

IF NOT(Keyword_Set(no_xray)) THEN BEGIN
  tmpbase = widget_base(Bbox,/row)
  tmp = widget_button(tmpbase,VALUE='xF0',UVALUE='EXECUTE')
  tmp = widget_button(tmpbase,VALUE='xF1F2',UVALUE='EXECUTE')
  tmp = widget_button(tmpbase,VALUE='xCrossSec',UVALUE='EXECUTE')
  tmp = widget_button(tmpbase,VALUE='xFh',UVALUE='EXECUTE')
  tmp = widget_button(tmpbase,VALUE='Other...',UVALUE='EXECUTE')
ENDIF

IF N_Elements(no_block) EQ 0 THEN no_block=1
wids = {base:base, path:Bpath, list:Blist, sel:Bsel, listFiles:BlistFiles}
state = { wids:wids, ListSel:-1, no_block:no_block}
widget_control,Widget_Info(base,/Child),set_uvalue=state


widget_control,base,/REALIZE
xmanager,'DABAX',base,GROUP=group,No_Block=no_block
;
end
