;
;==================================================================================================
;
PRO xplot2d_setcolorlimits,wid,min=min1,max=max1, $
  interactive=interactive, fullrange=fullrange,refresh=refresh,  $
  stretch=stretch, changeStretch=changeStretch

Widget_Control,wid,Get_Uvalue=info

pData=info.data->Value([info.image_num],/pointer)
img = *pData
tmp = Where(img LT 0)
IF tmp[0] EQ -1 THEN BEGIN
          Print,'Masked values: None'
ENDIF ELSE BEGIN
          Print,'Masked values: ',N_Elements(tmp),' over',N_Elements(img)
          img=img[where(img GE 0)]
ENDELSE

; limits of data

mind = Min(*pData)
maxd = Max(*pData)


IF Keyword_Set(fullrange) THEN BEGIN
	min1 = MinD
	max1 = MaxD
ENDIF


IF Keyword_Set(interactive) THEN BEGIN
         out     =  { minmax, min: info.min, max: info.max}
         titles = ['Min :',$
                'Max (set Max=Min for default):']
         XSCRMENU,out,titles=titles,/notype,action=action,$
               WTITLE='Min and max intensity to be displayed'
	 IF out.min EQ out.max THEN BEGIN
		pData=info.data->Value([info.image_num],/pointer)
		min1 = Min(*pData)
		max1 = Max(*pData)
	 ENDIF ELSE BEGIN
		min1 = out.min
		max1 = out.max
	 ENDELSE
ENDIF


IF Keyword_Set(stretch) THEN BEGIN
        data=histogram(img)
        ;xplot,lindgen(n_elements(data)),data,/No_Block,Window_Size=[600,400]
	; set first point to zero 
	data[0]=0
	data[N_Elements(data)-1]=0
	; upper cut
	IF Keyword_Set(changeStretch) THEN BEGIN
         sValue = info.stretch*100.
         xEdit,sValue,Text='New value: ',Title='Stretch',Action=act    , $
           dialog_Parent=wid,InfoText='Stretch edge (% of the maximum intensity value)'
         IF act EQ 'CANCEL' THEN RETURN
         info.stretch=sValue/100.
         Widget_Control,wid, Set_UValue=info ; register the changes
	ENDIF
        ibad = Where (data LE info.stretch*max(data,imax))
	IF ibad[0] NE -1 THEN BEGIN
	  igood1 = where(ibad LT imax)
	  igood2 = where(ibad GT imax)
	  IF igood1[0] EQ -1 OR igood2[0] EQ -1 THEN BEGIN
	    Message,/Info,'Nothing changed.'
	    RETURN
	  ENDIF
	  ; get the extrema
	  igood1=ibad[Max(igood1)]
	  igood2=ibad[Min(igood2)]
	  min1 = igood1 > minD
	  max1 = igood2 < maxD
	ENDIF ELSE BEGIN
	  Message,/Info,'Nothing changed.'
	  RETURN
	ENDELSE
ENDIF



info.min=min1
info.max=max1


widget_control,wId,set_uvalue=info
IF Keyword_Set(refresh) THEN xplot2d_display_image,wid
Xplot2d_Set_Comment,wid,'Color table covers range: '+Vect2String([min1,max1])+', data range: '+ $
	Vect2String([minD,maxD])
END
