
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
PRO writeset,set,file
;+
; NAME:
;	ROUTINE_NAME
;
; PURPOSE:
;	This procedure writes a set of data in the specified file
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	WRITESET, set, 'filename'
;
; INPUTS:
;	set:	fltarr(ncol,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	Creates or overwrites a file.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		WRITESET,set,'exit.out'
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	May, 1993	Any additional mods get described here. 
;-
on_error,2
;
; writes a set to a file
;
openw,Unit,file,/get_lun
printf,Unit,set
free_lun,Unit
;print, n_elements(set(0,*)), ' lines written in the file: ',file
message,/info, strcompress(n_elements(set(0,*)),/rem)+ $
  ' lines written in the file: '+file
return
end
