;+
; NAME:
;	CHPARM
;
; PURPOSE:
;	Change the value of a SHADOW namelist file
;
; CATEGORY:
;	SHADOW 
;
; CALLING SEQUENCE:
;	chparm,'infile','variable_to_change',new_val
;
; INPUTS:
;	infile: The shadow namelist file: i.e. 'start.00'
;	variable_to_change: The variable name (i.e. 'fgrid')
;	new_val: The variable new value (i.e. 1)
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	error:	the error flag
; OUTPUTS:
;	mv the input file to a new one with .OLD extension
;	Creates a new file with the same name and the new variable values.
; OPTIONAL OUTPUTS:
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	Unknown. Bugs: It does not work with variable names that are arrays
; RESTRICTIONS:
;
; PROCEDURE:
;	Play with string managing functions..., uses strep function
;	of R. Sterner (Johns Hopkins University)
;
; EXAMPLE:
;	chparm,'start.00','fgrid',3
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, ESRF, 95-03-21
;	00/13/03: srio@esrf.fr rewritten using read/write_gfile.
;-

PRO chparm,file,var,newval,error=error
;
catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('CHPARM: Error caught: '+$
        !err_string,/error)
   error = 1
   return
endif
;
;if n_params() NE 3 then begin
;  print,'CHPARM: Usage: chparm,file,variable,newvalue
;  error = 1
;  return
;end
error = 0
;
;
a=Read_GFile(file)

tn = Tag_Names(a)
itmp = Where(tn EQ strupcase(var))
IF itmp[0] EQ -1 THEN BEGIN
  Message,'CHPARM: variable not found: '+var
ENDIF

Print,'CHPARM: Old '+var+' value: ',a.(itmp[0])
a.(itmp[0])=newval
Print,'CHPARM: New '+var+' value: ',a.(itmp[0])

CASE sdep() OF
  'UNIX': command = '/bin/mv '+file+' '+file+'.OLD'
  'WINDOWS': command = 'rename '+file+' '+file+'.OLD'
  'ELSE': command = 'Error: Platform not supported'
ENDCASE
Print,command  &  Spawn,command

Write_GFile,a,file

END


