FUNCTION blv_var_title,varname
; Returns a title for an associated variable

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_var_title: error caught: '+!error_state.msg)
   RETURN,''
ENDIF


n_var=N_Elements(varname)
titles = StrArr(n_var)
FOR i=0L,n_var-1 DO BEGIN
  varname1=varName[i]
  CASE StrUpCase(varname1) OF
	'RWIDX1': title='Semiwidth [cm] (-X)'
	'RWIDX2': title='Semiwidth [cm] (+X)'
	'RWID1': title='Semiwidth [cm] (-X)'
	'RWID2': title='Semiwidth [cm] (+X)'
	'RLEN1': title='Semilength [cm] (-Y)'
	'RLEN2': title='Semilength [cm] (+Y)'
	'T_SOURCE': title='Distance [cm] from previous module'
	'T_IMAGE': title='Distance [cm] to next module'
	'T_INCIDENCE': title='Incidence angle [deg]'
	'T_REFLECTION': title='Reflection angle [deg]'
	'ALPHA': title='Orientation angle [deg]'
	else: Message,'Case not found: '+varName1
  ENDCASE
  titles[i]=title
ENDFOR
IF n_var EQ 1 THEN titles=titles[0]
RETURN,titles
END

